/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.subsystems;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.osgi.framework.Bundle;

public class DStoreServerDefaults {
    public static String COMMAND = null;
    public static String CLASSPATH = null;
    public static boolean DSTORE_TRACING = false;
    private static final String DEFAULTS_RESOURCE_PATH = "/data/dstore-server.properties";
    private static final String DSTORE_TRACING_OPTION = "org.eclipse.ptp.rdt.ui/debug/dstore/tracing";

    public static void loadDefaults() throws CoreException {
        String option;
        if (UIPlugin.getDefault().isDebugging() && (option = Platform.getDebugOption((String)DSTORE_TRACING_OPTION)) != null) {
            DSTORE_TRACING = option.equalsIgnoreCase("true");
        }
        Bundle bundle = UIPlugin.getDefault().getBundle();
        Properties properties = DStoreServerDefaults.read(new Path(DEFAULTS_RESOURCE_PATH), bundle);
        COMMAND = DStoreServerDefaults.getString(bundle, properties, "COMMAND");
        CLASSPATH = DStoreServerDefaults.getString(bundle, properties, "CLASSPATH");
        assert (COMMAND != null);
        assert (CLASSPATH != null);
    }

    public static Properties read(Path defaultsPropertiesPath, Bundle bundle) throws CoreException {
        Properties properties = new Properties();
        try {
            InputStream inStream = FileLocator.openStream((Bundle)bundle, (IPath)defaultsPropertiesPath, (boolean)false);
            properties.load(inStream);
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), "Failed to read DStore Server properties file"));
        }
        return properties;
    }

    public static String getString(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), NLS.bind((String)"Missing default value for {0} while reading DStore Server properties", (Object)key)));
        }
        return value;
    }

    public static int getInteger(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = DStoreServerDefaults.getString(bundle, properties, key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), NLS.bind((String)"Invalid value for {0} while reading DStore Server properties", (Object)key)));
        }
    }

    public static boolean getBoolean(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = DStoreServerDefaults.getString(bundle, properties, key);
        return Boolean.parseBoolean(value);
    }
}

