/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.ptp.rdt.ui.wizards.DStoreServerWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DStoreEnvironmentPage
extends Composite {
    private Table table;
    private Button addButton;
    private Button removeButton;
    private ListenerList modifyListeners = new ListenerList();

    public DStoreEnvironmentPage(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Group group = new Group((Composite)this, 0);
        group.setText("Environment Variables");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableComp = new Composite((Composite)group, 0);
        tableComp.setLayout((Layout)new GridLayout(2, false));
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(tableComp, 2048);
        GridData data = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn col1 = new TableColumn(this.table, 0);
        col1.setText("Variable");
        col1.setWidth(100);
        col1.setResizable(true);
        TableColumn col2 = new TableColumn(this.table, 0);
        col2.setText("Value");
        col2.setWidth(200);
        col2.setResizable(true);
        Composite buttonComp = new Composite((Composite)group, 0);
        buttonComp.setLayout((Layout)new GridLayout(1, false));
        buttonComp.setLayoutData((Object)new GridData(4, 4, false, true));
        this.addButton = new Button(buttonComp, 0);
        this.addButton.setText("Add...");
        GridData addButtonData = new GridData(4, 4, false, false);
        addButtonData.widthHint = 80;
        this.addButton.setLayoutData((Object)addButtonData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DStoreEnvironmentPage.this.handleAddButtonSelected();
            }
        });
        this.removeButton = new Button(buttonComp, 0);
        this.removeButton.setText("Remove");
        GridData removeButtonData = new GridData(4, 4, false, false);
        removeButtonData.widthHint = 80;
        this.removeButton.setLayoutData((Object)removeButtonData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DStoreEnvironmentPage.this.handleRemoveButtonSelected();
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add((Object)listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove((Object)listener);
    }

    public String getEnvironment() {
        String env = "";
        int i = 0;
        while (i < this.table.getItemCount()) {
            if (i > 0) {
                env = String.valueOf(env) + "\n";
            }
            TableItem item = this.table.getItem(i);
            env = String.valueOf(env) + item.getText(0) + "=" + item.getText(1);
            ++i;
        }
        return env;
    }

    public void setEnvironment(String env) {
        this.table.clearAll();
        if (env != null) {
            String[] stringArray = env.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String envs = stringArray[n2];
                String[] envVar = envs.split("=");
                if (envVar.length == 2) {
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(0, envVar[0]);
                    item.setText(1, envVar[1]);
                }
                ++n2;
            }
        }
    }

    protected void handleAddButtonSelected() {
        EnvInputDialog dialog = new EnvInputDialog(this.getShell());
        if (dialog.open() != 0) {
            return;
        }
        String var = dialog.getVariable();
        String value = dialog.getValue();
        if (var != null && value != null && var.length() > 0 && value.length() > 0) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, var.trim());
            item.setText(1, value.trim());
        }
        Event e = new Event();
        e.data = DStoreServerWidget.FieldModifier.VALUE_DSTORE_ENV;
        this.notifyListeners(new ModifyEvent(e));
    }

    protected void handleRemoveButtonSelected() {
        int index = this.table.getSelectionIndex();
        if (index >= 0) {
            this.table.remove(index);
        }
    }

    private void notifyListeners(ModifyEvent e) {
        Object[] objectArray = this.modifyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ModifyListener)listener).modifyText(e);
            ++n2;
        }
    }

    public class EnvInputDialog
    extends Dialog {
        private Text variableText;
        private Text valueText;
        private String variable;
        private String value;

        public EnvInputDialog(Shell parentShell) {
            super(parentShell);
        }

        public String getValue() {
            return this.value;
        }

        public String getVariable() {
            return this.variable;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.value = this.valueText.getText();
                this.variable = this.variableText.getText();
            } else {
                this.value = null;
                this.variable = null;
            }
            super.buttonPressed(buttonId);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label variableLabel = new Label(composite, 64);
            variableLabel.setText("Variable");
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            variableLabel.setLayoutData((Object)data);
            variableLabel.setFont(parent.getFont());
            this.variableText = new Text(composite, 2052);
            this.variableText.setLayoutData((Object)new GridData(768));
            Label valueLabel = new Label(composite, 64);
            valueLabel.setText("Variable");
            data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            valueLabel.setLayoutData((Object)data);
            valueLabel.setFont(parent.getFont());
            this.valueText = new Text(composite, 2052);
            this.valueText.setLayoutData((Object)new GridData(768));
            EnvInputDialog.applyDialogFont((Control)composite);
            return composite;
        }
    }
}

