/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.wizards.DStoreServerWidget;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.widgets.RemoteDirectoryWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DStoreIndexPage
extends Composite {
    private String fDefaultPath = null;
    private RemoteDirectoryWidget fDirectoryWidget;
    private ListenerList modifyListeners = new ListenerList();

    public DStoreIndexPage(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.fDirectoryWidget = new RemoteDirectoryWidget((Composite)this, 0, Messages.getString("IndexFileLocationWidget.0"), this.fDefaultPath);
        this.fDirectoryWidget.setBrowseMessage("Select Index File Location");
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        this.fDirectoryWidget.setLayoutData((Object)data);
        this.fDirectoryWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DStoreIndexPage.this.fDefaultPath = DStoreIndexPage.this.fDirectoryWidget.getLocationPath();
                e.data = DStoreServerWidget.FieldModifier.VALUE_INDEX_LOCATION;
                DStoreIndexPage.this.notifyListeners(e);
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add((Object)listener);
    }

    public String getLocationPath() {
        return this.fDirectoryWidget.getLocationPath();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove((Object)listener);
    }

    public void setConnection(IRemoteServices services, IRemoteConnection conn) {
        this.fDirectoryWidget.setConnection(services, conn);
    }

    public void setLocationPath(String path) {
        this.fDirectoryWidget.setLocationPath(path);
    }

    private void notifyListeners(ModifyEvent e) {
        Object[] objectArray = this.modifyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ModifyListener)listener).modifyText(e);
            ++n2;
        }
    }
}

