/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.rdt.ui.wizards.DStoreServerWidget;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.widgets.RemoteDirectoryWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DStoreServerPage
extends Composite {
    private Text text;
    private RemoteDirectoryWidget fLocationWidget;
    private ListenerList modifyListeners = new ListenerList();

    public DStoreServerPage(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.fLocationWidget = new RemoteDirectoryWidget((Composite)this, 0, "DStore Location", null);
        this.fLocationWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                e.data = DStoreServerWidget.FieldModifier.VALUE_DSTORE_LOCATION;
                DStoreServerPage.this.notifyListeners(e);
            }
        });
        Group group = new Group((Composite)this, 0);
        group.setText("Server Command");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite textComp = new Composite((Composite)group, 0);
        textComp.setLayout((Layout)new GridLayout(2, false));
        textComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(textComp, 0);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        label.setText("Command:");
        this.text = new Text(textComp, 2048);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.text.getLineHeight() * 3;
        this.text.setLayoutData((Object)data);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                e.data = DStoreServerWidget.FieldModifier.VALUE_DSTORE_COMMAND;
                DStoreServerPage.this.notifyListeners(e);
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add((Object)listener);
    }

    public String getLocationPath() {
        return this.fLocationWidget.getLocationPath();
    }

    public String getServerCommand() {
        return this.text.getText();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove((Object)listener);
    }

    public void setConnection(IRemoteServices services, IRemoteConnection conn) {
        this.fLocationWidget.setConnection(services, conn);
    }

    public void setLocationPath(String path) {
        this.fLocationWidget.setLocationPath(path);
    }

    public void setServerCommand(String command) {
        this.text.setText(command);
    }

    private void notifyListeners(ModifyEvent e) {
        Object[] objectArray = this.modifyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ModifyListener)listener).modifyText(e);
            ++n2;
        }
    }
}

