/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.rdt.ui.wizards.DStoreEnvironmentPage;
import org.eclipse.ptp.rdt.ui.wizards.DStoreIndexPage;
import org.eclipse.ptp.rdt.ui.wizards.DStoreServerPage;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DStoreServerWidget
extends Composite {
    private ListenerList modifyListeners = new ListenerList();
    private DStoreServerPage fServerPage;
    private DStoreEnvironmentPage fEnvironmentPage;
    private DStoreIndexPage fIndexPage;

    public DStoreServerWidget(Composite parent, int style) {
        super(parent, style);
        this.setFont(parent.getFont());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        TabFolder folder = new TabFolder((Composite)this, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(this.getFont());
        this.fServerPage = new DStoreServerPage((Composite)folder, 0);
        this.fServerPage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DStoreServerWidget.this.notifyListeners(e);
            }
        });
        TabItem item = new TabItem(folder, 0);
        item.setText("Server");
        item.setControl((Control)this.fServerPage);
        this.fEnvironmentPage = new DStoreEnvironmentPage((Composite)folder, 0);
        this.fEnvironmentPage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DStoreServerWidget.this.notifyListeners(e);
            }
        });
        item = new TabItem(folder, 0);
        item.setText("Environment");
        item.setControl((Control)this.fEnvironmentPage);
        this.fIndexPage = new DStoreIndexPage((Composite)folder, 0);
        this.fIndexPage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DStoreServerWidget.this.notifyListeners(e);
            }
        });
        item = new TabItem(folder, 0);
        item.setText("Index");
        item.setControl((Control)this.fIndexPage);
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add((Object)listener);
    }

    public String getDStoreCommand() {
        return this.fServerPage.getServerCommand();
    }

    public String getDStoreEnvironment() {
        return this.fEnvironmentPage.getEnvironment();
    }

    public String getDStoreLocation() {
        return this.fServerPage.getLocationPath();
    }

    public String getIndexLocation() {
        return this.fIndexPage.getLocationPath();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove((Object)listener);
    }

    public void setConnection(IRemoteServices services, IRemoteConnection conn) {
        this.fServerPage.setConnection(services, conn);
        this.fIndexPage.setConnection(services, conn);
    }

    public void setDStoreCommand(String command) {
        this.fServerPage.setServerCommand(command);
    }

    public void setDStoreEnvironment(String env) {
        this.fEnvironmentPage.setEnvironment(env);
    }

    public void setDStoreLocation(String path) {
        this.fServerPage.setLocationPath(path);
    }

    public void setIndexLocation(String path) {
        this.fIndexPage.setLocationPath(path);
    }

    private void notifyListeners(ModifyEvent e) {
        Object[] objectArray = this.modifyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ModifyListener)listener).modifyText(e);
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FieldModifier {
        VALUE_DSTORE_LOCATION,
        VALUE_DSTORE_COMMAND,
        VALUE_DSTORE_ENV,
        VALUE_INDEX_LOCATION;

    }
}

