/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.ll.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.rm.core.rmsystem.AbstractRemoteResourceManagerServiceProvider;
import org.eclipse.ptp.rm.ibm.ll.core.IBMLLPreferenceManager;
import org.eclipse.ptp.rm.ibm.ll.core.rmsystem.IBMLLResourceManager;
import org.eclipse.ptp.rm.ibm.ll.core.rmsystem.IIBMLLResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;

public class LLServiceProvider
extends AbstractRemoteResourceManagerServiceProvider
implements IIBMLLResourceManagerConfiguration {
    private static final String TAG_LL_LIBPATH = "LL_LibraryPath";
    private static final String TAG_TRACE_OPTION = "LL_Trace";
    private static final String TAG_INFO_MESSAGE = "LL_ProxyInfoMessage";
    private static final String TAG_WARNING_MESSAGE = "LL_ProxyWarningMessage";
    private static final String TAG_ERROR_MESSAGE = "LL_ProxyErrorMessage";
    private static final String TAG_FATAL_MESSAGE = "LL_ProxyFatalMessage";
    private static final String TAG_ARGS_MESSAGE = "LL_ProxyArgsMessage";
    private static final String TAG_DEBUG_SUSPEND = "LL_DebugSuspend";
    private static final String TAG_GUI_INFO_MESSAGE = "LL_GuiInfoMessage";
    private static final String TAG_GUI_WARNING_MESSAGE = "LL_GuiWarningMessage";
    private static final String TAG_GUI_ERROR_MESSAGE = "LL_GuiErrorMessage";
    private static final String TAG_GUI_FATAL_MESSAGE = "LL_GuiFatalMessage";
    private static final String TAG_GUI_TRACE_MESSAGE = "LL_GuiTraceMessage";
    private static final String TAG_GUI_ARGS_MESSAGE = "LL_GuiArgsMessage";
    private static final String TAG_DEFAULT_MULTICLUSTER = "LL_DefaultMulticluster";
    private static final String TAG_FORCE_PROXY_LOCAL = "LL_ForceProxyLocal";
    private static final String TAG_FORCE_PROXY_MULTICLUSTER = "LL_ForceProxyMulticluster";
    private static final String TAG_SUPPRESS_TEMPLATE_WRITE = "LL_SuppressTemplateWrite";
    private static final String TAG_TEMPLATE_WRITE_ALWAYS = "LL_TemplateWriteAlways";
    private static final String TAG_TEMPLATE_FILE = "LL_TemplateFile";
    private static final String TAG_MIN_NODE_POLL = "LL_MinNodePollInterval";
    private static final String TAG_MAX_NODE_POLL = "LL_MNodePollInterval";
    private static final String TAG_JOB_POLL = "LL_JobPollInterval";
    private Preferences preferences = IBMLLPreferenceManager.getPreferences();

    public LLServiceProvider() {
        this.setDescription("IBM LL Resource Manager");
    }

    public LLServiceProvider(IServiceProvider provider) {
        super(provider);
    }

    public IServiceProviderWorkingCopy copy() {
        return new LLServiceProvider((IServiceProvider)this);
    }

    public IResourceManagerControl createResourceManager() {
        IPUniverseControl universe = (IPUniverseControl)PTPCorePlugin.getDefault().getUniverse();
        return new IBMLLResourceManager(Integer.valueOf(universe.getNextResourceManagerId()), universe, (IResourceManagerConfiguration)this);
    }

    public String getArgsMessage() {
        return this.getString(TAG_ARGS_MESSAGE, this.preferences.getString("ProxyArgsMessage"));
    }

    public String getDebugLoop() {
        return this.getString(TAG_DEBUG_SUSPEND, this.preferences.getString("ProxyDebugLoop"));
    }

    public String getDefaultMulticluster() {
        return this.getString(TAG_DEFAULT_MULTICLUSTER, this.preferences.getString("ProxyLoadLevelerMulticlusterDefault"));
    }

    public String getErrorMessage() {
        return this.getString(TAG_ERROR_MESSAGE, this.preferences.getString("ProxyErrorMessage"));
    }

    public String getFatalMessage() {
        return this.getString(TAG_FATAL_MESSAGE, this.preferences.getString("ProxyFatalMessage"));
    }

    public String getForceProxyLocal() {
        return this.getString(TAG_FORCE_PROXY_LOCAL, this.preferences.getString("ProxyLoadLevelerMulticlusterForceLocal"));
    }

    public String getForceProxyMulticluster() {
        return this.getString(TAG_FORCE_PROXY_MULTICLUSTER, this.preferences.getString("ProxyLoadLevelerMulticlusterForceMulticluster"));
    }

    public String getGuiArgsMessage() {
        return this.getString(TAG_GUI_ARGS_MESSAGE, this.preferences.getString("GuiArgsMessage"));
    }

    public String getGuiErrorMessage() {
        return this.getString(TAG_GUI_ERROR_MESSAGE, this.preferences.getString("GuiErrorMessage"));
    }

    public String getGuiFatalMessage() {
        return this.getString(TAG_GUI_FATAL_MESSAGE, this.preferences.getString("GuiFatalMessage"));
    }

    public String getGuiInfoMessage() {
        return this.getString(TAG_GUI_INFO_MESSAGE, this.preferences.getString("GuiInfoMessage"));
    }

    public String getGuiTraceMessage() {
        return this.getString(TAG_GUI_TRACE_MESSAGE, this.preferences.getString("GuiTraceMessage"));
    }

    public String getGuiWarningMessage() {
        return this.getString(TAG_GUI_WARNING_MESSAGE, this.preferences.getString("GuiWarningMessage"));
    }

    public String getInfoMessage() {
        return this.getString(TAG_INFO_MESSAGE, this.preferences.getString("ProxyInfoMessage"));
    }

    public int getJobPolling() {
        return this.getInt(TAG_JOB_POLL, this.preferences.getInt("ProxyJobPolling"));
    }

    public String getLibraryPath() {
        return this.getString(TAG_LL_LIBPATH, this.preferences.getString("ProxyLoadLevelerLibraryPath"));
    }

    public int getMaxNodePolling() {
        return this.getInt(TAG_MAX_NODE_POLL, this.preferences.getInt("ProxyMaximumNodePolling"));
    }

    public int getMinNodePolling() {
        return this.getInt(TAG_MIN_NODE_POLL, this.preferences.getInt("ProxyMinimumNodePolling"));
    }

    public String getResourceManagerId() {
        return this.getId();
    }

    public String getSuppressTemplateWrite() {
        return this.getString(TAG_SUPPRESS_TEMPLATE_WRITE, this.preferences.getString("ProxyLoadLevelerTemplateNever"));
    }

    public String getTemplateFile() {
        return this.getString(TAG_TEMPLATE_FILE, this.preferences.getString("ProxyLoadLevelerTemplateFile"));
    }

    public String getTemplateWriteAlways() {
        return this.getString(TAG_TEMPLATE_WRITE_ALWAYS, this.preferences.getString("ProxyLoadLevelerTemplateAlways"));
    }

    public String getTraceOption() {
        return this.getString(TAG_TRACE_OPTION, this.preferences.getString("ProxyTraceMessage"));
    }

    public String getWarningMessage() {
        return this.getString(TAG_WARNING_MESSAGE, this.preferences.getString("ProxyWarningMessage"));
    }

    public boolean isConfigured() {
        return true;
    }

    public void setArgsMessage(String option) {
        this.putString(TAG_ARGS_MESSAGE, option);
    }

    public void setDebugLoop(String option) {
        this.putString(TAG_DEBUG_SUSPEND, option);
    }

    public void setDefaultMulticluster(String option) {
        this.putString(TAG_DEFAULT_MULTICLUSTER, option);
    }

    public void setDefaultNameAndDesc() {
        String name = "IBMLL";
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals("")) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription("IBMLL Resource Manager");
    }

    public void setErrorMessage(String option) {
        this.putString(TAG_ERROR_MESSAGE, option);
    }

    public void setFatalMessage(String option) {
        this.putString(TAG_FATAL_MESSAGE, option);
    }

    public void setForceProxyLocal(String option) {
        this.putString(TAG_FORCE_PROXY_LOCAL, option);
    }

    public void setForceProxyMulticluster(String option) {
        this.putString(TAG_FORCE_PROXY_MULTICLUSTER, option);
    }

    public void setGuiArgsMessage(String option) {
        this.putString(TAG_GUI_ARGS_MESSAGE, option);
    }

    public void setGuiErrorMessage(String option) {
        this.putString(TAG_GUI_ERROR_MESSAGE, option);
    }

    public void setGuiFatalMessage(String option) {
        this.putString(TAG_GUI_FATAL_MESSAGE, option);
    }

    public void setGuiInfoMessage(String option) {
        this.putString(TAG_GUI_INFO_MESSAGE, option);
    }

    public void setGuiTraceMessage(String option) {
        this.putString(TAG_GUI_TRACE_MESSAGE, option);
    }

    public void setGuiWarningMessage(String option) {
        this.putString(TAG_GUI_WARNING_MESSAGE, option);
    }

    public void setInfoMessage(String option) {
        this.putString(TAG_INFO_MESSAGE, option);
    }

    public void setJobPolling(int value) {
        this.putInt(TAG_JOB_POLL, value);
    }

    public void setLibraryPath(String path) {
        this.putString(TAG_LL_LIBPATH, path);
    }

    public void setMaxNodePolling(int value) {
        this.putInt(TAG_MAX_NODE_POLL, value);
    }

    public void setMinNodePolling(int value) {
        this.putInt(TAG_MIN_NODE_POLL, value);
    }

    public void setSuppressTemplateWrite(String option) {
        this.putString(TAG_SUPPRESS_TEMPLATE_WRITE, option);
    }

    public void setTemplateFile(String file) {
        this.putString(TAG_TEMPLATE_FILE, file);
    }

    public void setTemplateWriteAlways(String option) {
        this.putString(TAG_TEMPLATE_WRITE_ALWAYS, option);
    }

    public void setTraceOption(String option) {
        this.putString(TAG_TRACE_OPTION, option);
    }

    public void setWarningMessage(String option) {
        this.putString(TAG_WARNING_MESSAGE, option);
    }
}

