/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.event;

import org.eclipse.ptp.internal.proxy.event.ProxyErrorEvent;
import org.eclipse.ptp.internal.proxy.event.ProxyMessageEvent;
import org.eclipse.ptp.internal.proxy.event.ProxyOKEvent;
import org.eclipse.ptp.proxy.event.AbstractProxyEvent;
import org.eclipse.ptp.proxy.event.AbstractProxyEventFactory;
import org.eclipse.ptp.proxy.event.IProxyErrorEvent;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.event.IProxyOKEvent;
import org.eclipse.ptp.proxy.packet.ProxyPacket;

public class ProxyEventFactory
extends AbstractProxyEventFactory {
    public IProxyEvent toEvent(ProxyPacket packet) {
        AbstractProxyEvent evt = null;
        switch (packet.getID()) {
            case 0: {
                evt = new ProxyOKEvent(packet.getTransID());
                break;
            }
            case 1: {
                evt = new ProxyMessageEvent(packet.getTransID(), packet.getArgs());
                break;
            }
            case 5: {
                evt = new ProxyErrorEvent(packet.getTransID(), packet.getArgs());
            }
        }
        return evt;
    }

    public static IProxyOKEvent newOKEvent(int transID) {
        return new ProxyOKEvent(transID);
    }

    public static IProxyErrorEvent newErrorEvent(int transID, int code, String message) {
        String[] args = new String[]{"errorCode=" + code, "errorMsg=" + message};
        return new ProxyErrorEvent(transID, args);
    }
}

