/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.stringeditor.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.localization.stringeditor.EditorExtensionLoader;
import org.eclipse.sequoyah.localization.stringeditor.StringEditorPlugin;
import org.eclipse.sequoyah.localization.stringeditor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.IModelChangedListener;
import org.eclipse.sequoyah.localization.stringeditor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.TranslationInfo;
import org.eclipse.sequoyah.localization.stringeditor.editor.EditorSession;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorCellHighlighter;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorColumnLabelProvider;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorColumnViewerEditorActivationListener;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorViewerContentProvider;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorViewerEditableTooltipSupport;
import org.eclipse.sequoyah.localization.stringeditor.editor.StringEditorViewerModel;
import org.eclipse.sequoyah.localization.stringeditor.editor.TableComparator;
import org.eclipse.sequoyah.localization.stringeditor.editor.input.IInputChangeListener;
import org.eclipse.sequoyah.localization.stringeditor.editor.input.IStringEditorInput;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.AddColumnOperation;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.AddKeyOperation;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.AddKeysOperation;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.CloneOperation;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.EditCellOperation;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.EditCellsOperation;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.EditorOperation;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.RemoveColumnOperation;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.RemoveKeyOperation;
import org.eclipse.sequoyah.localization.stringeditor.editor.operations.RevertColumnToSavedStateOperation;
import org.eclipse.sequoyah.localization.stringeditor.i18n.Messages;
import org.eclipse.sequoyah.localization.stringeditor.providers.ContentProvider;
import org.eclipse.sequoyah.localization.stringeditor.providers.ICellValidator;
import org.eclipse.sequoyah.localization.stringeditor.providers.IOperationProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.EditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditorPart
extends EditorPart {
    private final IUndoContext undoContext;
    private final IOperationHistory operationHistory;
    private Set<String> changedColumns = new HashSet<String>();
    private boolean needToPromptFileSystemChange = false;
    private final IInputChangeListener inputChangeListener = new IInputChangeListener(){

        public void columnChanged(String string) {
            StringEditorPart.this.markColumnAsChanged(string);
        }
    };
    private TableViewer viewer = null;
    private static final int SIZE_HINT = 14;
    private ColumnSelectionListener listener;
    private int activeColumn;
    private ViewerCell activeRow = null;
    private ContentProvider contentProvider;
    private EditorSession session;
    private static String SORTER_PROPERTY_NAME = "sorter";
    private static String PREVIOUS_WIDTH_PROPERTY_NAME = "previous.width";
    private IProject associatedProject = null;
    private Button highlightChangesButton = null;
    private Button expandRowButton = null;
    private boolean highlightChanges = false;
    private boolean expandRow = true;
    private Text searchText = null;
    private String searchString = "";
    private Button showCellCommentsButton = null;
    private boolean showCellComments = false;
    private Text filterByKeyText = null;
    private String filterByKeyString = "";
    private Button applyFilterButton = null;
    private Form editorComposite;
    private Image errorImage;
    private Image warningImage;
    private Image okImage;

    private CellInfo getCellInfo(String string, String string2) {
        CellInfo cellInfo = null;
        cellInfo = this.getEditorInput().getValue(string, string2);
        return cellInfo;
    }

    public StringEditorPart() {
        this.undoContext = new ObjectUndoContext((Object)this);
        this.operationHistory = OperationHistoryFactory.getOperationHistory();
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public IProject getAssociatedProject() {
        return this.associatedProject;
    }

    public IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        try {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            this.contentProvider = EditorExtensionLoader.getInstance().getContentProviderForFileInput(iFile);
            if (this.contentProvider == null) {
                throw new Exception("An input provider for the given file was not found: " + ((IFileEditorInput)iEditorInput).getFile().getLocation().toOSString());
            }
            IStringEditorInput iStringEditorInput = this.contentProvider.getEditorInput();
            IOperationProvider iOperationProvider = this.contentProvider.getOperationProvider();
            ICellValidator iCellValidator = this.contentProvider.getValidator();
            iStringEditorInput.init(iFile.getProject());
            iOperationProvider.init(iFile.getProject());
            iCellValidator.init(iFile.getProject());
            this.session = EditorSession.loadFromProject(iFile.getProject());
            this.associatedProject = iFile.getProject();
            this.setSite((IWorkbenchPartSite)iEditorSite);
            this.setInput(iStringEditorInput);
            this.setPartName(iStringEditorInput.getTitle());
            iStringEditorInput.addInputChangeListener(this.inputChangeListener);
            this.errorImage = new Image((Device)Display.getDefault(), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK").getImageData().scaledTo(16, 16));
            this.warningImage = new Image((Device)Display.getDefault(), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK").getImageData().scaledTo(16, 16));
            this.okImage = new Image((Device)Display.getDefault(), StringEditorPlugin.imageDescriptorFromPlugin((String)StringEditorPlugin.PLUGIN_ID, (String)Messages.StringEditorPart_6).getImageData());
        }
        catch (Exception exception) {
            this.handleInitFailure(exception, iEditorInput, iEditorSite);
        }
    }

    private void handleInitFailure(Exception exception, IEditorInput iEditorInput, IEditorSite iEditorSite) {
        MessageDialog.openError((Shell)new Shell(), (String)"Error loading editor. Some available editor will be opened", (String)exception.getMessage());
        IEditorDescriptor[] iEditorDescriptorArray = PlatformUI.getWorkbench().getEditorRegistry().getEditors("*." + ((IFileEditorInput)iEditorInput).getFile().getLocation().getFileExtension());
        if (iEditorDescriptorArray.length > 0) {
            int n = 0;
            IEditorDescriptor iEditorDescriptor = null;
            while (n < iEditorDescriptorArray.length && iEditorDescriptor == null) {
                if (!iEditorDescriptorArray[n].getId().equals(iEditorSite.getId())) {
                    iEditorDescriptor = iEditorDescriptorArray[n];
                }
                ++n;
            }
            if (iEditorDescriptor != null) {
                try {
                    iEditorSite.getPage().openEditor(iEditorInput, iEditorDescriptor.getId());
                }
                catch (PartInitException partInitException) {}
            }
            iEditorSite.getPage().closeEditor((IEditorPart)this, false);
        }
    }

    public IProgressMonitor getProgressMonitor() {
        return this.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    private void createOptionsSection(FormToolkit formToolkit, final Form form) {
        GridData gridData = new GridData(4, 4, true, false, 4, 1);
        GridLayout gridLayout = new GridLayout(5, false);
        ExpandableComposite expandableComposite = formToolkit.createExpandableComposite(form.getBody(), 2);
        expandableComposite.setLayoutData((Object)gridData);
        expandableComposite.setText(Messages.StringEditorPart_OptionsText);
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                form.layout(true);
            }
        });
        gridData = new GridData(4, 4, true, false, 6, 1);
        Composite composite = formToolkit.createComposite((Composite)expandableComposite);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        expandableComposite.setClient((Control)composite);
        this.expandRowButton = formToolkit.createButton(composite, Messages.StringEditorPart_ExpandRows, 32);
        gridData = new GridData(4, 4, true, false, 2, 1);
        this.expandRowButton.setLayoutData((Object)gridData);
        this.expandRowButton.setSelection(new Boolean(this.expandRow).booleanValue());
        this.expandRowButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StringEditorPart.this.expandRow = ((Button)selectionEvent.widget).getSelection();
                StringEditorPart.this.viewer.getTable().setRedraw(true);
                StringEditorPart.this.viewer.getTable().layout();
                StringEditorPart.this.viewer.getTable().update();
                StringEditorPart.this.viewer.getTable().redraw();
                int n = 0;
                while (n < StringEditorPart.this.viewer.getTable().getColumnCount()) {
                    StringEditorPart.this.viewer.getTable().getColumn(n).pack();
                    ++n;
                }
                StringEditorPart.this.viewer.getTable().pack();
                StringEditorPart.this.viewer.getTable().getParent().layout();
                StringEditorPart.this.viewer.getTable().getParent().setRedraw(true);
                StringEditorPart.this.viewer.getTable().getParent().redraw();
                StringEditorPart.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label = formToolkit.createLabel(composite, String.valueOf(Messages.StringEditorPart_SearchLabel) + Messages.StringEditorPart_7);
        gridData = new GridData(131072, 0x1000000, true, false, 1, 1);
        label.setLayoutData((Object)gridData);
        this.searchText = formToolkit.createText(composite, "", 2048);
        gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.searchText.setLayoutData((Object)gridData);
        this.searchText.addModifyListener((ModifyListener)new SearchTextModifyListener());
        this.showCellCommentsButton = formToolkit.createButton(composite, Messages.StringEditorPart_ShowCellCommentsButtonText, 32);
        gridData = new GridData(4, 4, true, false, 2, 1);
        this.showCellCommentsButton.setLayoutData((Object)gridData);
        this.showCellCommentsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StringEditorPart.this.showCellComments = ((Button)selectionEvent.widget).getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label2 = formToolkit.createLabel(composite, String.valueOf(Messages.StringEditorPart_FilterByKeyLabel) + Messages.StringEditorPart_9);
        gridData = new GridData(131072, 0x1000000, true, false, 1, 1);
        label2.setLayoutData((Object)gridData);
        this.filterByKeyText = formToolkit.createText(composite, "", 2048);
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.filterByKeyText.setLayoutData((Object)gridData);
        this.filterByKeyText.addModifyListener((ModifyListener)new FilterByKeyTextModifyListener());
        this.filterByKeyText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13) {
                    StringEditorPart.this.getEditorViewer().refresh();
                }
            }
        });
        this.applyFilterButton = formToolkit.createButton(composite, Messages.StringEditorPart_11, 8);
        gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.applyFilterButton.setLayoutData((Object)gridData);
        this.applyFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StringEditorPart.this.getEditorViewer().refresh();
            }
        });
        if (!Platform.getOS().equals("linux")) {
            this.highlightChangesButton = formToolkit.createButton(composite, Messages.StringEditorPart_HighlightChangesLabel, 32);
            gridData = new GridData(4, 4, true, false, 2, 1);
            this.highlightChangesButton.setLayoutData((Object)gridData);
            this.highlightChangesButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    StringEditorPart.this.highlightChanges = ((Button)selectionEvent.widget).getSelection();
                    for (RowInfo rowInfo : StringEditorPart.this.getModel().getRows().values()) {
                        StringEditorPart.this.viewer.update((Object)rowInfo, null);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
        }
    }

    public void createPartControl(Composite composite) {
        FormToolkit formToolkit = new FormToolkit(composite.getDisplay());
        IStringEditorInput iStringEditorInput = this.getEditorInput();
        List<ColumnInfo> list = iStringEditorInput.getColumns();
        this.editorComposite = formToolkit.createForm(composite);
        this.editorComposite.setText(iStringEditorInput.getName() != null && iStringEditorInput.getName().trim().length() > 0 ? iStringEditorInput.getName() : Messages.StringEditorPart_EditorTitle);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing = 0;
        this.editorComposite.getBody().setLayout((Layout)gridLayout);
        this.createOptionsSection(formToolkit, this.editorComposite);
        Table table = formToolkit.createTable(this.editorComposite.getBody(), 101122);
        this.viewer = new TableViewer(table);
        GridData gridData = new GridData(4, 4, true, true, 4, 1);
        this.viewer.getTable().setLayoutData((Object)gridData);
        this.listener = new ColumnSelectionListener(this.viewer);
        this.createColumn(Messages.StringEditorPart_KeyLabel, Messages.StringEditorPart_KeyTooltip, 0).getColumn().setMoveable(false);
        this.restoreSession(list);
        TableComparator tableComparator = new TableComparator();
        this.viewer.setComparator((ViewerComparator)tableComparator);
        this.viewer.getTable().setSortDirection(1024);
        this.viewer.setContentProvider((IContentProvider)new StringEditorViewerContentProvider());
        this.viewer.setInput((Object)new StringEditorViewerModel(list, this.getContentProvider().getValidator()));
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        StringEditorViewerEditableTooltipSupport.enableFor((ColumnViewer)this.viewer, 2, this);
        final MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                StringEditorPart.this.fillContextMenu(iMenuManager);
            }
        });
        this.viewer.getControl().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent menuDetectEvent) {
                int n = ((StringEditorPart)StringEditorPart.this).viewer.getTable().toControl((int)menuDetectEvent.x, (int)menuDetectEvent.y).x + StringEditorPart.this.viewer.getTable().getHorizontalBar().getSelection();
                int cfr_ignored_0 = ((StringEditorPart)StringEditorPart.this).viewer.getTable().toControl((int)menuDetectEvent.x, (int)menuDetectEvent.y).y;
                StringEditorPart.this.viewer.getTable().getVerticalBar().getSelection();
                int n2 = 0;
                int n3 = 0;
                while (n3 < StringEditorPart.this.viewer.getTable().getColumnCount()) {
                    if (n <= (n2 += StringEditorPart.this.viewer.getTable().getColumn(n3).getWidth())) {
                        StringEditorPart.this.activeColumn = n3;
                        int n4 = ((StringEditorPart)StringEditorPart.this).viewer.getTable().toControl((int)menuDetectEvent.x, (int)menuDetectEvent.y).x;
                        int n5 = ((StringEditorPart)StringEditorPart.this).viewer.getTable().toControl((int)menuDetectEvent.x, (int)menuDetectEvent.y).y;
                        StringEditorPart.this.activeRow = StringEditorPart.this.viewer.getCell(new Point(n4, n5));
                        break;
                    }
                    ++n3;
                }
                if (n >= n2) {
                    StringEditorPart.this.activeColumn = 0;
                }
                StringEditorPart.this.viewer.getControl().setMenu(menuManager.createContextMenu(StringEditorPart.this.viewer.getControl()));
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return ((RowInfo)object2).getKey().toLowerCase().contains(StringEditorPart.this.getKeyFilter().toLowerCase());
            }
        });
        ColumnViewerEditorActivationStrategy columnViewerEditorActivationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
                boolean bl = false;
                bl = columnViewerEditorActivationEvent.stateMask == 0 ? (columnViewerEditorActivationEvent.character >= ' ' && columnViewerEditorActivationEvent.character <= '\u007f' ? true : (columnViewerEditorActivationEvent.keyCode == 13 || columnViewerEditorActivationEvent.keyCode == 127 || columnViewerEditorActivationEvent.keyCode == 0x1000050 ? true : super.isEditorActivationEvent(columnViewerEditorActivationEvent))) : super.isEditorActivationEvent(columnViewerEditorActivationEvent);
                return bl;
            }
        };
        columnViewerEditorActivationStrategy.setEnableEditorActivationWithKeyboard(true);
        StringEditorCellHighlighter stringEditorCellHighlighter = new StringEditorCellHighlighter(this.viewer);
        CellNavigationStrategy cellNavigationStrategy = new CellNavigationStrategy();
        TableViewerFocusCellManager tableViewerFocusCellManager = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)stringEditorCellHighlighter, cellNavigationStrategy);
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)tableViewerFocusCellManager, (ColumnViewerEditorActivationStrategy)columnViewerEditorActivationStrategy, (int)58);
        this.viewer.getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)new StringEditorColumnViewerEditorActivationListener(this.viewer));
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                StringEditorPart.this.session.clean();
                StringEditorPart.this.saveSession();
                StringEditorPart.this.saveOptions();
                StringEditorPart.this.session.save();
            }
        });
        this.viewer.getTable().layout(true, true);
        this.restoreOptions();
        this.session.clean();
        this.saveOptions();
        this.saveSession();
        this.session.save();
        this.setEditorStatus(this.getEditorInput().validate());
        this.getModel().addListener(new IModelChangedListener(){

            public void modelChanged(StringEditorViewerModel stringEditorViewerModel) {
                StringEditorPart.this.setEditorStatus(StringEditorPart.this.getEditorInput().validate());
            }
        });
        if (this.contentProvider.getContextHelpID() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.viewer.getTable(), this.contentProvider.getContextHelpID());
        }
        this.viewer.getTable().addListener(41, new Listener(){
            final int TEXT_MARGIN = 3;

            public void handleEvent(Event event) {
                TableItem tableItem = (TableItem)event.item;
                String string = tableItem.getText(event.index);
                Point point = event.gc.textExtent(string);
                event.width = point.x + 6;
                if (StringEditorPart.this.expandRow) {
                    event.height = Math.max(event.height, point.y + 3);
                } else {
                    Point point2 = event.gc.textExtent(Messages.StringEditorPart_12);
                    event.height = point2.y + 3;
                }
            }
        });
        this.viewer.getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        this.viewer.getTable().addListener(42, new Listener(){
            final int TEXT_MARGIN = 3;
            final int FIRST_COLUM_TEXT_MARGIN = 20;

            public void handleEvent(Event event) {
                int n = 0;
                TableItem tableItem = (TableItem)event.item;
                String string = tableItem.getText(event.index);
                if (event.index > 0) {
                    event.gc.drawText(string, event.x + 3, event.y + n, true);
                } else if (event.index == 0) {
                    event.gc.drawImage(tableItem.getImage(), event.x, event.y);
                    event.gc.drawText(string, event.x + 20, event.y + n, true);
                }
            }
        });
        int n = 0;
        while (n < this.viewer.getTable().getColumnCount()) {
            this.viewer.getTable().getColumn(n).pack();
            ++n;
        }
        this.viewer.getTable().pack();
    }

    private void saveSession() {
        Table table = this.viewer.getTable();
        int n = 0;
        while (n < table.getColumnCount()) {
            TableColumn tableColumn = table.getColumn(table.getColumnOrder()[n]);
            this.session.setProperty(tableColumn.getText(), EditorSession.PROPERTY.ORDER, new Integer(n).toString());
            this.session.setProperty(tableColumn.getText(), EditorSession.PROPERTY.VISIBLE, new Boolean(tableColumn.getResizable()).toString());
            this.session.setProperty(tableColumn.getText(), EditorSession.PROPERTY.WIDTH, new Integer(tableColumn.getWidth()).toString());
            ++n;
        }
        this.session.setProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.SORT_BY_COLUMN, table.getSortColumn() != null ? table.getSortColumn().getText() : null);
        this.session.setProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.ORDER, table.getSortDirection() == 128 ? new Integer(128).toString() : new Integer(1024).toString());
    }

    private void saveOptions() {
        String string = this.associatedProject.getName();
        this.session.setProperty(string, EditorSession.PROPERTY.HIGHLIGHT_CHANGES, Boolean.toString(this.highlightChanges));
        this.session.setProperty(string, EditorSession.PROPERTY.SEARCH_TEXT, this.searchString.length() > 0 ? this.searchString : null);
        this.session.setProperty(string, EditorSession.PROPERTY.SHOW_COMMENTS, Boolean.toString(this.showCellComments));
        this.session.setProperty(string, EditorSession.PROPERTY.FILTER_BY_KEY, this.filterByKeyString.length() > 0 ? this.filterByKeyString : null);
        this.session.setProperty(string, EditorSession.PROPERTY.EXPAND_ROW, Boolean.toString(this.expandRow));
    }

    private void restoreOptions() {
        String string = this.associatedProject.getName();
        String string2 = this.session.getProperty(string, EditorSession.PROPERTY.SEARCH_TEXT);
        String string3 = this.session.getProperty(string, EditorSession.PROPERTY.HIGHLIGHT_CHANGES);
        String string4 = this.session.getProperty(string, EditorSession.PROPERTY.SHOW_COMMENTS);
        String string5 = this.session.getProperty(string, EditorSession.PROPERTY.FILTER_BY_KEY);
        String string6 = this.session.getProperty(string, EditorSession.PROPERTY.EXPAND_ROW);
        if (string2 != null) {
            this.searchText.setText(string2);
            this.searchString = this.searchText.getText();
        }
        if (string3 != null && !Platform.getOS().equals("linux")) {
            this.highlightChangesButton.setSelection(new Boolean(string3).booleanValue());
            this.highlightChanges = this.highlightChangesButton.getSelection();
        }
        if (string4 != null) {
            this.showCellCommentsButton.setSelection(new Boolean(string4).booleanValue());
            this.showCellComments = this.showCellCommentsButton.getSelection();
        }
        if (string5 != null) {
            this.filterByKeyText.setText(string5);
            this.filterByKeyString = this.filterByKeyText.getText();
        }
        if (string6 != null) {
            this.expandRowButton.setSelection(new Boolean(string6).booleanValue());
            this.expandRow = this.expandRowButton.getSelection();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void restoreSession(List<ColumnInfo> list) {
        TableViewerColumn n4;
        String string;
        Object object;
        void columnInfo;
        String string2;
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        HashMap<Integer, ColumnInfo> hashMap = new HashMap<Integer, ColumnInfo>();
        ArrayList<ColumnInfo> arrayList2 = new ArrayList<ColumnInfo>();
        for (ColumnInfo columnInfo2 : list) {
            string2 = this.session.getProperty(columnInfo2.getId(), EditorSession.PROPERTY.ORDER);
            if (string2 != null) {
                hashMap.put(Integer.parseInt(string2), columnInfo2);
                continue;
            }
            arrayList2.add(columnInfo2);
        }
        boolean n = true;
        while (columnInfo < list.size() + 1) {
            object = (ColumnInfo)hashMap.get((int)columnInfo);
            if (object != null) {
                arrayList.add(object);
            } else if (arrayList2.size() > 0) {
                arrayList.add((ColumnInfo)arrayList2.remove(0));
            }
            ++columnInfo;
        }
        for (ColumnInfo string3 : arrayList) {
            string2 = this.session.getProperty(string3.getId(), EditorSession.PROPERTY.WIDTH);
            string = this.session.getProperty(string3.getId(), EditorSession.PROPERTY.VISIBLE);
            n4 = this.createColumn(string3.getId(), string3.getTooltip(), -1);
            if (string2 != null) {
                n4.getColumn().setWidth(Integer.parseInt(string2));
            }
            if (string == null) continue;
            n4.getColumn().setResizable(Boolean.parseBoolean(string));
        }
        String string3 = this.session.getProperty(Messages.StringEditorPart_KeyLabel, EditorSession.PROPERTY.WIDTH);
        object = this.session.getProperty(Messages.StringEditorPart_KeyLabel, EditorSession.PROPERTY.VISIBLE);
        if (string3 != null) {
            this.viewer.getTable().getColumn(0).setWidth(Integer.parseInt(string3));
        }
        if (object != null) {
            this.viewer.getTable().getColumn(0).setResizable(Boolean.parseBoolean((String)object));
        }
        string2 = this.session.getProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.SORT_BY_COLUMN);
        string = this.session.getProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.ORDER);
        if (string2 != null && string2.length() > 0) {
            TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
            int n2 = tableColumnArray.length;
            int n3 = 0;
            while (n3 < n2) {
                n4 = tableColumnArray[n3];
                if (n4.getText().equals(string2)) {
                    this.viewer.getTable().setSortColumn((TableColumn)n4);
                }
                ++n3;
            }
        } else {
            this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(0));
        }
        if (string != null) {
            try {
                int n5 = Integer.parseInt(string);
                this.viewer.getTable().setSortDirection(n5);
            }
            catch (NumberFormatException numberFormatException) {
                this.viewer.getTable().setSortDirection(1024);
            }
        }
        this.viewer.refresh();
        this.saveSession();
    }

    private TableViewerColumn createColumn(String string, String string2, int n) {
        TableViewerColumn tableViewerColumn = null;
        tableViewerColumn = new TableViewerColumn(this.viewer, 0, n);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new StringEditorColumnLabelProvider(string, this));
        tableViewerColumn.setEditingSupport((EditingSupport)new CellEditingSupport(this.viewer, string));
        tableViewerColumn.getColumn().setText(string);
        tableViewerColumn.getColumn().setToolTipText(string2);
        tableViewerColumn.getColumn().setWidth(14 * (tableViewerColumn.getColumn().getText().length() + 1));
        tableViewerColumn.getColumn().setResizable(true);
        tableViewerColumn.getColumn().setMoveable(false);
        tableViewerColumn.getColumn().addSelectionListener((SelectionListener)this.listener);
        return tableViewerColumn;
    }

    private void hideColumn(TableColumn tableColumn) {
        tableColumn.setResizable(false);
        tableColumn.setData(PREVIOUS_WIDTH_PROPERTY_NAME, (Object)new Integer(tableColumn.getWidth()).toString());
        tableColumn.setWidth(0);
    }

    private void showColumn(TableColumn tableColumn) {
        tableColumn.setResizable(true);
        int n = -1;
        try {
            n = Integer.parseInt((String)tableColumn.getData(PREVIOUS_WIDTH_PROPERTY_NAME));
        }
        catch (NumberFormatException numberFormatException) {}
        tableColumn.setWidth(n > 0 ? n : 0);
        if (n == -1) {
            tableColumn.pack();
        }
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        this.addColumnsVisibilityActions(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add(this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId()));
        iMenuManager.add(this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.REDO.getId()));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)new AddKeyAction());
        iMenuManager.add((IAction)new RemoveKeyAction());
        iMenuManager.add((IAction)new AddColumnAction());
        iMenuManager.add((IAction)new RemoveColumnAction());
        iMenuManager.add((IAction)new RevertToSavedAction());
        iMenuManager.add((IAction)new CloneColumnAction());
        iMenuManager.add((IAction)new TranslateColumnAction());
        iMenuManager.add((IAction)new TranslateCellAction());
    }

    private void addColumnsVisibilityActions(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager(Messages.StringEditorPart_ShowColumnsSubmenuLabel);
        TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            if (!tableColumn.getText().equals(Messages.StringEditorPart_KeyLabel)) {
                menuManager.add((IAction)new HideShowColumnAction(tableColumn.getText(), 2, tableColumn));
            }
            ++n2;
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new HideShowAllColumnsAction(Messages.StringEditorPart_ShowAllColumnsActionName, 1, this.viewer.getTable(), true));
        menuManager.add((IAction)new HideShowAllColumnsAction(Messages.StringEditorPart_HideAllColumnsActionName, 1, this.viewer.getTable(), false));
        iMenuManager.add((IContributionItem)menuManager);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.promptUpdateConflicts()) {
            this.getEditorInput().save();
            List<RowInfo> list = this.getModel().save();
            this.updateViewer(list);
            this.fireDirtyPropertyChanged();
            this.setEditorStatus(this.getEditorInput().validate());
        }
    }

    public void updateViewer(List<RowInfo> list) {
        if (list != null) {
            for (RowInfo rowInfo : list) {
                this.viewer.update((Object)rowInfo, null);
            }
        } else {
            for (RowInfo rowInfo : this.getModel().getRows().values()) {
                this.viewer.update((Object)rowInfo, null);
            }
        }
    }

    public boolean isDirty() {
        return this.getEditorInput().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public TableViewer getEditorViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)new UndoActionHandler((IWorkbenchPartSite)this.getEditorSite(), this.getUndoContext()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)new RedoActionHandler((IWorkbenchPartSite)this.getEditorSite(), this.getUndoContext()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.SAVE.getId(), (IAction)ActionFactory.SAVE.create(this.getEditorSite().getWorkbenchWindow()));
        this.viewer.getTable().setFocus();
        this.promptFileSystemChanges();
    }

    public void markColumnAsChanged(String string) {
        this.changedColumns.add(string);
        this.needToPromptFileSystemChange = true;
    }

    public boolean unmarkColumnAsChanged(String string) {
        boolean bl = this.changedColumns.remove(string);
        this.needToPromptFileSystemChange = !this.changedColumns.isEmpty();
        return bl;
    }

    private void clearColumnsMarkedAsChanged() {
        this.changedColumns.clear();
        this.needToPromptFileSystemChange = !this.changedColumns.isEmpty();
    }

    private void promptFileSystemChanges() {
        if (this.changedColumns.size() > 0 && this.needToPromptFileSystemChange) {
            String string = this.getChangedColumnNamesString();
            boolean bl = MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)Messages.StringEditorPart_FileChangedTitle, (String)NLS.bind((String)Messages.StringEditorPart_FileChangedDescription, (Object)string));
            this.needToPromptFileSystemChange = false;
            if (bl) {
                HashSet<String> hashSet = new HashSet<String>(this.changedColumns);
                for (String string2 : hashSet) {
                    RevertColumnToSavedStateOperation revertColumnToSavedStateOperation = new RevertColumnToSavedStateOperation(Messages.StringEditorPart_RevertColumnActionOperationName, this, this.getModel().getColumn(string2));
                    this.executeOperation(revertColumnToSavedStateOperation);
                }
            }
        }
    }

    private boolean promptUpdateConflicts() {
        boolean bl = true;
        if (this.changedColumns.size() > 0) {
            String string = this.getChangedColumnNamesString();
            boolean bl2 = MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)Messages.StringEditorPart_UpdateConflictTitle, (String)NLS.bind((String)Messages.StringEditorPart_UpdateConflictDescription, (Object)string));
            if (!bl2) {
                bl = false;
            } else {
                this.clearColumnsMarkedAsChanged();
            }
        }
        return bl;
    }

    private String getChangedColumnNamesString() {
        String string = Messages.StringEditorPart_13;
        int n = 1;
        for (String string2 : this.changedColumns) {
            string = String.valueOf(string) + n++ + Messages.StringEditorPart_14 + string2 + Messages.StringEditorPart_15;
        }
        return string;
    }

    public ContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public TableColumn addColumn(ColumnInfo columnInfo, int n) {
        TableViewerColumn tableViewerColumn = this.createColumn(columnInfo.getId(), columnInfo.getTooltip(), n);
        this.getEditorInput().addColumn(columnInfo.getId());
        this.getModel().addColumn(columnInfo);
        for (String string : columnInfo.getCells().keySet()) {
            try {
                CellInfo cellInfo = columnInfo.getCells().get(string);
                if (cellInfo.getValue() == null) continue;
                this.getEditorInput().setValue(columnInfo.getId(), string, cellInfo.getValue());
            }
            catch (SequoyahException sequoyahException) {
                BasePlugin.logError((String)(String.valueOf(Messages.StringEditorPart_16) + columnInfo.getId()), (Throwable)sequoyahException);
            }
        }
        this.getEditorViewer().refresh();
        this.fireDirtyPropertyChanged();
        return tableViewerColumn.getColumn();
    }

    public IStringEditorInput getEditorInput() {
        return (IStringEditorInput)super.getEditorInput();
    }

    public void removeColumn(String string) {
        this.getEditorInput().removeColumn(string);
        this.getModel().removeColumn(string);
        TableColumn[] tableColumnArray = this.getEditorViewer().getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            if (tableColumn.getText().equals(string)) {
                tableColumn.dispose();
            }
            ++n2;
        }
        this.fireDirtyPropertyChanged();
        this.getEditorViewer().refresh();
    }

    public void addRow(RowInfo rowInfo) {
        rowInfo = this.getEditorInput().addRow(rowInfo);
        this.getModel().addRow(rowInfo);
        this.fireDirtyPropertyChanged();
    }

    public void removeRow(String string) {
        this.getModel().removeRow(string);
        this.getEditorInput().removeRow(string);
        this.fireDirtyPropertyChanged();
    }

    public StringEditorViewerModel getModel() {
        return (StringEditorViewerModel)this.getEditorViewer().getInput();
    }

    public void dispose() {
        this.getEditorInput().removeInputChangeListener(this.inputChangeListener);
        this.getEditorInput().dispose();
        super.dispose();
    }

    public void fireDirtyPropertyChanged() {
        this.firePropertyChange(257);
    }

    public boolean getHighlightChanges() {
        return this.highlightChanges;
    }

    public String getSearchText() {
        return this.searchString;
    }

    public boolean getShowCellComments() {
        return this.showCellComments;
    }

    public String getKeyFilter() {
        return this.filterByKeyString;
    }

    private void executeOperation(EditorOperation editorOperation) {
        try {
            editorOperation.addContext(this.getUndoContext());
            this.getOperationHistory().execute((IUndoableOperation)editorOperation, this.getProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            BasePlugin.logError((String)(String.valueOf(Messages.StringEditorPart_17) + editorOperation.getLabel()), (Throwable)executionException);
        }
    }

    public void setEditorStatus(IStatus iStatus) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        if (iStatus != null && !iStatus.isOK()) {
            if (iStatus.isMultiStatus()) {
                IStatus[] iStatusArray = iStatus.getChildren();
                int n2 = iStatusArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IStatus iStatus2 = iStatusArray[n3];
                    stringBuilder.append(iStatus2.getMessage());
                    stringBuilder.append(Messages.StringEditorPart_18);
                    ++n3;
                }
            } else {
                stringBuilder.append(iStatus.getMessage());
            }
            switch (iStatus.getSeverity()) {
                case 2: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 3;
                    break;
                }
            }
            this.editorComposite.setMessage(stringBuilder.toString(), n);
        } else {
            this.editorComposite.setMessage(null);
        }
    }

    public TableColumn getColumnByID(String string) {
        TableColumn tableColumn = null;
        TableColumn[] tableColumnArray = this.getEditorViewer().getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn2 = tableColumnArray[n2];
            if (tableColumn2.getText().equals(string)) {
                tableColumn = tableColumn2;
            }
            ++n2;
        }
        return tableColumn;
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public Image getWarningImage() {
        return this.warningImage;
    }

    public Image getOKImage() {
        return this.okImage;
    }

    class AddColumnAction
    extends Action {
        public AddColumnAction() {
            super(Messages.StringEditorPart_AddColumnActionName);
        }

        public void run() {
            ColumnInfo columnInfo = StringEditorPart.this.getContentProvider().getOperationProvider().getNewColumn();
            if (columnInfo != null) {
                if (StringEditorPart.this.getColumnByID(columnInfo.getId()) == null) {
                    AddColumnOperation addColumnOperation = new AddColumnOperation(Messages.StringEditorPart_AddColumnOperationName, StringEditorPart.this, columnInfo);
                    StringEditorPart.this.executeOperation(addColumnOperation);
                } else {
                    MessageDialog.openInformation((Shell)StringEditorPart.this.getEditorSite().getShell(), (String)Messages.StringEditorPart_ColumnAlreadyExistTitle, (String)NLS.bind((String)Messages.StringEditorPart_ColumnAlreadyExistMessage, (Object)columnInfo.getId()));
                }
            }
        }
    }

    class AddKeyAction
    extends Action {
        public AddKeyAction() {
            super(Messages.StringEditorPart_AddKeyActionName);
        }

        public void run() {
            RowInfo[] rowInfoArray = StringEditorPart.this.getContentProvider().getOperationProvider().getNewRow();
            if (rowInfoArray != null) {
                if (rowInfoArray.length > 1) {
                    AddKeysOperation addKeysOperation = new AddKeysOperation(Messages.StringEditorPart_AddKeyOperationName, StringEditorPart.this, rowInfoArray);
                    addKeysOperation.addContext(StringEditorPart.this.getUndoContext());
                    StringEditorPart.this.executeOperation(addKeysOperation);
                } else if (StringEditorPart.this.getModel().getRow(rowInfoArray[0].getKey()) == null) {
                    AddKeyOperation addKeyOperation = new AddKeyOperation(Messages.StringEditorPart_AddKeyOperationName, StringEditorPart.this, rowInfoArray[0]);
                    addKeyOperation.addContext(StringEditorPart.this.getUndoContext());
                    StringEditorPart.this.executeOperation(addKeyOperation);
                } else {
                    StringEditorPart.this.editorComposite.setMessage(Messages.StringEditorPart_KeyAlreadyExistsErrorMessage, 3);
                }
            }
        }
    }

    class CellEditingSupport
    extends EditingSupport {
        private final String columnID;
        private final CellEditor editor;

        public CellEditingSupport(TableViewer tableViewer, String string) {
            super((ColumnViewer)tableViewer);
            this.columnID = string;
            this.editor = new TextCellEditor((Composite)tableViewer.getTable(), 514);
        }

        protected boolean canEdit(Object object) {
            return !this.columnID.equalsIgnoreCase(Messages.StringEditorPart_KeyLabel);
        }

        protected CellEditor getCellEditor(Object object) {
            return this.editor;
        }

        protected Object getValue(Object object) {
            CellInfo cellInfo = ((RowInfo)object).getCells().get(this.columnID);
            return cellInfo != null && cellInfo.getValue() != null ? cellInfo.getValue() : "";
        }

        protected void setValue(Object object, Object object2) {
            RowInfo rowInfo = (RowInfo)object;
            CellInfo cellInfo = rowInfo.getCells().get(this.columnID);
            CellInfo cellInfo2 = null;
            String string = System.getProperty(Messages.StringEditorPart_0);
            String string2 = cellInfo != null ? cellInfo.getValue() : "";
            String string3 = ((String)object2).replaceAll(string, Messages.StringEditorPart_2);
            if (string3.equals(string2)) {
                return;
            }
            if (object2.toString().length() > 0) {
                if (cellInfo != null) {
                    if (cellInfo.getValue() != null && !cellInfo.getValue().equals(object2.toString()) || cellInfo.getValue() == null) {
                        cellInfo2 = new CellInfo(object2.toString(), cellInfo.getComment());
                    }
                } else {
                    cellInfo2 = new CellInfo(object2.toString(), null);
                }
            } else if (cellInfo != null) {
                cellInfo2 = new CellInfo(null, null);
            }
            if (cellInfo2 != null) {
                cellInfo2.setDirty(true);
                EditCellOperation editCellOperation = new EditCellOperation(rowInfo.getKey(), this.columnID, cellInfo, cellInfo2, StringEditorPart.this);
                StringEditorPart.this.executeOperation(editCellOperation);
            }
        }
    }

    class CloneColumnAction
    extends Action {
        public CloneColumnAction() {
            super(Messages.StringEditorPart_CloneActionName);
            this.setEnabled(StringEditorPart.this.activeColumn != 0);
        }

        public void run() {
            TableColumn tableColumn = StringEditorPart.this.getEditorViewer().getTable().getColumn(StringEditorPart.this.activeColumn);
            ColumnInfo columnInfo = StringEditorPart.this.getContentProvider().getOperationProvider().getNewColumn();
            if (columnInfo != null) {
                CloneOperation cloneOperation = new CloneOperation(StringEditorPart.this, tableColumn.getText(), columnInfo);
                StringEditorPart.this.executeOperation(cloneOperation);
            }
        }
    }

    class ColumnSelectionListener
    implements SelectionListener {
        private final TableViewer viewer;

        public ColumnSelectionListener(TableViewer tableViewer) {
            this.viewer = tableViewer;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            TableColumn tableColumn = (TableColumn)selectionEvent.widget;
            this.viewer.getTable().setSortColumn(tableColumn);
            this.viewer.getTable().setSortDirection(this.viewer.getTable().getSortDirection() == 1024 ? 128 : 1024);
            this.viewer.refresh();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    }

    class FilterByKeyTextModifyListener
    implements ModifyListener {
        FilterByKeyTextModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            StringEditorPart.this.filterByKeyString = ((Text)modifyEvent.widget).getText();
        }
    }

    class HideShowAllColumnsAction
    extends Action {
        private final Table table;
        private final boolean visible;

        public HideShowAllColumnsAction(String string, int n, Table table, boolean bl) {
            super(string, n);
            this.table = table;
            this.visible = bl;
        }

        public void run() {
            int n = 1;
            while (n < this.table.getColumnCount()) {
                if (this.visible) {
                    StringEditorPart.this.showColumn(this.table.getColumn(n));
                } else {
                    StringEditorPart.this.hideColumn(this.table.getColumn(n));
                }
                ++n;
            }
        }
    }

    class HideShowColumnAction
    extends Action {
        private final TableColumn column;

        public HideShowColumnAction(String string, int n, TableColumn tableColumn) {
            super(string, n);
            this.column = tableColumn;
            this.setChecked(tableColumn.getWidth() > 0);
        }

        public void run() {
            if (!this.isChecked()) {
                StringEditorPart.this.hideColumn(this.column);
            } else {
                StringEditorPart.this.showColumn(this.column);
            }
        }
    }

    class RemoveColumnAction
    extends Action {
        public RemoveColumnAction() {
            super(Messages.StringEditorPart_RemoveColumnActionName);
            String string = StringEditorPart.this.getEditorViewer().getTable().getColumn(StringEditorPart.this.activeColumn).getText();
            this.setEnabled(StringEditorPart.this.activeColumn != 0 && StringEditorPart.this.getModel().getColumn(string) != null && StringEditorPart.this.getModel().getColumn(string).canRemove());
        }

        public void run() {
            TableColumn tableColumn = StringEditorPart.this.getEditorViewer().getTable().getColumn(StringEditorPart.this.activeColumn);
            if (!tableColumn.getText().equals(Messages.StringEditorPart_KeyLabel) && MessageDialog.openQuestion((Shell)StringEditorPart.this.getEditorSite().getShell(), (String)Messages.StringEditorPart_RemoveColumnActionName, (String)(String.valueOf(Messages.StringEditorPart_RemoveColumnQuestionMessage) + Messages.StringEditorPart_4 + tableColumn.getText() + Messages.StringEditorPart_5))) {
                RemoveColumnOperation removeColumnOperation = new RemoveColumnOperation(Messages.StringEditorPart_RemoveColumnOperationName, StringEditorPart.this, ((StringEditorViewerModel)StringEditorPart.this.getEditorViewer().getInput()).getColumn(tableColumn.getText()), StringEditorPart.this.getEditorViewer().getTable().indexOf(tableColumn), tableColumn.getWidth());
                StringEditorPart.this.executeOperation(removeColumnOperation);
            }
        }
    }

    class RemoveKeyAction
    extends Action {
        public RemoveKeyAction() {
            super(Messages.StringEditorPart_RemoveKeyActionName);
        }

        public void run() {
            Object object;
            ISelection iSelection = StringEditorPart.this.viewer.getSelection();
            ArrayList<RowInfo> arrayList = new ArrayList<RowInfo>();
            if (iSelection != null && iSelection instanceof IStructuredSelection) {
                object = (IStructuredSelection)iSelection;
                Object[] objectArray = object.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object2 = objectArray[n2];
                    if (object2 instanceof RowInfo) {
                        arrayList.add((RowInfo)object2);
                    }
                    ++n2;
                }
            }
            if (arrayList.size() > 0) {
                object = new RemoveKeyOperation(Messages.StringEditorPart_RemoveKeyOperationName, StringEditorPart.this, arrayList);
                StringEditorPart.this.executeOperation((EditorOperation)((Object)object));
            }
        }
    }

    class RevertToSavedAction
    extends Action {
        public RevertToSavedAction() {
            super(Messages.StringEditorPart_RevertColumnActionName);
            this.setToolTipText(Messages.StringEditorPart_RevertColumnActionTooltip);
            this.setEnabled(StringEditorPart.this.activeColumn != 0);
        }

        public void run() {
            String string = StringEditorPart.this.viewer.getTable().getColumn(StringEditorPart.this.activeColumn).getText();
            RevertColumnToSavedStateOperation revertColumnToSavedStateOperation = new RevertColumnToSavedStateOperation(Messages.StringEditorPart_RevertColumnActionOperationName, StringEditorPart.this, StringEditorPart.this.getModel().getColumn(string));
            StringEditorPart.this.executeOperation(revertColumnToSavedStateOperation);
        }
    }

    class SearchTextModifyListener
    implements ModifyListener {
        SearchTextModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            StringEditorPart.this.searchString = ((Text)modifyEvent.widget).getText();
            StringEditorPart.this.updateViewer(null);
        }
    }

    class TranslateCellAction
    extends Action {
        public TranslateCellAction() {
            super(Messages.StringEditorPart_TranslateCellActionName);
            this.setEnabled(StringEditorPart.this.activeColumn != 0 && StringEditorPart.this.activeRow != null);
        }

        public void run() {
            TranslationInfo[] translationInfoArray;
            TableColumn tableColumn = StringEditorPart.this.getEditorViewer().getTable().getColumn(StringEditorPart.this.activeColumn);
            StructuredSelection structuredSelection = (StructuredSelection)StringEditorPart.this.getEditorViewer().getSelection();
            String[] stringArray = new String[structuredSelection.size()];
            String[] stringArray2 = new String[structuredSelection.size()];
            Object[] objectArray = structuredSelection.toArray();
            int n = 0;
            while (n < objectArray.length) {
                translationInfoArray = (TranslationInfo[])objectArray[n];
                CellInfo cellInfo = translationInfoArray.getCells().get(tableColumn.getText());
                stringArray[n] = translationInfoArray.getKey();
                stringArray2[n] = cellInfo.getValue();
                ++n;
            }
            StringEditorPart.this.activeRow.getViewerRow().getCell(StringEditorPart.this.activeColumn).getText();
            TableColumn[] tableColumnArray = StringEditorPart.this.getEditorViewer().getTable().getColumns();
            translationInfoArray = StringEditorPart.this.getContentProvider().getOperationProvider().getTranslatedColumnsInfo(tableColumn.getText(), stringArray, stringArray2, tableColumnArray);
            if (translationInfoArray != null) {
                try {
                    PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            iProgressMonitor.setTaskName(Messages.TranslationProgress_Connecting);
                            TableColumn tableColumn = StringEditorPart.this.getEditorViewer().getTable().getColumn(StringEditorPart.this.activeColumn);
                            if (StringEditorPart.this.getEditorInput().translateCells(tableColumn.getText(), translationInfoArray, iProgressMonitor)) {
                                Object object;
                                int n = translationInfoArray.length;
                                String[] stringArray = new String[n];
                                String[] stringArray2 = new String[n];
                                CellInfo[] cellInfoArray = new CellInfo[n];
                                CellInfo[] cellInfoArray2 = new CellInfo[n];
                                int n2 = 0;
                                TranslationInfo[] translationInfoArray2 = translationInfoArray;
                                int n3 = translationInfoArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    object = translationInfoArray2[n4];
                                    stringArray[n2] = ((TranslationInfo)object).getFromKey();
                                    stringArray2[n2] = ((TranslationInfo)object).getToColumn();
                                    cellInfoArray[n2] = StringEditorPart.this.getCellInfo(stringArray2[n2], stringArray[n2]);
                                    cellInfoArray2[n2] = new CellInfo(((TranslationInfo)object).getToWord(), cellInfoArray[n2].getComment());
                                    ++n2;
                                    ++n4;
                                }
                                object = new EditCellsOperation(Messages.StringEditorPart_3, stringArray, stringArray2, cellInfoArray, cellInfoArray2, StringEditorPart.this);
                                StringEditorPart.this.executeOperation((EditorOperation)((Object)object));
                                StringEditorPart.this.getEditorViewer().refresh();
                            } else {
                                iProgressMonitor.setCanceled(true);
                                MessageDialog.openInformation((Shell)StringEditorPart.this.getEditorSite().getShell(), (String)Messages.StringEditorPart_TranslationError, (String)Messages.StringEditorPart_TranslationErrorCheckConnetion);
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class TranslateColumnAction
    extends Action {
        public TranslateColumnAction() {
            super(Messages.StringEditorPart_TranslateActionName);
            this.setEnabled(StringEditorPart.this.activeColumn != 0);
        }

        public void run() {
            TableColumn tableColumn = StringEditorPart.this.getEditorViewer().getTable().getColumn(StringEditorPart.this.activeColumn);
            final TranslationInfo translationInfo = StringEditorPart.this.getContentProvider().getOperationProvider().getTranslatedColumnInfo(tableColumn.getText());
            if (translationInfo != null) {
                try {
                    PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            iProgressMonitor.setTaskName(Messages.TranslationProgress_Connecting);
                            TableColumn tableColumn = StringEditorPart.this.getEditorViewer().getTable().getColumn(StringEditorPart.this.activeColumn);
                            if (translationInfo != null && StringEditorPart.this.getColumnByID(translationInfo.getId()) == null) {
                                if (StringEditorPart.this.getEditorInput().translateColumn(tableColumn.getText(), translationInfo, iProgressMonitor)) {
                                    StringEditorPart.this.getEditorInput().getValues(translationInfo.getId());
                                    AddColumnOperation addColumnOperation = new AddColumnOperation(Messages.StringEditorPart_TranslateActionName, StringEditorPart.this, translationInfo);
                                    StringEditorPart.this.executeOperation(addColumnOperation);
                                } else {
                                    iProgressMonitor.setCanceled(true);
                                    MessageDialog.openInformation((Shell)StringEditorPart.this.getEditorSite().getShell(), (String)Messages.StringEditorPart_TranslationError, (String)Messages.StringEditorPart_TranslationErrorCheckConnetion);
                                }
                            } else {
                                iProgressMonitor.setCanceled(true);
                                MessageDialog.openInformation((Shell)StringEditorPart.this.getEditorSite().getShell(), (String)Messages.StringEditorPart_TranslationError, (String)Messages.StringEditorPart_TranslationErrorTargetExists);
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

