/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.img;

import java.util.Properties;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.vncviewer.config.IPropertiesFileHandler;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.IRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.img.Painter;
import org.eclipse.sequoyah.vnc.vncviewer.network.IVNCPainter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class SWTRemoteDisplayImg
extends SWTRemoteDisplay {
    public SWTRemoteDisplayImg(Composite composite, Properties properties, IPropertiesFileHandler iPropertiesFileHandler) {
        this(composite, properties, iPropertiesFileHandler, null);
    }

    public SWTRemoteDisplayImg(Composite composite, Properties properties, IPropertiesFileHandler iPropertiesFileHandler, ISWTPainter iSWTPainter) {
        super(composite, properties, iPropertiesFileHandler);
        this.painter = iSWTPainter;
        if (this.painter == null) {
            this.painter = new Painter(this);
        }
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                SWTRemoteDisplayImg.this.paintControl(paintEvent);
            }
        };
    }

    public synchronized void start(ProtocolHandle protocolHandle) throws Exception {
        super.start(protocolHandle);
        this.canvas.getDisplay().asyncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplayImg.this.canvas.addPaintListener(SWTRemoteDisplayImg.this.paintListener);
            }
        });
        ((Painter)this.painter).addSWTRemoteDisplayImg(this);
    }

    public synchronized void stop() {
        super.stop();
        ((Painter)this.painter).removeSWTRemoteDisplayImg(this);
    }

    public IVNCPainter getPainter() {
        return (Painter)this.painter;
    }

    protected void redrawScreen() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Canvas canvas = SWTRemoteDisplayImg.this.getCanvas();
                if (canvas != null && !canvas.isDisposed()) {
                    canvas.redraw();
                }
            }
        });
    }

    protected void redrawScreen(final int n, final int n2, final int n3, final int n4) {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Canvas canvas = SWTRemoteDisplayImg.this.getCanvas();
                if (canvas != null && !canvas.isDisposed()) {
                    switch (SWTRemoteDisplayImg.this.getRotation()) {
                        case ROTATION_0DEG: {
                            canvas.redraw(n, n2, n3, n4, false);
                            break;
                        }
                        default: {
                            canvas.redraw();
                        }
                    }
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.painter != null) {
            ((Painter)this.painter).dispose();
        }
    }

    protected void paintControl(PaintEvent paintEvent) {
        ImageData imageData = this.painter != null ? ((Painter)this.painter).getImageData() : null;
        Image image = null;
        if (imageData != null) {
            imageData = imageData.scaledTo((int)((double)imageData.width * this.getZoomFactor()), (int)((double)imageData.height * this.getZoomFactor()));
            image = new Image(paintEvent.gc.getDevice(), imageData);
        }
        paintEvent.gc.setBackground(this.canvas.getBackground());
        paintEvent.gc.setForeground(this.canvas.getForeground());
        if (image == null) {
            paintEvent.gc.fillRectangle(paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
        } else {
            Rectangle rectangle = image.getBounds();
            int n = Math.min(paintEvent.width, rectangle.width);
            int n2 = Math.min(paintEvent.height, rectangle.height);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Transform transform = new Transform(paintEvent.gc.getDevice());
            switch (this.getRotation()) {
                case ROTATION_0DEG: {
                    n6 = paintEvent.x;
                    n5 = paintEvent.y;
                    n4 = n;
                    n3 = n2;
                    break;
                }
                case ROTATION_180DEG: {
                    n6 = 0;
                    n5 = 0;
                    n4 = imageData.width;
                    n3 = imageData.height;
                    transform.translate((float)imageData.width, (float)imageData.height);
                    transform.rotate((float)IRemoteDisplay.Rotation.ROTATION_180DEG.value());
                    paintEvent.gc.setTransform(transform);
                    break;
                }
                case ROTATION_90DEG_CLOCKWISE: {
                    n6 = 0;
                    n5 = 0;
                    n4 = imageData.width;
                    n3 = imageData.height;
                    transform.translate((float)imageData.height, 0.0f);
                    transform.rotate((float)IRemoteDisplay.Rotation.ROTATION_90DEG_CLOCKWISE.value());
                    paintEvent.gc.setTransform(transform);
                    break;
                }
                case ROTATION_90DEG_COUNTERCLOCKWISE: {
                    n6 = 0;
                    n5 = 0;
                    n4 = imageData.width;
                    n3 = imageData.height;
                    transform.translate(0.0f, (float)imageData.width);
                    transform.rotate((float)IRemoteDisplay.Rotation.ROTATION_90DEG_COUNTERCLOCKWISE.value());
                    paintEvent.gc.setTransform(transform);
                }
            }
            paintEvent.gc.drawImage(image, n6, n5, n4, n3, n6, n5, n4, n3);
            image.dispose();
        }
    }
}

