/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.framework.Messages;
import org.eclipse.sequoyah.device.framework.status.StatusManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DevicePlugin
extends BasePlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.sequoyah.device.framework";
    public static final String DEVICE_TYPES_EXTENSION_POINT_ID = "org.eclipse.sequoyah.device.framework.deviceTypes";
    @Deprecated
    public static final String DEVICE_ID = "org.eclipse.sequoyah.device";
    public static final String SERVICE_ID = "org.eclipse.sequoyah.device.framework.service";
    public static final String STATUS_ID = "org.eclipse.sequoyah.device.framework.status";
    public static final String SERVICE_DEF_ID = "org.eclipse.sequoyah.device.framework.serviceDefinition";
    public static final String ICON_DEVICE = "ICON_DEVICE";
    public static final String ICON_SERVICE = "ICON_SERVICE";
    public static final String ICON_MOVING = "ICON_MOVING";
    public static final String ICON_BOOK = "ICON_BOOK";
    public static final String ICON_GAMEBOARD = "ICON_GAMEBOARD";
    public static final String ICON_NEW_BOOK = "ICON_NEW_BOOK";
    public static final String ICON_REMOVE = "ICON_REMOVE";
    public static final String ICON_START = "ICON_START";
    public static final String ICON_STOP = "ICON_STOP";
    public static final String ICON_REFRESH = "ICON_REFRESH";
    public static final String ICON_INACTIVE = "ICON_INACTIVE";
    public static final String ICON_PROPERTY = "ICON_PROPERTY";
    public static final String SEQUOYAH_STATUS_UNAVAILABLE = "UNAVAILABLE";
    public static final String SEQUOYAH_STATUS_IDLE = "IDLE";
    public static final String SEQUOYAH_STATUS_OFF = "OFF";
    public static final String SEQUOYAH_STATUS_INACTIVE = "INACTIVE";
    public static final Properties DEFAULT_PROPERTIES = new Properties();
    private static final String DEVICE_XML_LOCATION = Messages.DevicePlugin_0;
    private static final String TML_DEVICE_DATAFILE = "sequoyah_devices.xml";
    private static DevicePlugin plugin;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.getPreferenceStore().setDefault(DEVICE_XML_LOCATION, XML_LocationOption.USER_HOME.name());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static DevicePlugin getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry() {
        String string = DevicePlugin.getIconPath();
        this.putImageInRegistry(ICON_DEVICE, String.valueOf(string) + "full/obj16/device.gif");
        this.putImageInRegistry(ICON_SERVICE, String.valueOf(string) + "full/obj16/service.gif");
        this.putImageInRegistry(ICON_START, String.valueOf(string) + "full/obj16/start.png");
        this.putImageInRegistry(ICON_STOP, String.valueOf(string) + "full/obj16/stop.png");
        this.putImageInRegistry(ICON_REFRESH, String.valueOf(string) + "full/obj16/refresh.gif");
        this.putImageInRegistry(ICON_INACTIVE, String.valueOf(string) + "full/obj16/inactive.gif");
        this.putImageInRegistry(ICON_MOVING, String.valueOf(string) + "movingBox.gif");
        this.putImageInRegistry(ICON_BOOK, String.valueOf(string) + "book.gif");
        this.putImageInRegistry(ICON_GAMEBOARD, String.valueOf(string) + "gameboard.gif");
        this.putImageInRegistry(ICON_NEW_BOOK, String.valueOf(string) + "newbook.gif");
        this.putImageInRegistry(ICON_REMOVE, String.valueOf(string) + "remove.gif");
        this.putImageInRegistry(ICON_PROPERTY, String.valueOf(string) + "property.gif");
    }

    public void earlyStartup() {
        DEFAULT_PROPERTIES.setProperty("host", "127.0.0.1");
        DEFAULT_PROPERTIES.setProperty("display", ":0.0");
        DEFAULT_PROPERTIES.setProperty("port", "5900");
        StatusManager.getInstance().listStatus();
    }

    public Image getImageFromRegistry(String string, String string2) {
        String string3 = String.valueOf(string) + ":" + string2;
        Image image = this.getImageRegistry().get(string3);
        if (image == null) {
            ImageDescriptor imageDescriptor = null;
            Bundle bundle = Platform.getBundle((String)string);
            URL uRL = bundle.getResource(string2);
            if (uRL != null) {
                imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
            }
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            this.getImageRegistry().put(string3, imageDescriptor);
            image = this.getImageRegistry().get(string3);
        }
        return image;
    }

    public static void setDeviceXmlLocation(XML_LocationOption xML_LocationOption) {
        DevicePlugin.getDefault().getPreferenceStore().putValue(DEVICE_XML_LOCATION, xML_LocationOption.name());
    }

    public static File getDeviceXmlLocation() {
        String string = DevicePlugin.getDefault().getPreferenceStore().getString(DEVICE_XML_LOCATION);
        File file = null;
        if (string != "") {
            XML_LocationOption xML_LocationOption = XML_LocationOption.valueOf(XML_LocationOption.class, string);
            file = xML_LocationOption.getLocation();
        }
        if (file != null) {
            return file;
        }
        return DevicePlugin.getDefault().getStateLocation().toFile();
    }

    public static String getDeviceXmlFileName() {
        return TML_DEVICE_DATAFILE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XML_LocationOption {
        USER_HOME{

            public File getLocation() {
                return this.fileFromLocation(Platform.getUserLocation());
            }
        }
        ,
        ECLIPSE_CONFIGURATION{

            public File getLocation() {
                return this.fileFromLocation(Platform.getConfigurationLocation());
            }
        }
        ,
        PLUGIN_STATE{

            public File getLocation() {
                return DevicePlugin.getDefault().getStateLocation().toFile();
            }
        };


        protected File fileFromLocation(Location location) {
            if (location == null) {
                return null;
            }
            URL uRL = location.getURL();
            if (uRL != null && uRL.getProtocol().startsWith(Messages.DevicePlugin_1)) {
                return new File(uRL.getFile(), DevicePlugin.PLUGIN_ID);
            }
            return null;
        }

        public abstract File getLocation();
    }
}

