/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.events;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.sequoyah.device.framework.events.IInstanceListener;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.Messages;

public class InstanceEventManager
extends EventManager {
    private Collection<InstanceEvent> eventsToFire = Collections.synchronizedSet(new LinkedHashSet());
    private Runnable eventNotifierLoop = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (InstanceEventManager.this.isListenerAttached()) {
                InstanceEvent[] instanceEventArray;
                if (InstanceEventManager.this.eventsToFire == null) continue;
                if (InstanceEventManager.this.eventsToFire.isEmpty()) {
                    instanceEventArray = InstanceEventManager.this.eventsToFire;
                    synchronized (instanceEventArray) {
                        try {
                            InstanceEventManager.this.eventsToFire.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (InstanceEventManager.this.eventsToFire.isEmpty()) continue;
                instanceEventArray = InstanceEventManager.this.eventsToFire.toArray(new InstanceEvent[InstanceEventManager.this.eventsToFire.size()]);
                InstanceEvent instanceEvent = instanceEventArray[0];
                switch (instanceEvent.getType()) {
                    case INSTANCE_CREATED: {
                        InstanceEventManager.this.fireInstanceCreated(instanceEvent);
                        break;
                    }
                    case INSTANCE_DELETED: {
                        InstanceEventManager.this.fireInstanceDeleted(instanceEvent);
                        break;
                    }
                    case INSTANCE_LOADED: {
                        InstanceEventManager.this.fireInstanceLoaded(instanceEvent);
                        break;
                    }
                    case INSTANCE_UNLOADED: {
                        InstanceEventManager.this.fireInstanceUnloaded(instanceEvent);
                        break;
                    }
                    case INSTANCE_UPDATED: {
                        InstanceEventManager.this.fireInstanceUpdated(instanceEvent);
                        break;
                    }
                    case INSTANCE_TRANSITIONED: {
                        InstanceEventManager.this.fireInstanceTransitioned(instanceEvent);
                    }
                }
                InstanceEventManager.this.eventsToFire.remove(instanceEvent);
            }
        }
    };
    private static InstanceEventManager _instance;

    private InstanceEventManager() {
    }

    public static InstanceEventManager getInstance() {
        if (_instance == null) {
            _instance = new InstanceEventManager();
        }
        return _instance;
    }

    public void addInstanceListener(IInstanceListener iInstanceListener) {
        boolean bl = false;
        if (!this.isListenerAttached()) {
            bl = true;
        }
        this.addListenerObject(iInstanceListener);
        if (bl) {
            new Thread(this.eventNotifierLoop, Messages.InstanceEventManager_0).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(IInstanceListener iInstanceListener) {
        this.removeListenerObject(iInstanceListener);
        Collection<InstanceEvent> collection = this.eventsToFire;
        synchronized (collection) {
            this.eventsToFire.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(InstanceEvent instanceEvent) {
        if (instanceEvent.getType() == InstanceEvent.InstanceEventType.INSTANCE_ABOUT_TO_TRANSITION) {
            this.fireInstanceAboutToTransition(instanceEvent);
        } else {
            this.eventsToFire.add(instanceEvent);
            Collection<InstanceEvent> collection = this.eventsToFire;
            synchronized (collection) {
                this.eventsToFire.notify();
            }
        }
    }

    protected void fireInstanceCreated(final InstanceEvent instanceEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IInstanceListener iInstanceListener = (IInstanceListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iInstanceListener.instanceCreated(instanceEvent);
                }
            });
            ++n;
        }
    }

    protected void fireInstanceDeleted(final InstanceEvent instanceEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IInstanceListener iInstanceListener = (IInstanceListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iInstanceListener.instanceDeleted(instanceEvent);
                }
            });
            ++n;
        }
    }

    protected void fireInstanceLoaded(final InstanceEvent instanceEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IInstanceListener iInstanceListener = (IInstanceListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iInstanceListener.instanceLoaded(instanceEvent);
                }
            });
            ++n;
        }
    }

    protected void fireInstanceUnloaded(final InstanceEvent instanceEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IInstanceListener iInstanceListener = (IInstanceListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iInstanceListener.instanceUnloaded(instanceEvent);
                }
            });
            ++n;
        }
    }

    protected void fireInstanceUpdated(final InstanceEvent instanceEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IInstanceListener iInstanceListener = (IInstanceListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iInstanceListener.instanceUpdated(instanceEvent);
                }
            });
            ++n;
        }
    }

    protected void fireInstanceTransitioned(final InstanceEvent instanceEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IInstanceListener iInstanceListener = (IInstanceListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iInstanceListener.instanceTransitioned(instanceEvent);
                }
            });
            ++n;
        }
    }

    protected void fireInstanceAboutToTransition(final InstanceEvent instanceEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IInstanceListener iInstanceListener = (IInstanceListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iInstanceListener.instanceAboutToTransition(instanceEvent);
                }
            });
            ++n;
        }
    }
}

