/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.internal.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.status.IStatusTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileService
implements IService {
    private String id;
    private String name;
    private ImageDescriptor image;
    private String copyright;
    private String description;
    private String provider;
    private String version;
    private IServiceHandler handler;
    private IDeviceType parent;
    private Map<String, IStatusTransition> statusMap;
    private boolean visible;

    public MobileService(String string) {
        this.id = string;
        this.statusMap = new HashMap<String, IStatusTransition>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ImageDescriptor getImage() {
        return this.image;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public IServiceHandler getHandler() {
        return this.handler;
    }

    @Override
    public Collection<IStatusTransition> getStatusTransitions() {
        return this.statusMap.values();
    }

    @Override
    public IStatusTransition getStatusTransitions(String string) {
        return this.statusMap.get(string);
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setImage(ImageDescriptor imageDescriptor) {
        this.image = imageDescriptor;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setCopyright(String string) {
        this.copyright = string;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public void setProvider(String string) {
        this.provider = string;
    }

    @Override
    public void setVersion(String string) {
        this.version = string;
    }

    @Override
    public void setHandler(IServiceHandler iServiceHandler) {
        this.handler = (IServiceHandler)iServiceHandler.clone();
        this.handler.setService(this);
    }

    @Override
    public void setStatusTransitions(List<IStatusTransition> list) {
        for (IStatusTransition iStatusTransition : list) {
            this.statusMap.put(iStatusTransition.getStartId(), iStatusTransition);
        }
    }

    @Override
    public Object clone() {
        MobileService mobileService = new MobileService(this.id);
        mobileService.setName(this.name);
        mobileService.setImage(this.image);
        mobileService.setCopyright(this.copyright);
        mobileService.setDescription(this.description);
        mobileService.setProvider(this.provider);
        mobileService.setVersion(this.version);
        mobileService.setHandler(this.handler);
        mobileService.setParent(this.parent);
        mobileService.setVisible(this.visible);
        return mobileService;
    }

    public String toString() {
        return "[Service: id=" + (this.id == null ? "" : this.id) + ",name=" + (this.name == null ? "" : this.name) + ",description=" + (this.description == null ? "" : this.description) + ",version=" + (this.version == null ? "" : this.version) + ",provider=" + (this.provider == null ? "" : this.provider) + ",copyright=" + (this.copyright == null ? "" : this.copyright) + ",handler=" + (this.handler == null ? "" : this.handler.getClass().getName()) + "]";
    }

    @Override
    public IDeviceType getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IDeviceType iDeviceType) {
        this.parent = iDeviceType;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }
}

