/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core.environment;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsAdapterCorePlugin;
import org.eclipse.ptp.remote.remotetools.core.environment.PTPTargetControl;
import org.eclipse.ptp.remote.remotetools.core.environment.TargetConfig;
import org.eclipse.ptp.remote.remotetools.core.environment.conf.AttributeNames;
import org.eclipse.ptp.remote.remotetools.core.environment.conf.DefaultValues;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ptp.remotetools.utils.verification.IllegalAttributeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFactory {
    Map<String, String> currentMap = null;
    Map<String, String> defaultMap = null;
    ControlAttributes attributes = null;
    private static final String PREFIX = "ptp.";
    public static final String ATTR_LOCALHOST_SELECTION = "ptp.localhost-selection";
    public static final String ATTR_LOGIN_USERNAME = "ptp.login-username";
    public static final String ATTR_LOGIN_PASSWORD = "ptp.login-password";
    public static final String ATTR_CONNECTION_ADDRESS = "ptp.connection-address";
    public static final String ATTR_CONNECTION_PORT = "ptp.connection-port";
    public static final String ATTR_KEY_PATH = "ptp.key-path";
    public static final String ATTR_KEY_PASSPHRASE = "ptp.key-passphrase";
    public static final String ATTR_IS_PASSWORD_AUTH = "ptp.is-passwd-auth";
    public static final String ATTR_CONNECTION_TIMEOUT = "ptp.connection-timeout";
    public static final String ATTR_CIPHER_TYPE = "ptp.cipher-type";
    public static final String[] KEY_ARRAY = new String[]{"ptp.localhost-selection", "ptp.login-username", "ptp.connection-port", "ptp.connection-address", "ptp.key-path", "ptp.is-passwd-auth", "ptp.connection-timeout"};
    public static final String[] KEY_CIPHERED_ARRAY = new String[]{"ptp.key-passphrase", "ptp.login-password"};

    public ConfigFactory() {
        this.createDefaultMap();
        this.createCurrentMapFromPreferences();
        this.attributes = new ControlAttributes(this.currentMap, this.defaultMap);
    }

    public ConfigFactory(Map<String, String> newMap) {
        this.createDefaultMap();
        if (newMap == null) {
            this.createCurrentMapFromPreferences();
        } else {
            this.currentMap = new HashMap<String, String>(newMap);
        }
        this.attributes = new ControlAttributes(this.currentMap, this.defaultMap);
    }

    public Map<String, String> getMap() {
        return this.currentMap;
    }

    public ControlAttributes getAttributes() {
        return this.attributes;
    }

    private void createDefaultMap() {
        this.defaultMap = new HashMap<String, String>();
        this.defaultMap.put(ATTR_LOCALHOST_SELECTION, DefaultValues.LOCALHOST_SELECTION);
        this.defaultMap.put(ATTR_LOGIN_USERNAME, DefaultValues.LOGIN_USERNAME);
        this.defaultMap.put(ATTR_LOGIN_PASSWORD, DefaultValues.LOGIN_PASSWORD);
        this.defaultMap.put(ATTR_CONNECTION_PORT, DefaultValues.CONNECTION_PORT);
        this.defaultMap.put(ATTR_CONNECTION_ADDRESS, DefaultValues.CONNECTION_ADDRESS);
        this.defaultMap.put(ATTR_KEY_PATH, DefaultValues.KEY_PATH);
        this.defaultMap.put(ATTR_KEY_PASSPHRASE, DefaultValues.KEY_PASSPHRASE);
        this.defaultMap.put(ATTR_IS_PASSWORD_AUTH, DefaultValues.IS_PASSWORD_AUTH);
        this.defaultMap.put(ATTR_CONNECTION_TIMEOUT, DefaultValues.CONNECTION_TIMEOUT);
        this.defaultMap.put(ATTR_CIPHER_TYPE, PTPTargetControl.DEFAULT_CIPHER);
    }

    private void createCurrentMapFromPreferences() {
        this.currentMap = new HashMap<String, String>();
        Preferences store = RemoteToolsAdapterCorePlugin.getDefault().getPluginPreferences();
        this.currentMap.put(ATTR_LOGIN_USERNAME, store.getString(ATTR_LOGIN_USERNAME));
        this.currentMap.put(ATTR_CONNECTION_ADDRESS, store.getString(ATTR_CONNECTION_ADDRESS));
        this.currentMap.put(ATTR_CONNECTION_PORT, store.getString(ATTR_CONNECTION_PORT));
    }

    public TargetConfig createTargetConfig() throws CoreException {
        try {
            TargetConfig config = new TargetConfig();
            config.setLoginUserName(this.attributes.getString(ATTR_LOGIN_USERNAME));
            config.setLoginPassword(this.attributes.getString(ATTR_LOGIN_PASSWORD));
            config.setConnectionPort(this.attributes.verifyInt(AttributeNames.CONNECTION_PORT, ATTR_CONNECTION_PORT));
            if (this.attributes.getBoolean(ATTR_LOCALHOST_SELECTION)) {
                config.setConnectionAddress("localhost");
            } else {
                config.setConnectionAddress(this.attributes.getString(ATTR_CONNECTION_ADDRESS));
            }
            config.setConnectionTimeout(this.attributes.verifyInt(AttributeNames.CONNECTION_TIMEOUT, ATTR_CONNECTION_TIMEOUT));
            config.setKeyPassphrase(this.attributes.getString(ATTR_KEY_PASSPHRASE));
            config.setKeyPath(this.attributes.getString(ATTR_KEY_PATH));
            config.setIsPasswordAuth(this.attributes.getBoolean(ATTR_IS_PASSWORD_AUTH));
            config.setCipherType(this.attributes.getString(ATTR_CIPHER_TYPE));
            return config;
        }
        catch (IllegalAttributeException e) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
    }
}

