/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.graphics.ResourceFactory;

public final class Image
extends Resource {
    public String resourceName;
    private int width;
    private int height;

    private Image(String resourceName, int width, int height) {
        super(null);
        this.resourceName = resourceName;
        this.width = width;
        this.height = height;
    }

    public Image(Device device, InputStream stream) {
        super(Image.checkDevice(device));
        if (stream == null) {
            SWT.error(4);
        }
        this.init(stream);
    }

    public Image(Device device, String fileName) {
        super(Image.checkDevice(device));
        if (fileName == null) {
            SWT.error(4);
        }
        this.init(fileName);
    }

    public Image(Device device, Image srcImage, int flag) {
        super(Image.checkDevice(device));
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: {
                IResourceManager resourceManager = RWT.getResourceManager();
                InputStream content = resourceManager.getRegisteredContent(srcImage.resourceName);
                this.init(content);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(String fileName) {
        try {
            FileInputStream stream = new FileInputStream(fileName);
            try {
                this.init(stream);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                stream.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                stream.close();
                return;
            }
        }
        catch (IOException e) {
            throw new SWTException(39, e.getMessage());
        }
    }

    private void init(InputStream stream) {
        this.resourceName = "image-" + String.valueOf(this.hashCode());
        Point size = ResourceFactory.registerImage(this.resourceName, stream);
        if (size == null) {
            throw new SWTException(42);
        }
        this.width = size.x;
        this.height = size.y;
    }

    public Rectangle getBounds() {
        Rectangle result = null;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            result = new Rectangle(0, 0, this.width, this.height);
        } else {
            SWT.error(40);
        }
        return result;
    }

    void destroy() {
        RWT.getResourceManager().unregister(this.resourceName);
    }
}

