/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.graphics.ImageData;
import org.eclipse.swt.internal.graphics.ImageLoaderEvent;
import org.eclipse.swt.internal.graphics.ImageLoaderListener;
import org.eclipse.swt.internal.image.FileFormat;

public class ImageLoader {
    public ImageData[] data;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundPixel;
    public int repeatCount;
    Vector imageLoaderListeners;

    public ImageLoader() {
        this.reset();
    }

    void reset() {
        this.data = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.backgroundPixel = -1;
        this.repeatCount = 1;
    }

    public ImageData[] load(InputStream stream) {
        if (stream == null) {
            SWT.error(4);
        }
        this.reset();
        this.data = FileFormat.load(stream, this);
        return this.data;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageData[] load(String filename) {
        if (filename == null) {
            SWT.error(4);
        }
        InputStream stream = null;
        try {
            stream = Compatibility.newFileInputStream(filename);
            ImageData[] imageDataArray = this.load(stream);
            Object var4_4 = null;
            try {
                if (stream == null) return imageDataArray;
                stream.close();
                return imageDataArray;
            }
            catch (IOException iOException) {}
            return imageDataArray;
            catch (IOException e) {
                SWT.error(39, e);
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {}
            catch (IOException iOException) {}
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (stream == null) return null;
        stream.close();
        return null;
    }

    public void save(OutputStream stream, int format) {
        if (stream == null) {
            SWT.error(4);
        }
        FileFormat.save(stream, format, this);
    }

    public void save(String filename, int format) {
        if (filename == null) {
            SWT.error(4);
        }
        OutputStream stream = null;
        try {
            stream = Compatibility.newFileOutputStream(filename);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        this.save(stream, format);
        try {
            stream.close();
        }
        catch (IOException iOException) {}
    }

    public void addImageLoaderListener(ImageLoaderListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            this.imageLoaderListeners = new Vector();
        }
        this.imageLoaderListeners.addElement(listener);
    }

    public void removeImageLoaderListener(ImageLoaderListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            return;
        }
        this.imageLoaderListeners.removeElement(listener);
    }

    public boolean hasListeners() {
        return this.imageLoaderListeners != null && this.imageLoaderListeners.size() > 0;
    }

    public void notifyListeners(ImageLoaderEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        int size = this.imageLoaderListeners.size();
        int i = 0;
        while (i < size) {
            ImageLoaderListener listener = (ImageLoaderListener)this.imageLoaderListeners.elementAt(i);
            listener.imageDataLoaded(event);
            ++i;
        }
    }
}

