/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.text.MessageFormat;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.DefaultTextSizeStorage;
import org.eclipse.swt.internal.graphics.ITextSizeStorage;
import org.eclipse.swt.internal.graphics.TextSizeProbeStore;
import org.eclipse.swt.internal.graphics.TextSizeStorageRegistry;

final class TextSizeDataBase {
    TextSizeDataBase() {
    }

    public static Point lookup(Font font, String string, int wrapWidth) {
        Point result = null;
        if (TextSizeProbeStore.getInstance().containsProbeResult(font)) {
            Integer key = TextSizeDataBase.getKey(font, string, wrapWidth);
            result = TextSizeStorageRegistry.obtain().lookupTextSize(key);
        } else {
            TextSizeProbeStore.addProbeRequest(font);
        }
        return result;
    }

    public static void store(Font font, String string, int wrapWidth, Point calculatedTextSize) {
        if (!TextSizeProbeStore.getInstance().containsProbeResult(font)) {
            String txt = "Font ''{0}'' not probed yet.";
            Object[] args = new Object[]{font.toString()};
            String msg = MessageFormat.format(txt, args);
            throw new IllegalStateException(msg);
        }
        ITextSizeStorage registry = TextSizeStorageRegistry.obtain();
        Integer key = TextSizeDataBase.getKey(font, string, wrapWidth);
        registry.storeTextSize(key, calculatedTextSize);
    }

    static void reset() {
        ITextSizeStorage registry = TextSizeStorageRegistry.obtain();
        if (registry instanceof DefaultTextSizeStorage) {
            ((DefaultTextSizeStorage)registry).resetStringSizes();
        }
    }

    static Integer getKey(Font font, String string, int wrapWidth) {
        TextSizeProbeStore instance = TextSizeProbeStore.getInstance();
        TextSizeProbeStore.IProbeResult probeResult = instance.getProbeResult(font);
        String probeText = probeResult.getProbe().getString();
        Point probeSize = probeResult.getSize();
        FontData probeFontData = font.getFontData()[0];
        int hashCode = 1;
        hashCode = 31 * hashCode + probeText.hashCode();
        hashCode = 31 * hashCode + probeSize.hashCode();
        hashCode = 31 * hashCode + probeFontData.hashCode();
        hashCode = 31 * hashCode + string.hashCode();
        hashCode = 31 * hashCode + wrapWidth;
        return new Integer(hashCode);
    }
}

