/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.Adaptable;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IExpandBarAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public class ExpandBar
extends Composite {
    ExpandItem focusItem;
    int spacing = 4;
    int allItemsHeight;
    int charHeight;
    private final ItemHolder itemHolder;
    private final IExpandBarAdapter expandBarAdapter = new ExpandBarAdapter();
    private final ResizeListener resizeListener = new ResizeListener();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ExpandBar(Composite parent, int style) {
        super(parent, ExpandBar.checkStyle(style));
        this.addControlListener(this.resizeListener);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.ExpandItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemHolder = new ItemHolder(clazz);
    }

    public void addExpandListener(ExpandListener listener) {
        ExpandEvent.addListener((Adaptable)this, listener);
    }

    public void removeExpandListener(ExpandListener listener) {
        ExpandEvent.removeListener((Adaptable)this, listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int height = 0;
        int width = 0;
        int itemCount = this.getItemCount();
        if ((wHint == -1 || hHint == -1) && itemCount > 0) {
            height += this.spacing;
            int i = 0;
            while (i < itemCount) {
                ExpandItem item = this.getItem(i);
                height += item.getHeaderHeight();
                if (item.expanded) {
                    height += item.height;
                }
                height += this.spacing;
                int barPreferredWidth = item.getPreferredWidth() + 2 * this.spacing;
                width = Math.max(width, barPreferredWidth);
                ++i;
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += this.getScrollBarSize();
        }
        return new Point(width, height);
    }

    void createItem(ExpandItem item, int style, int index) {
        this.itemHolder.insert(item, index);
        if (this.focusItem == null) {
            this.focusItem = item;
        }
        this.layoutItems(index, true);
    }

    void destroyItem(ExpandItem item) {
        int index = 0;
        int itemCount = this.getItemCount();
        int i = 0;
        while (i < itemCount) {
            if (this.getItem(i) == item) {
                index = i;
            }
            ++i;
        }
        if (index != itemCount) {
            if (item == this.focusItem) {
                int focusIndex = index > 0 ? index - 1 : 1;
                this.focusItem = focusIndex < itemCount ? this.getItem(focusIndex) : null;
            }
            this.itemHolder.remove(item);
            this.layoutItems(index, true);
        }
    }

    Control findBackgroundControl() {
        Control control = super.findBackgroundControl();
        if (!this.isAppThemed() && control == null) {
            control = this;
        }
        return control;
    }

    int getBandHeight() {
        return Math.max(24, this.charHeight);
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        return (ExpandItem)this.itemHolder.getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        return (ExpandItem[])this.itemHolder.getItems();
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    public int indexOf(ExpandItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        return this.itemHolder.indexOf(item);
    }

    void layoutItems(int index, boolean setScrollbar) {
        int itemCount = this.getItemCount();
        if (index < itemCount) {
            ExpandItem item;
            int y = this.spacing;
            int i = 0;
            while (i < index) {
                item = this.getItem(i);
                if (item.expanded) {
                    y += item.height;
                }
                y += item.getHeaderHeight() + this.spacing;
                ++i;
            }
            i = index;
            while (i < itemCount) {
                item = this.getItem(i);
                item.setBounds(this.spacing, y, 0, 0, true, false);
                if (item.expanded) {
                    y += item.height;
                }
                y += item.getHeaderHeight() + this.spacing;
                ++i;
            }
        }
        if (itemCount > 0) {
            ExpandItem lastItem = this.getItem(itemCount - 1);
            this.allItemsHeight = lastItem.y + lastItem.getBounds().height;
        }
        int border = this.getBorderWidth();
        int v_scroll = this.getScrollBarSize();
        int i = 0;
        while (i < itemCount) {
            int width;
            ExpandItem item = this.getItem(i);
            if (this.isVScrollbarVisible()) {
                width = this.getBounds().width - v_scroll - 2 * border - 2 * this.spacing;
                item.setBounds(0, 0, width, item.height, false, true);
            } else {
                width = this.getBounds().width - 2 * border - 2 * this.spacing;
                item.setBounds(0, 0, width, item.height, false, true);
            }
            ++i;
        }
    }

    public void setFont(Font font) {
        if (font != this.getFont()) {
            super.setFont(font);
            this.charHeight = TextSizeDetermination.getCharHeight(font) + 4;
        }
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        if (spacing >= 0 && spacing != this.spacing) {
            this.spacing = spacing;
            this.layoutItems(0, true);
        }
    }

    void showItem(ExpandItem item) {
        Control control = item.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(item.expanded);
        }
        int index = this.indexOf(item);
        this.layoutItems(index + 1, true);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        int aStyle = style & 0xFFFFFEFF;
        return aStyle;
    }

    boolean isAppThemed() {
        return false;
    }

    boolean isVScrollbarVisible() {
        int border = this.getBorderWidth();
        return (this.getStyle() & 0x200) != 0 && this.allItemsHeight > this.getBounds().height - 2 * border - this.spacing;
    }

    Rectangle getBottomSpacingBounds() {
        return new Rectangle(this.spacing, this.allItemsHeight, 10, this.spacing);
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            result = this.itemHolder;
        } else {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IExpandBarAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = adapter == clazz2 ? this.expandBarAdapter : super.getAdapter(adapter);
        }
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.resizeListener != null) {
            this.removeControlListener(this.resizeListener);
        }
    }

    void releaseChildren() {
        ExpandItem[] expandItems = new ExpandItem[this.getItemCount()];
        System.arraycopy(this.getItems(), 0, expandItems, 0, this.getItems().length);
        int i = 0;
        while (i < expandItems.length) {
            if (expandItems[i] != null) {
                ((Widget)expandItems[i]).dispose();
            }
            ++i;
        }
    }

    int getScrollBarSize() {
        Display display = this.getDisplay();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object object = display.getAdapter(clazz);
        IDisplayAdapter adapter = (IDisplayAdapter)object;
        return adapter.getScrollBarSize();
    }

    private final class ExpandBarAdapter
    implements IExpandBarAdapter {
        private ExpandBarAdapter() {
        }

        public Rectangle getBounds(ExpandItem item) {
            int index = ExpandBar.this.indexOf(item);
            return ExpandBar.this.getItem(index).getBounds();
        }

        public boolean isVScrollbarVisible() {
            return ExpandBar.this.isVScrollbarVisible();
        }

        public Rectangle getBottomSpacingBounds() {
            return ExpandBar.this.getBottomSpacingBounds();
        }
    }

    private final class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        public void controlResized(ControlEvent event) {
            ExpandBar.this.layoutItems(0, true);
        }
    }
}

