/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

public class DynamicJAXBContext
extends JAXBContext {
    private ArrayList<DynamicHelper> helpers = new ArrayList();

    DynamicJAXBContext() {
    }

    public DynamicType getDynamicType(String javaName) {
        for (DynamicHelper helper : this.helpers) {
            DynamicType type = helper.getType(javaName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public DynamicEntity newDynamicEntity(String javaName) throws IllegalArgumentException {
        IllegalArgumentException ex = null;
        for (DynamicHelper helper : this.helpers) {
            try {
                return helper.newDynamicEntity(javaName);
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
        }
        throw ex;
    }

    public DynamicEntity newDynamicEntity(DynamicType dynamicType) {
        return dynamicType.newDynamicEntity();
    }

    void initializeFromSessionsXML(String sessionNames, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        DynamicClassLoader dynamicClassLoader = classLoader instanceof DynamicClassLoader ? (DynamicClassLoader)classLoader : new DynamicClassLoader(classLoader);
        StringTokenizer st = new StringTokenizer(sessionNames, ":");
        ArrayList<Project> dynamicProjects = new ArrayList<Project>(st.countTokens());
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        while (st.hasMoreTokens()) {
            DatabaseSession dbSession = (DatabaseSession)SessionManager.getManager().getSession(loader, st.nextToken(), classLoader, false, true);
            Project p = DynamicTypeBuilder.loadDynamicProject((Project)dbSession.getProject(), null, (DynamicClassLoader)dynamicClassLoader);
            dynamicProjects.add(p);
        }
        this.xmlContext = new XMLContext(dynamicProjects);
        List sessions = this.xmlContext.getSessions();
        for (Object session : sessions) {
            this.helpers.add(new DynamicHelper((DatabaseSession)session));
        }
    }
}

