/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.attrs.LocalVariableTypeTableAttribute;
import org.eclipse.persistence.internal.libraries.asm.attrs.RuntimeVisibleAnnotations;
import org.eclipse.persistence.internal.libraries.asm.attrs.SignatureAttribute;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.JAXBMetadataLogger;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.javamodel.AnnotationProxy;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaFieldImpl;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessOrder;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAccessType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.annotations.XmlContainerProperty;
import org.eclipse.persistence.oxm.annotations.XmlCustomizer;
import org.eclipse.persistence.oxm.annotations.XmlInverseReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsProcessor {
    private static final String JAVAX_ACTIVATION_DATAHANDLER = "javax.activation.DataHandler";
    private static final String JAVAX_MAIL_INTERNET_MIMEMULTIPART = "javax.mail.internet.MimeMultipart";
    private static final String TYPE_METHOD_NAME = "type";
    private static final String VALUE_METHOD_NAME = "value";
    private ArrayList<JavaClass> typeInfoClasses;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, MarshalCallback> marshalCallbacks;
    private HashMap<String, QName> userDefinedSchemaTypes;
    private HashMap<String, TypeInfo> typeInfo;
    private ArrayList<QName> typeQNames;
    private HashMap<String, UnmarshalCallback> unmarshalCallbacks;
    private HashMap<String, HashMap<QName, ElementDeclaration>> elementDeclarations;
    private HashMap<String, ElementDeclaration> xmlRootElements;
    private List<ElementDeclaration> localElements;
    private HashMap<String, JavaMethod> factoryMethods;
    private Map<String, org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry> xmlRegistries;
    private Map<String, Class> arrayClassesToGeneratedClasses;
    private Map<Class, JavaClass> generatedClassesToArrayClasses;
    private Map<Type, Class> collectionClassesToGeneratedClasses;
    private Map<Class, Type> generatedClassesToCollectionClasses;
    private Map<JavaClass, TypeMappingInfo> javaClassToTypeMappingInfos;
    private Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedClasses;
    private Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses;
    private Map<TypeMappingInfo, QName> typeMappingInfoToSchemaType;
    private NamespaceResolver namespaceResolver;
    private Helper helper;
    private String defaultTargetNamespace;
    private JAXBMetadataLogger logger;
    private boolean isDefaultNamespaceAllowed;

    public AnnotationsProcessor(Helper helper) {
        this.helper = helper;
        this.isDefaultNamespaceAllowed = true;
    }

    void processClassesAndProperties(JavaClass[] classes, TypeMappingInfo[] typeMappingInfos) {
        this.init(classes, typeMappingInfos);
        this.preBuildTypeInfo(classes);
        classes = this.postBuildTypeInfo(classes);
        this.processJavaClasses(classes);
        this.finalizeProperties();
        this.createElementsForTypeMappingInfo();
    }

    public void createElementsForTypeMappingInfo() {
        if (this.javaClassToTypeMappingInfos != null && !this.javaClassToTypeMappingInfos.isEmpty()) {
            Set<JavaClass> classes = this.javaClassToTypeMappingInfos.keySet();
            for (JavaClass nextClass : classes) {
                Class generatedClass;
                TypeInfo nextTypeInfo;
                Class generatedClass2;
                TypeMappingInfo nextInfo = this.javaClassToTypeMappingInfos.get(nextClass);
                if (nextInfo == null) continue;
                boolean xmlAttachmentRef = false;
                String xmlMimeType = null;
                Annotation[] annotations = this.getAnnotations(nextInfo);
                Class adapterClass = this.typeMappingInfoToAdapterClasses.get(nextInfo);
                Class declJavaType = null;
                if (adapterClass != null) {
                    declJavaType = CompilerHelper.getTypeFromAdapterClass(adapterClass);
                }
                if (annotations != null) {
                    for (int j = 0; j < annotations.length; ++j) {
                        Annotation nextAnnotation = annotations[j];
                        if (nextAnnotation == null) continue;
                        if (nextAnnotation instanceof XmlMimeType) {
                            XmlMimeType javaAnnotation = (XmlMimeType)nextAnnotation;
                            xmlMimeType = javaAnnotation.value();
                            continue;
                        }
                        if (!(nextAnnotation instanceof XmlAttachmentRef)) continue;
                        xmlAttachmentRef = true;
                    }
                }
                QName qname = null;
                String nextClassName = nextClass.getQualifiedName();
                if (declJavaType != null) {
                    nextClassName = declJavaType.getCanonicalName();
                }
                if (this.typeMappingInfoToGeneratedClasses != null && (generatedClass2 = this.typeMappingInfoToGeneratedClasses.get(nextInfo)) != null) {
                    nextClassName = generatedClass2.getCanonicalName();
                }
                if ((nextTypeInfo = this.typeInfo.get(nextClassName)) != null) {
                    qname = new QName(nextTypeInfo.getClassNamespace(), nextTypeInfo.getSchemaTypeName());
                } else {
                    qname = this.getUserDefinedSchemaTypes().get(nextClassName);
                    if (qname == null) {
                        if (nextClassName.equals(ClassConstants.ABYTE.getName()) || nextClassName.equals(ClassConstants.APBYTE.getName()) || nextClassName.equals(Image.class.getName()) || nextClassName.equals(Source.class.getName()) || nextClassName.equals(JAVAX_ACTIVATION_DATAHANDLER)) {
                            qname = xmlAttachmentRef ? XMLConstants.SWA_REF_QNAME : XMLConstants.BASE_64_BINARY_QNAME;
                        } else if (nextClassName.equals(ClassConstants.OBJECT.getName())) {
                            qname = XMLConstants.ANY_TYPE_QNAME;
                        } else {
                            Class theClass = this.helper.getClassForJavaClass(nextClass);
                            qname = (QName)XMLConversionManager.getDefaultJavaTypes().get(theClass);
                        }
                    }
                }
                if (qname != null) {
                    this.typeMappingInfoToSchemaType.put(nextInfo, qname);
                }
                if (nextInfo.getXmlTagName() == null) continue;
                ElementDeclaration element = new ElementDeclaration(nextInfo.getXmlTagName(), nextClass, nextClass.getQualifiedName(), false);
                element.setTypeMappingInfo(nextInfo);
                element.setXmlMimeType(xmlMimeType);
                element.setXmlAttachmentRef(xmlAttachmentRef);
                if (declJavaType != null) {
                    element.setJavaType(this.helper.getJavaClass(declJavaType));
                }
                if ((generatedClass = this.typeMappingInfoToGeneratedClasses.get(nextInfo)) != null) {
                    element.setJavaType(this.helper.getJavaClass(generatedClass));
                }
                if (nextInfo.getElementScope() == TypeMappingInfo.ElementScope.Global) {
                    this.getGlobalElements().put(element.getElementName(), element);
                    continue;
                }
                this.localElements.add(element);
            }
        }
    }

    private Annotation[] getAnnotations(TypeMappingInfo tmInfo) {
        if (tmInfo.getXmlElement() != null) {
            ClassLoader loader = this.helper.getClassLoader();
            ConversionManager cMgr = new ConversionManager();
            cMgr.setLoader(loader);
            XmlElement xElt = CompilerHelper.getXmlElement(tmInfo.getXmlElement(), loader);
            ArrayList<Object> annotations = new ArrayList<Object>();
            HashMap<String, Object> components = null;
            if (!xElt.getType().equals("javax.xml.bind.annotation.XmlElement.DEFAULT")) {
                components = new HashMap<String, Object>();
                components.put(TYPE_METHOD_NAME, xElt.getType());
                annotations.add(AnnotationProxy.getProxy(components, javax.xml.bind.annotation.XmlElement.class, loader, cMgr));
            }
            if (xElt.isXmlList()) {
                annotations.add(AnnotationProxy.getProxy(components, XmlList.class, loader, cMgr));
            }
            if (xElt.isXmlAttachmentRef()) {
                annotations.add(AnnotationProxy.getProxy(components, XmlAttachmentRef.class, loader, cMgr));
            }
            if (xElt.getXmlMimeType() != null) {
                components = new HashMap();
                components.put(VALUE_METHOD_NAME, xElt.getXmlMimeType());
                annotations.add(AnnotationProxy.getProxy(components, XmlMimeType.class, loader, cMgr));
            }
            if (xElt.getXmlJavaTypeAdapter() != null) {
                components = new HashMap();
                components.put(TYPE_METHOD_NAME, xElt.getXmlJavaTypeAdapter().getType());
                components.put(VALUE_METHOD_NAME, xElt.getXmlJavaTypeAdapter().getValue());
                annotations.add(AnnotationProxy.getProxy(components, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class, loader, cMgr));
            }
            return annotations.toArray(new Annotation[annotations.size()]);
        }
        return tmInfo.getAnnotations();
    }

    void init(JavaClass[] classes, TypeMappingInfo[] typeMappingInfos) {
        this.typeInfoClasses = new ArrayList();
        this.typeInfo = new HashMap();
        this.typeQNames = new ArrayList();
        this.userDefinedSchemaTypes = new HashMap();
        if (this.packageToNamespaceMappings == null) {
            this.packageToNamespaceMappings = new HashMap();
        }
        this.factoryMethods = new HashMap();
        this.xmlRegistries = new HashMap<String, org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry>();
        this.namespaceResolver = new NamespaceResolver();
        this.xmlRootElements = new HashMap();
        this.arrayClassesToGeneratedClasses = new HashMap<String, Class>();
        this.collectionClassesToGeneratedClasses = new HashMap<Type, Class>();
        this.generatedClassesToArrayClasses = new HashMap<Class, JavaClass>();
        this.generatedClassesToCollectionClasses = new HashMap<Class, Type>();
        this.typeMappingInfoToGeneratedClasses = new HashMap<TypeMappingInfo, Class>();
        this.typeMappingInfoToSchemaType = new HashMap<TypeMappingInfo, QName>();
        this.elementDeclarations = new HashMap();
        HashMap globalElements = new HashMap();
        this.elementDeclarations.put(XmlElementDecl.GLOBAL.class.getName(), globalElements);
        this.localElements = new ArrayList<ElementDeclaration>();
        this.javaClassToTypeMappingInfos = new HashMap<JavaClass, TypeMappingInfo>();
        if (typeMappingInfos != null) {
            for (int i = 0; i < typeMappingInfos.length; ++i) {
                this.javaClassToTypeMappingInfos.put(classes[i], typeMappingInfos[i]);
            }
        }
        this.typeMappingInfoToAdapterClasses = new HashMap<TypeMappingInfo, Class>();
        if (typeMappingInfos != null) {
            for (TypeMappingInfo next : typeMappingInfos) {
                Annotation[] annotations = this.getAnnotations(next);
                if (annotations == null) continue;
                for (Annotation nextAnnotation : annotations) {
                    if (!(nextAnnotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)) continue;
                    this.typeMappingInfoToAdapterClasses.put(next, ((javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)nextAnnotation).value());
                }
            }
        }
    }

    public Map<String, TypeInfo> preBuildTypeInfo(JavaClass[] javaClasses) {
        for (JavaClass javaClass : javaClasses) {
            TypeInfo info;
            if (javaClass == null || !this.shouldGenerateTypeInfo(javaClass) || this.isXmlRegistry(javaClass) || (info = this.typeInfo.get(javaClass.getQualifiedName())) != null && info.isPreBuilt()) continue;
            info = javaClass.isEnum() ? new EnumTypeInfo(this.helper) : new TypeInfo(this.helper);
            info.setPreBuilt(true);
            if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
                info.setXmlTransient(true);
            }
            if (this.helper.isAnnotationPresent(javaClass, XmlInlineBinaryData.class)) {
                info.setInlineBinaryData(true);
            }
            this.processXmlRootElement(javaClass, info);
            this.processXmlSeeAlso(javaClass, info);
            NamespaceInfo packageNamespace = this.getNamespaceInfoForPackage(javaClass);
            this.preProcessXmlType(javaClass, info, packageNamespace);
            this.preProcessXmlAccessorType(javaClass, info, packageNamespace);
            this.preProcessXmlAccessorOrder(javaClass, info, packageNamespace);
            this.processPackageLevelAdapters(javaClass, info);
            this.processClassLevelAdapters(javaClass, info);
            this.preProcessCustomizer(javaClass, info);
            this.processSchemaTypes(javaClass, info);
            this.typeInfoClasses.add(javaClass);
            this.typeInfo.put(javaClass.getQualifiedName(), info);
        }
        return this.typeInfo;
    }

    public JavaClass[] postBuildTypeInfo(JavaClass[] javaClasses) {
        if (javaClasses.length == 0) {
            return javaClasses;
        }
        javaClasses = this.processAdditionalClasses(javaClasses);
        this.preBuildTypeInfo(javaClasses);
        this.updateGlobalElements(javaClasses);
        this.buildTypeInfo(javaClasses);
        return javaClasses;
    }

    private Map<String, TypeInfo> buildTypeInfo(JavaClass[] allClasses) {
        for (JavaClass javaClass : allClasses) {
            JavaConstructor zeroArgConstructor;
            TypeInfo info;
            if (javaClass == null || (info = this.typeInfo.get(javaClass.getQualifiedName())) == null || info.isPostBuilt()) continue;
            info.setPostBuilt(true);
            this.processFactoryMethods(javaClass, info);
            NamespaceInfo packageNamespace = this.getNamespaceInfoForPackage(javaClass);
            this.postProcessXmlAccessorType(info, packageNamespace);
            this.postProcessXmlType(javaClass, info, packageNamespace);
            if (info.isEnumerationType()) {
                this.addEnumTypeInfo(javaClass, (EnumTypeInfo)info);
                continue;
            }
            this.processTypeQName(javaClass, info, packageNamespace);
            JavaClass superClass = javaClass.getSuperclass();
            if (this.shouldGenerateTypeInfo(superClass)) {
                JavaClass[] jClassArray = new JavaClass[]{superClass};
                this.buildNewTypeInfo(jClassArray);
            }
            info.setProperties(this.getPropertiesForClass(javaClass, info));
            this.processTypeInfoProperties(javaClass, info);
            this.postProcessXmlAccessorOrder(info, packageNamespace);
            if (info.getFactoryMethodName() == null && info.getObjectFactoryClassName() == null && (zeroArgConstructor = javaClass.getDeclaredConstructor(new JavaClass[0])) == null) {
                throw JAXBException.factoryMethodOrConstructorRequired((String)javaClass.getName());
            }
            this.validatePropOrderForInfo(info);
        }
        return this.typeInfo;
    }

    public void finalizeProperties() {
        ArrayList<JavaClass> jClasses = this.getTypeInfoClasses();
        for (JavaClass jClass : jClasses) {
            TypeInfo tInfo = this.getTypeInfo().get(jClass.getQualifiedName());
            if (tInfo.getXmlValueProperty() != null) {
                this.validateXmlValueFieldOrProperty(jClass, tInfo.getXmlValueProperty());
            }
            for (Property property : tInfo.getPropertyList()) {
                JavaClass typeClass;
                TypeInfo targetInfo;
                if (tInfo.isSetXmlValueProperty()) {
                    if (property.isXmlValue() && !tInfo.getXmlValueProperty().getPropertyName().equals(property.getPropertyName())) {
                        throw JAXBException.xmlValueAlreadySet((String)property.getPropertyName(), (String)tInfo.getXmlValueProperty().getPropertyName(), (String)jClass.getName());
                    }
                    if (!(property.isXmlValue() || property.isAttribute() || property.isInverseReference())) {
                        throw JAXBException.propertyOrFieldShouldBeAnAttribute((String)property.getPropertyName());
                    }
                }
                if (property.isXmlIdRef() && (targetInfo = this.typeInfo.get((typeClass = property.getActualType()).getQualifiedName())) != null && targetInfo.getIDProperty() == null) {
                    throw JAXBException.invalidIdRef((String)property.getPropertyName(), (String)typeClass.getQualifiedName());
                }
                if (property.isXmlId() && tInfo.getIDProperty() != null && !tInfo.getIDProperty().getPropertyName().equals(property.getPropertyName())) {
                    throw JAXBException.idAlreadySet((String)property.getPropertyName(), (String)tInfo.getIDProperty().getPropertyName(), (String)jClass.getName());
                }
                if (property.isAnyAttribute() && tInfo.isSetAnyAttributePropertyName() && !tInfo.getAnyAttributePropertyName().equals(property.getPropertyName())) {
                    throw JAXBException.multipleAnyAttributeMapping((String)jClass.getName());
                }
                if (property.isAny() && tInfo.isSetAnyElementPropertyName() && !tInfo.getAnyElementPropertyName().equals(property.getPropertyName())) {
                    throw JAXBException.xmlAnyElementAlreadySet((String)property.getPropertyName(), (String)tInfo.getAnyElementPropertyName(), (String)jClass.getName());
                }
                if (property.isSwaAttachmentRef() && !this.areEquals(property.getActualType(), JAVAX_ACTIVATION_DATAHANDLER)) {
                    throw JAXBException.invalidAttributeRef((String)property.getPropertyName(), (String)jClass.getQualifiedName());
                }
                if (property.getXmlElementWrapper() != null && !this.isCollectionType(property) && !property.getType().isArray()) {
                    throw JAXBException.invalidElementWrapper((String)property.getPropertyName());
                }
                if (property.isChoice()) {
                    this.processChoiceProperty(property, tInfo, jClass, property.getActualType());
                }
                if (!property.isReference()) continue;
                this.processReferenceProperty(property, tInfo, jClass);
            }
        }
    }

    private void processTypeInfoProperties(JavaClass javaClass, TypeInfo info) {
        ArrayList<Property> properties = info.getPropertyList();
        for (Property property : properties) {
            this.processXmlID(property, javaClass, info);
            this.processXmlIDREF(property);
            JavaClass propertyType = property.getActualType();
            if (!this.shouldGenerateTypeInfo(propertyType)) continue;
            JavaClass[] jClassArray = new JavaClass[]{propertyType};
            this.buildNewTypeInfo(jClassArray);
        }
    }

    public void processJavaClasses(JavaClass[] classes) {
        ArrayList<JavaClass> classesToProcess = new ArrayList<JavaClass>();
        for (JavaClass javaClass : classes) {
            classesToProcess.add(javaClass);
        }
        this.checkForCallbackMethods();
    }

    private JavaClass[] processAdditionalClasses(JavaClass[] classes) {
        ArrayList<JavaClass> extraClasses = new ArrayList<JavaClass>();
        ArrayList<JavaClass> classesToProcess = new ArrayList<JavaClass>();
        for (JavaClass jClass : classes) {
            Class xmlElementType = null;
            JavaClass javaClass = jClass;
            TypeMappingInfo tmi = this.javaClassToTypeMappingInfos.get(javaClass);
            if (tmi != null) {
                Annotation[] annotations;
                Class adapterClass = this.typeMappingInfoToAdapterClasses.get(tmi);
                if (adapterClass != null) {
                    JavaClass adapterJavaClass = this.helper.getJavaClass(adapterClass);
                    JavaClass newType = this.helper.getJavaClass(Object.class);
                    for (Object nextMethod : adapterJavaClass.getDeclaredMethods()) {
                        JavaClass returnType;
                        JavaMethod method = (JavaMethod)nextMethod;
                        if (!method.getName().equals("marshal") || (returnType = method.getReturnType()).getQualifiedName().equals(newType.getQualifiedName())) continue;
                        newType = returnType;
                        break;
                    }
                    javaClass = newType;
                }
                if ((annotations = this.getAnnotations(tmi)) != null) {
                    for (int j = 0; j < annotations.length; ++j) {
                        javax.xml.bind.annotation.XmlElement javaAnnotation;
                        Annotation nextAnnotation = annotations[j];
                        if (nextAnnotation == null || !(nextAnnotation instanceof javax.xml.bind.annotation.XmlElement) || (javaAnnotation = (javax.xml.bind.annotation.XmlElement)nextAnnotation).type() == XmlElement.DEFAULT.class) continue;
                        xmlElementType = javaAnnotation.type();
                    }
                }
            }
            if (this.areEquals(javaClass, byte[].class) || this.areEquals(javaClass, Byte[].class) || this.areEquals(javaClass, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(javaClass, Source.class) || this.areEquals(javaClass, Image.class) || this.areEquals(javaClass, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                if (tmi != null && tmi.getXmlTagName() != null) continue;
                ElementDeclaration declaration = new ElementDeclaration(null, javaClass, javaClass.getQualifiedName(), false, XmlElementDecl.GLOBAL.class);
                declaration.setTypeMappingInfo(tmi);
                this.getGlobalElements().put(null, declaration);
                continue;
            }
            if (javaClass.isArray()) {
                Class generatedClass;
                if (!this.helper.isBuiltInJavaType(javaClass.getComponentType())) {
                    extraClasses.add(javaClass.getComponentType());
                }
                if ((generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                    generatedClass = this.generateWrapperForArrayClass(javaClass, tmi, xmlElementType);
                    extraClasses.add(this.helper.getJavaClass(generatedClass));
                    this.arrayClassesToGeneratedClasses.put(javaClass.getRawName(), generatedClass);
                }
                this.generatedClassesToArrayClasses.put(generatedClass, javaClass);
                this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
                continue;
            }
            if (this.isCollectionType(javaClass)) {
                Class generatedClass;
                JavaClass componentClass;
                if (javaClass.hasActualTypeArguments()) {
                    componentClass = (JavaClass)javaClass.getActualTypeArguments().toArray()[0];
                    if (!componentClass.isPrimitive()) {
                        extraClasses.add(componentClass);
                    }
                } else {
                    componentClass = this.helper.getJavaClass(Object.class);
                }
                if ((generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                    generatedClass = this.generateCollectionValue(javaClass, tmi, xmlElementType);
                    extraClasses.add(this.helper.getJavaClass(generatedClass));
                }
                this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
                continue;
            }
            if (this.isMapType(javaClass)) {
                Class generatedClass;
                JavaClass valueClass;
                JavaClass keyClass;
                if (javaClass.hasActualTypeArguments()) {
                    keyClass = (JavaClass)javaClass.getActualTypeArguments().toArray()[0];
                    if (!this.helper.isBuiltInJavaType(keyClass)) {
                        extraClasses.add(keyClass);
                    }
                    if (!this.helper.isBuiltInJavaType(valueClass = (JavaClass)javaClass.getActualTypeArguments().toArray()[1])) {
                        extraClasses.add(valueClass);
                    }
                } else {
                    keyClass = this.helper.getJavaClass(Object.class);
                    valueClass = this.helper.getJavaClass(Object.class);
                }
                if ((generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader())) == null) {
                    generatedClass = this.generateWrapperForMapClass(javaClass, keyClass, valueClass, tmi);
                    extraClasses.add(this.helper.getJavaClass(generatedClass));
                }
                this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
                continue;
            }
            this.processClass(javaClass, classesToProcess);
        }
        for (JavaClass javaClass : extraClasses) {
            this.processClass(javaClass, classesToProcess);
        }
        return classesToProcess.toArray(new JavaClass[classesToProcess.size()]);
    }

    private void processClass(JavaClass javaClass, ArrayList<JavaClass> classesToProcess) {
        if (this.shouldGenerateTypeInfo(javaClass)) {
            if (this.isXmlRegistry(javaClass)) {
                this.processObjectFactory(javaClass, classesToProcess);
            } else {
                classesToProcess.add(javaClass);
                TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
                if (info != null && info.isSetXmlSeeAlso()) {
                    for (String jClassName : info.getXmlSeeAlso()) {
                        classesToProcess.add(this.helper.getJavaClass(jClassName));
                    }
                }
                for (JavaClass innerClass : javaClass.getDeclaredClasses()) {
                    TypeInfo tInfo;
                    if (!this.shouldGenerateTypeInfo(innerClass) || ((tInfo = this.typeInfo.get(innerClass.getQualifiedName())) == null || tInfo.isTransient()) && this.helper.isAnnotationPresent(innerClass, XmlTransient.class)) continue;
                    classesToProcess.add(innerClass);
                }
            }
        }
    }

    private void processXmlSeeAlso(JavaClass javaClass, TypeInfo info) {
        Class xmlSeeAlsoClass = null;
        Method valueMethod = null;
        try {
            xmlSeeAlsoClass = PrivilegedAccessHelper.getClassForName((String)"javax.xml.bind.annotation.XmlSeeAlso");
            valueMethod = PrivilegedAccessHelper.getDeclaredMethod((Class)xmlSeeAlsoClass, (String)VALUE_METHOD_NAME, (Class[])new Class[0]);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        if (xmlSeeAlsoClass != null && this.helper.isAnnotationPresent(javaClass, xmlSeeAlsoClass)) {
            Annotation seeAlso = this.helper.getAnnotation(javaClass, xmlSeeAlsoClass);
            Class[] values = null;
            try {
                values = (Class[])PrivilegedAccessHelper.invokeMethod((Method)valueMethod, (Object)seeAlso, (Object[])new Object[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
            ArrayList<String> seeAlsoClassNames = new ArrayList<String>();
            for (Class next : values) {
                seeAlsoClassNames.add(next.getName());
            }
            info.setXmlSeeAlso(seeAlsoClassNames);
        }
    }

    private void processFactoryMethods(JavaClass javaClass, TypeInfo info) {
        JavaMethod factoryMethod = this.factoryMethods.get(javaClass.getRawName());
        if (factoryMethod != null) {
            info.setFactoryMethodName(factoryMethod.getName());
            info.setObjectFactoryClassName(factoryMethod.getOwningClass().getRawName());
            JavaClass[] paramTypes = factoryMethod.getParameterTypes();
            if (paramTypes != null && paramTypes.length > 0) {
                String[] paramTypeNames = new String[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramTypeNames[i] = paramTypes[i].getRawName();
                }
                info.setFactoryMethodParamTypes(paramTypeNames);
            }
        }
    }

    private void processPackageLevelAdapters(JavaClass javaClass, TypeInfo info) {
        JavaPackage pack = javaClass.getPackage();
        if (this.helper.isAnnotationPresent(pack, XmlJavaTypeAdapters.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter[] adapterArray;
            XmlJavaTypeAdapters adapters = (XmlJavaTypeAdapters)this.helper.getAnnotation(pack, XmlJavaTypeAdapters.class);
            for (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter next : adapterArray = adapters.value()) {
                this.processPackageLevelAdapter(next, info);
            }
        }
        if (this.helper.isAnnotationPresent(pack, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(pack, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
            this.processPackageLevelAdapter(adapter, info);
        }
    }

    private void processPackageLevelAdapter(javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter next, TypeInfo info) {
        JavaClass adapterClass = this.helper.getJavaClass(next.value());
        JavaClass boundType = this.helper.getJavaClass(next.type());
        if (boundType != null) {
            info.addPackageLevelAdapterClass(adapterClass, boundType);
        } else {
            this.getLogger().logWarning(JAXBMetadataLogger.INVALID_BOUND_TYPE, new Object[]{boundType, adapterClass});
        }
    }

    private void processClassLevelAdapters(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(javaClass, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
            String boundType = adapter.type().getName();
            if (boundType == null || boundType.equals("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT")) {
                boundType = javaClass.getRawName();
            }
            XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
            xja.setValue(adapter.value().getName());
            xja.setType(boundType);
            info.setXmlJavaTypeAdapter(xja);
        }
    }

    private void processSchemaTypes(JavaClass javaClass, TypeInfo info) {
        JavaPackage pack = javaClass.getPackage();
        if (this.helper.isAnnotationPresent(pack, XmlSchemaTypes.class)) {
            XmlSchemaType[] typeArray;
            XmlSchemaTypes types = (XmlSchemaTypes)this.helper.getAnnotation(pack, XmlSchemaTypes.class);
            for (XmlSchemaType next : typeArray = types.value()) {
                this.processSchemaType(next);
            }
        } else if (this.helper.isAnnotationPresent(pack, XmlSchemaType.class)) {
            this.processSchemaType((XmlSchemaType)this.helper.getAnnotation(pack, XmlSchemaType.class));
        }
    }

    private void processXmlRootElement(JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) {
            XmlRootElement rootElemAnnotation = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement xmlRE = new org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement();
            xmlRE.setName(rootElemAnnotation.name());
            xmlRE.setNamespace(rootElemAnnotation.namespace());
            info.setXmlRootElement(xmlRE);
        }
    }

    private void preProcessXmlType(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        org.eclipse.persistence.jaxb.xmlmodel.XmlType xmlType = new org.eclipse.persistence.jaxb.xmlmodel.XmlType();
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType typeAnnotation = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            xmlType.setName(typeAnnotation.name());
            xmlType.setNamespace(typeAnnotation.namespace());
            String[] propOrder = typeAnnotation.propOrder();
            if (propOrder != null) {
                xmlType.getPropOrder();
            }
            for (String prop : propOrder) {
                xmlType.getPropOrder().add(prop);
            }
            Class factoryClass = typeAnnotation.factoryClass();
            if (factoryClass == XmlType.DEFAULT.class) {
                xmlType.setFactoryClass("javax.xml.bind.annotation.XmlType.DEFAULT");
            } else {
                xmlType.setFactoryClass(factoryClass.getCanonicalName());
            }
            xmlType.setFactoryMethod(typeAnnotation.factoryMethod());
        } else {
            xmlType.setName(this.getSchemaTypeNameForClassName(javaClass.getName()));
            xmlType.setNamespace(packageNamespace.getNamespace());
        }
        info.setXmlType(xmlType);
    }

    private void postProcessXmlType(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        String typeName;
        org.eclipse.persistence.jaxb.xmlmodel.XmlType xmlType = info.getXmlType();
        String factoryClassName = xmlType.getFactoryClass();
        String factoryMethodName = xmlType.getFactoryMethod();
        if (factoryClassName.equals("javax.xml.bind.annotation.XmlType.DEFAULT")) {
            if (factoryMethodName != null && !factoryMethodName.equals("")) {
                JavaMethod method = javaClass.getDeclaredMethod(factoryMethodName, new JavaClass[0]);
                if (method == null) {
                    throw JAXBException.factoryMethodNotDeclared((String)factoryMethodName, (String)javaClass.getName());
                }
                info.setObjectFactoryClassName(javaClass.getRawName());
                info.setFactoryMethodName(factoryMethodName);
            }
        } else {
            if (factoryMethodName == null || factoryMethodName.equals("")) {
                throw JAXBException.factoryClassWithoutFactoryMethod((String)javaClass.getName());
            }
            info.setObjectFactoryClassName(factoryClassName);
            info.setFactoryMethodName(factoryMethodName);
        }
        if ((typeName = xmlType.getName()).equals("##default")) {
            typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
        }
        info.setSchemaTypeName(typeName);
        if (xmlType.isSetPropOrder()) {
            List<String> props = xmlType.getPropOrder();
            if (props.size() == 0) {
                info.setPropOrder(new String[0]);
            } else if (props.get(0).equals("")) {
                info.setPropOrder(new String[]{""});
            } else {
                info.setPropOrder(xmlType.getPropOrder().toArray(new String[xmlType.getPropOrder().size()]));
            }
        }
        if (xmlType.getNamespace().equals("##default")) {
            info.setClassNamespace(packageNamespace.getNamespace());
        } else {
            info.setClassNamespace(xmlType.getNamespace());
        }
    }

    private void preProcessXmlAccessorType(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorType.class)) {
            XmlAccessorType accessorType = (XmlAccessorType)this.helper.getAnnotation(javaClass, XmlAccessorType.class);
            XmlAccessType xmlAccessType = XmlAccessType.fromValue(accessorType.value().name());
            info.setXmlAccessType(xmlAccessType);
        }
    }

    private void postProcessXmlAccessorType(TypeInfo info, NamespaceInfo packageNamespace) {
        if (!info.isSetXmlAccessType()) {
            info.setXmlAccessType(XmlAccessType.fromValue(packageNamespace.getAccessType().name()));
        }
    }

    private void preProcessXmlAccessorOrder(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        XmlAccessorOrder order = null;
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorOrder.class)) {
            order = (XmlAccessorOrder)this.helper.getAnnotation(javaClass, XmlAccessorOrder.class);
            info.setXmlAccessOrder(XmlAccessOrder.fromValue(order.value().name()));
        }
    }

    private void postProcessXmlAccessorOrder(TypeInfo info, NamespaceInfo packageNamespace) {
        if (!info.isSetXmlAccessOrder()) {
            info.setXmlAccessOrder(XmlAccessOrder.fromValue(packageNamespace.getAccessOrder().name()));
        }
        info.orderProperties();
    }

    private void processXmlElement(Property property, TypeInfo info) {
        if (this.helper.isAnnotationPresent(property.getElement(), javax.xml.bind.annotation.XmlElement.class)) {
            javax.xml.bind.annotation.XmlElement element = (javax.xml.bind.annotation.XmlElement)this.helper.getAnnotation(property.getElement(), javax.xml.bind.annotation.XmlElement.class);
            property.setIsRequired(element.required());
            property.setNillable(element.nillable());
            if (element.type() != XmlElement.DEFAULT.class) {
                property.setOriginalType(property.getType());
                property.setType(this.helper.getJavaClass(element.type()));
                property.setHasXmlElementType(true);
            }
            if (!element.defaultValue().equals("\u0000")) {
                property.setDefaultValue(element.defaultValue());
            }
            this.validateElementIsInPropOrder(info, property.getPropertyName());
        }
    }

    private void processXmlID(Property property, JavaClass javaClass, TypeInfo info) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
            property.setIsXmlId(true);
            info.setIDProperty(property);
        }
    }

    private void processXmlIDREF(Property property) {
        if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
            property.setIsXmlIdRef(true);
        }
    }

    private void processXmlJavaTypeAdapter(Property property, TypeInfo info) {
        JavaClass adapterClass = null;
        JavaClass ptype = property.getActualType();
        if (this.helper.isAnnotationPresent(property.getElement(), javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
            javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter adapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
            XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
            xja.setValue(adapter.value().getName());
            xja.setType(adapter.type().getName());
            property.setXmlJavaTypeAdapter(xja);
        } else {
            TypeInfo ptypeInfo = this.typeInfo.get(ptype.getQualifiedName());
            if (ptypeInfo == null && this.shouldGenerateTypeInfo(ptype)) {
                JavaClass[] jClassArray = new JavaClass[]{ptype};
                this.buildNewTypeInfo(jClassArray);
            }
            if (ptypeInfo != null && ptypeInfo.getXmlJavaTypeAdapter() != null) {
                property.setXmlJavaTypeAdapter(ptypeInfo.getXmlJavaTypeAdapter());
            } else if (info.getPackageLevelAdaptersByClass().get(ptype.getQualifiedName()) != null) {
                adapterClass = info.getPackageLevelAdapterClass(ptype);
                XmlJavaTypeAdapter xja = new XmlJavaTypeAdapter();
                xja.setValue(adapterClass.getQualifiedName());
                xja.setType(ptype.getQualifiedName());
                property.setXmlJavaTypeAdapter(xja);
            }
        }
    }

    private void processTypeQName(JavaClass javaClass, TypeInfo info, NamespaceInfo packageNamespace) {
        String typeName = info.getSchemaTypeName();
        if (typeName != null && !"".equals(typeName)) {
            QName typeQName = new QName(info.getClassNamespace(), typeName);
            boolean containsQName = this.typeQNames.contains(typeQName);
            if (containsQName) {
                throw JAXBException.nameCollision((String)typeQName.getNamespaceURI(), (String)typeQName.getLocalPart());
            }
            this.typeQNames.add(typeQName);
        }
    }

    public boolean shouldGenerateTypeInfo(JavaClass javaClass) {
        if (javaClass == null || javaClass.isPrimitive() || javaClass.isAnnotation() || javaClass.isInterface() || javaClass.isArray()) {
            return false;
        }
        if (javaClass.getRawName().equals("org.eclipse.persistence.internal.jaxb.ArrayWrappedValue")) {
            return false;
        }
        if (this.userDefinedSchemaTypes.get(javaClass.getQualifiedName()) != null) {
            return false;
        }
        if (this.helper.isBuiltInJavaType(javaClass)) {
            return false;
        }
        return !this.isCollectionType(javaClass) && !this.isMapType(javaClass);
    }

    public ArrayList<Property> getPropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> returnList = new ArrayList<Property>();
        if (!info.isTransient()) {
            JavaClass superClass = cls.getSuperclass();
            TypeInfo superClassInfo = this.typeInfo.get(superClass.getQualifiedName());
            while (superClassInfo != null && superClassInfo.isTransient()) {
                ArrayList superProps = this.getPublicMemberPropertiesForClass(superClass, superClassInfo);
                returnList.addAll(0, superProps);
                superClass = superClass.getSuperclass();
                superClassInfo = this.typeInfo.get(superClass.getQualifiedName());
            }
        }
        if (info.isTransient()) {
            returnList.addAll(this.getNoAccessTypePropertiesForClass(cls, info));
        } else if (info.getXmlAccessType() == XmlAccessType.FIELD) {
            returnList.addAll(this.getFieldPropertiesForClass(cls, info, false));
        } else if (info.getXmlAccessType() == XmlAccessType.PROPERTY) {
            returnList.addAll(this.getPropertyPropertiesForClass(cls, info, false));
        } else if (info.getXmlAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            returnList.addAll(this.getPublicMemberPropertiesForClass(cls, info));
        } else {
            returnList.addAll(this.getNoAccessTypePropertiesForClass(cls, info));
        }
        return returnList;
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        for (JavaField nextField : cls.getDeclaredFields()) {
            if (!this.helper.isAnnotationPresent(nextField, XmlTransient.class)) {
                Property property;
                int modifiers = nextField.getModifiers();
                if (Modifier.isTransient(modifiers) || (!Modifier.isPublic(nextField.getModifiers()) || !onlyPublic) && onlyPublic) continue;
                if (!Modifier.isStatic(modifiers)) {
                    property = this.buildNewProperty(info, cls, nextField, nextField.getName(), nextField.getResolvedType());
                    properties.add(property);
                    continue;
                }
                if (!Modifier.isFinal(modifiers) || !this.helper.isAnnotationPresent(nextField, XmlAttribute.class)) continue;
                try {
                    property = this.buildNewProperty(info, cls, nextField, nextField.getName(), nextField.getResolvedType());
                    Object value = ((JavaFieldImpl)nextField).get(null);
                    String stringValue = (String)XMLConversionManager.getDefaultXMLManager().convertObject(value, String.class, property.getSchemaType());
                    property.setFixedValue(stringValue);
                    properties.add(property);
                }
                catch (ClassCastException e) {
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            List<String> propOrderList = Arrays.asList(info.getPropOrder());
            if (!propOrderList.contains(nextField.getName())) continue;
            throw JAXBException.transientInProporder((String)nextField.getName());
        }
        return properties;
    }

    private Property buildNewProperty(TypeInfo info, JavaClass cls, JavaHasAnnotations javaHasAnnotations, String propertyName, JavaClass ptype) {
        TypeInfo refClassInfo;
        Property property = null;
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElements.class)) {
            property = this.buildChoiceProperty(javaHasAnnotations);
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class)) {
            XmlAnyElement anyElement = (XmlAnyElement)this.helper.getAnnotation(javaHasAnnotations, XmlAnyElement.class);
            property = new Property(this.helper);
            property.setIsAny(true);
            if (anyElement.value() != null) {
                property.setDomHandlerClassName(anyElement.value().getName());
            }
            property.setLax(anyElement.lax());
            info.setAnyElementPropertyName(propertyName);
        } else {
            property = this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRef.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRefs.class) ? this.buildReferenceProperty(info, javaHasAnnotations, propertyName, ptype) : new Property(this.helper);
        }
        property.setPropertyName(propertyName);
        property.setElement(javaHasAnnotations);
        TypeInfo pTypeInfo = this.typeInfo.get(ptype.getQualifiedName());
        if (pTypeInfo != null && !pTypeInfo.isTransient() || !this.helper.isAnnotationPresent(ptype, XmlTransient.class)) {
            property.setType(ptype);
        } else {
            for (JavaClass parent = ptype.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
                if (parent.getName().equals("java.lang.Object")) {
                    property.setType(parent);
                    break;
                }
                TypeInfo parentTypeInfo = this.typeInfo.get(parent.getQualifiedName());
                if ((parentTypeInfo == null || parentTypeInfo.isTransient()) && this.helper.isAnnotationPresent(parent, XmlTransient.class)) continue;
                property.setType(parent);
                break;
            }
        }
        property.setSchemaName(this.getQNameForProperty(propertyName, javaHasAnnotations, this.getNamespaceInfoForPackage(cls), info.getClassNamespace()));
        this.processPropertyAnnotations(info, cls, javaHasAnnotations, property);
        ptype = property.getActualType();
        if (ptype.isPrimitive() || ptype.isArray() && ptype.getComponentType().isPrimitive()) {
            property.setIsRequired(true);
        }
        if (!property.isSetXmlJavaTypeAdapter() && (refClassInfo = this.getTypeInfo().get(ptype.getQualifiedName())) != null && refClassInfo.isSetXmlJavaTypeAdapter()) {
            property.setXmlJavaTypeAdapter(refClassInfo.getXmlJavaTypeAdapter());
        }
        return property;
    }

    private Property buildChoiceProperty(JavaHasAnnotations javaHasAnnotations) {
        Property choiceProperty = new Property(this.helper);
        choiceProperty.setChoice(true);
        boolean isIdRef = this.helper.isAnnotationPresent(javaHasAnnotations, XmlIDREF.class);
        choiceProperty.setIsXmlIdRef(isIdRef);
        org.eclipse.persistence.jaxb.xmlmodel.XmlElements xmlElements = new org.eclipse.persistence.jaxb.xmlmodel.XmlElements();
        javax.xml.bind.annotation.XmlElement[] elements = ((XmlElements)this.helper.getAnnotation(javaHasAnnotations, XmlElements.class)).value();
        for (int i = 0; i < elements.length; ++i) {
            javax.xml.bind.annotation.XmlElement next = elements[i];
            XmlElement xmlElement = new XmlElement();
            xmlElement.setDefaultValue(next.defaultValue());
            xmlElement.setName(next.name());
            xmlElement.setNamespace(next.namespace());
            xmlElement.setNillable(next.nillable());
            xmlElement.setRequired(next.required());
            xmlElement.setType(next.type().getName());
            xmlElements.getXmlElement().add(xmlElement);
        }
        choiceProperty.setXmlElements(xmlElements);
        return choiceProperty;
    }

    private void processChoiceProperty(Property choiceProperty, TypeInfo info, JavaClass cls, JavaClass propertyType) {
        String propertyName = choiceProperty.getPropertyName();
        this.validateElementIsInPropOrder(info, propertyName);
        ArrayList<Property> choiceProperties = new ArrayList<Property>();
        for (XmlElement next : choiceProperty.getXmlElements().getXmlElement()) {
            NamespaceInfo namespaceInfo;
            TypeInfo tInfo;
            String name = next.getName();
            if (name == null || name.equals("##default")) {
                name = next.getJavaAttribute() != null ? next.getJavaAttribute() : propertyName;
            }
            if (choiceProperty.isXmlIdRef() && ((tInfo = this.typeInfo.get(next.getType())) == null || !tInfo.isIDSet())) {
                throw JAXBException.invalidXmlElementInXmlElementsList((String)propertyName, (String)name);
            }
            Property choiceProp = new Property(this.helper);
            String namespace = next.getNamespace();
            QName qName = null;
            qName = !namespace.equals("##default") ? new QName(namespace, name) : ((namespaceInfo = this.getNamespaceInfoForPackage(cls)).isElementFormQualified() ? new QName(namespaceInfo.getNamespace(), name) : new QName(name));
            choiceProp.setPropertyName(name);
            if (next.getType().equals("javax.xml.bind.annotation.XmlElement.DEFAULT") || next.getType().equals("javax.xml.bind.annotation.XmlElement$DEFAULT")) {
                choiceProp.setType(propertyType);
            } else {
                choiceProp.setType(this.helper.getJavaClass(next.getType()));
            }
            choiceProp.setSchemaName(qName);
            choiceProp.setSchemaType(this.getSchemaTypeFor(choiceProp.getType()));
            choiceProp.setIsXmlIdRef(choiceProperty.isXmlIdRef());
            choiceProp.setXmlElementWrapper(choiceProperty.getXmlElementWrapper());
            choiceProperties.add(choiceProp);
        }
        choiceProperty.setChoiceProperties(choiceProperties);
    }

    private Property buildReferenceProperty(TypeInfo info, JavaHasAnnotations javaHasAnnotations, String propertyName, JavaClass ptype) {
        XmlElementRef[] elementRefs;
        Property property = new Property(this.helper);
        property.setType(ptype);
        XmlElementRef ref = (XmlElementRef)this.helper.getAnnotation(javaHasAnnotations, XmlElementRef.class);
        if (ref != null) {
            elementRefs = new XmlElementRef[]{ref};
        } else {
            XmlElementRefs refs = (XmlElementRefs)this.helper.getAnnotation(javaHasAnnotations, XmlElementRefs.class);
            elementRefs = refs.value();
            info.setElementRefsPropertyName(propertyName);
        }
        ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef> eltRefs = new ArrayList<org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef>();
        for (XmlElementRef nextRef : elementRefs) {
            org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef eltRef = new org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef();
            eltRef.setName(nextRef.name());
            eltRef.setNamespace(nextRef.namespace());
            eltRef.setType(nextRef.type().getName());
            eltRefs.add(eltRef);
        }
        property.setIsReference(true);
        property.setXmlElementRefs(eltRefs);
        return property;
    }

    private Property processReferenceProperty(Property property, TypeInfo info, JavaClass cls) {
        String propertyName = property.getPropertyName();
        this.validateElementIsInPropOrder(info, propertyName);
        for (org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef nextRef : property.getXmlElementRefs()) {
            ElementDeclaration referencedElement;
            JavaClass type = property.getType();
            String typeName = type.getQualifiedName();
            if (this.isCollectionType(property) && type.hasActualTypeArguments()) {
                type = (JavaClass)type.getActualTypeArguments().toArray()[0];
                typeName = type.getQualifiedName();
            }
            if (!nextRef.getType().equals("javax.xml.bind.annotation.XmlElementRef.DEFAULT") && !nextRef.getType().equals("javax.xml.bind.annotation.XmlElementRef$DEFAULT")) {
                typeName = nextRef.getType();
            }
            if ((referencedElement = this.xmlRootElements.get(typeName)) != null) {
                this.addReferencedElement(property, referencedElement);
                continue;
            }
            String name = nextRef.getName();
            String namespace = nextRef.getNamespace();
            if (namespace.equals("##default")) {
                namespace = "";
            }
            QName qname = new QName(namespace, name);
            JavaClass scopeClass = cls;
            while (!scopeClass.getName().equals("java.lang.Object")) {
                HashMap<QName, ElementDeclaration> elements = this.getElementDeclarationsForScope(scopeClass.getName());
                if (elements != null) {
                    referencedElement = elements.get(qname);
                }
                if (referencedElement != null) break;
                scopeClass = scopeClass.getSuperclass();
            }
            if (referencedElement == null) {
                referencedElement = this.getGlobalElements().get(qname);
            }
            if (referencedElement != null) {
                this.addReferencedElement(property, referencedElement);
                continue;
            }
            throw JAXBException.invalidElementRef((String)property.getPropertyName(), (String)cls.getName());
        }
        return property;
    }

    private void processPropertyAnnotations(TypeInfo info, JavaClass cls, JavaHasAnnotations javaHasAnnotations, Property property) {
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlMixed.class)) {
            info.setMixed(true);
            property.setMixedContent(true);
        }
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlContainerProperty.class)) {
            XmlContainerProperty container = (XmlContainerProperty)this.helper.getAnnotation(javaHasAnnotations, XmlContainerProperty.class);
            property.setInverseReferencePropertyName(container.value());
            property.setInverseReferencePropertyGetMethodName(container.getMethodName());
            property.setInverseReferencePropertySetMethodName(container.setMethodName());
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlInverseReference.class)) {
            XmlInverseReference inverseReference = (XmlInverseReference)this.helper.getAnnotation(javaHasAnnotations, XmlInverseReference.class);
            property.setInverseReferencePropertyName(inverseReference.mappedBy());
            TypeInfo targetInfo = this.getTypeInfo().get(property.getActualType().getName());
            if (targetInfo != null && targetInfo.getXmlAccessType() == XmlAccessType.PROPERTY) {
                String propName = property.getPropertyName();
                propName = Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
                property.setInverseReferencePropertyGetMethodName("get" + propName);
                property.setInverseReferencePropertySetMethodName("set" + propName);
            }
            property.setInverseReference(true);
        }
        this.processXmlJavaTypeAdapter(property, info);
        this.processXmlElement(property, info);
        JavaClass ptype = property.getActualType();
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAttachmentRef.class) && this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER)) {
            property.setIsSwaAttachmentRef(true);
            property.setSchemaType(XMLConstants.SWA_REF_QNAME);
        } else if (this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(ptype, byte[].class) || this.areEquals(ptype, Byte[].class) || this.areEquals(ptype, Image.class) || this.areEquals(ptype, Source.class) || this.areEquals(ptype, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
            property.setIsMtomAttachment(true);
            property.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlMimeType.class)) {
            property.setMimeType(((XmlMimeType)this.helper.getAnnotation(property.getElement(), XmlMimeType.class)).value());
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlInlineBinaryData.class) || info.isBinaryDataToBeInlined()) {
            property.setisInlineBinaryData(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
            XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
            QName schemaTypeQname = new QName(schemaType.namespace(), schemaType.name());
            property.setSchemaType(schemaTypeQname);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
            property.setIsAttribute(true);
            property.setIsRequired(((XmlAttribute)this.helper.getAnnotation(property.getElement(), XmlAttribute.class)).required());
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
            if (info.isSetAnyAttributePropertyName()) {
                throw JAXBException.multipleAnyAttributeMapping((String)cls.getName());
            }
            if (!property.getType().getName().equals("java.util.Map")) {
                throw JAXBException.anyAttributeOnNonMap((String)property.getPropertyName());
            }
            property.setIsAnyAttribute(true);
            info.setAnyAttributePropertyName(property.getPropertyName());
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class)) {
            XmlElementWrapper wrapper = (XmlElementWrapper)this.helper.getAnnotation(property.getElement(), XmlElementWrapper.class);
            org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper xmlEltWrapper = new org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper();
            xmlEltWrapper.setName(wrapper.name());
            xmlEltWrapper.setNamespace(wrapper.namespace());
            xmlEltWrapper.setNillable(wrapper.nillable());
            xmlEltWrapper.setRequired(wrapper.required());
            property.setXmlElementWrapper(xmlEltWrapper);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
            if (!this.isCollectionType(property) && !property.getType().isArray()) {
                throw JAXBException.invalidList((String)property.getPropertyName());
            }
            property.setIsXmlList(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
            property.setIsXmlValue(true);
            info.setXmlValueProperty(property);
        }
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        ArrayList<JavaMethod> propertyMethods = new ArrayList<JavaMethod>();
        for (JavaMethod next : new ArrayList(cls.getDeclaredMethods())) {
            int modifiers;
            if (next.getName().startsWith("get") && next.getName().length() > 3 || next.getName().startsWith("is") && next.getName().length() > 2) {
                modifiers = next.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic) continue;
                propertyMethods.add(next);
                continue;
            }
            if (!next.getName().startsWith("set") || next.getName().length() <= 3 || Modifier.isStatic(modifiers = next.getModifiers()) || Modifier.isTransient(modifiers) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic) continue;
            propertyMethods.add(next);
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (int i = 0; i < propertyMethods.size(); ++i) {
            JavaMethod setMethod;
            JavaMethod getMethod;
            boolean isPropertyTransient = false;
            JavaMethod nextMethod = (JavaMethod)propertyMethods.get(i);
            String propertyName = "";
            JavaMethod propertyMethod = null;
            if (!nextMethod.getName().startsWith("set")) {
                if (nextMethod.getName().startsWith("get")) {
                    propertyName = nextMethod.getName().substring(3);
                } else if (nextMethod.getName().startsWith("is")) {
                    propertyName = nextMethod.getName().substring(2);
                }
                getMethod = nextMethod;
                String setMethodName = "set" + propertyName;
                propertyName = Introspector.decapitalize(propertyName);
                JavaClass[] paramTypes = new JavaClass[]{getMethod.getReturnType()};
                setMethod = cls.getDeclaredMethod(setMethodName, paramTypes);
                if (setMethod != null && !setMethod.getAnnotations().isEmpty()) {
                    if (!this.helper.isAnnotationPresent(setMethod, XmlTransient.class)) {
                        propertyMethod = setMethod;
                    } else {
                        isPropertyTransient = true;
                    }
                } else if (!this.helper.isAnnotationPresent(getMethod, XmlTransient.class)) {
                    propertyMethod = getMethod;
                } else {
                    isPropertyTransient = true;
                }
            } else {
                propertyName = nextMethod.getName().substring(3);
                setMethod = nextMethod;
                String getMethodName = "get" + propertyName;
                getMethod = cls.getDeclaredMethod(getMethodName, new JavaClass[0]);
                if (getMethod == null) {
                    getMethodName = "is" + propertyName;
                    getMethod = cls.getDeclaredMethod(getMethodName, new JavaClass[0]);
                }
                if (getMethod != null && !getMethod.getAnnotations().isEmpty()) {
                    if (!this.helper.isAnnotationPresent(getMethod, XmlTransient.class)) {
                        propertyMethod = getMethod;
                    } else {
                        isPropertyTransient = true;
                    }
                } else if (!this.helper.isAnnotationPresent(setMethod, XmlTransient.class)) {
                    propertyMethod = setMethod;
                } else {
                    isPropertyTransient = true;
                }
                propertyName = Introspector.decapitalize(propertyName);
            }
            JavaClass ptype = null;
            ptype = getMethod != null ? getMethod.getReturnType() : setMethod.getParameterTypes()[0];
            if (propertyNames.contains(propertyName)) continue;
            propertyNames.add(propertyName);
            Property property = this.buildNewProperty(info, cls, propertyMethod, propertyName, ptype);
            property.setTransient(isPropertyTransient);
            if (getMethod != null) {
                property.setGetMethodName(getMethod.getName());
            }
            if (setMethod != null) {
                property.setSetMethodName(setMethod.getName());
            }
            property.setMethodProperty(true);
            if (!this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class)) {
                properties.add(property);
                continue;
            }
            List<String> propOrderList = Arrays.asList(info.getPropOrder());
            if (propOrderList.contains(propertyName)) {
                throw JAXBException.transientInProporder((String)propertyName);
            }
            property.setTransient(true);
        }
        Collections.sort(properties, new PropertyComparitor());
        return properties;
    }

    public ArrayList getPublicMemberPropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, false);
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, false);
        ArrayList<Property> publicFieldProperties = new ArrayList<Property>();
        ArrayList<Property> publicMethodProperties = new ArrayList<Property>();
        for (Property next : fieldProperties) {
            if (Modifier.isPublic(((JavaField)next.getElement()).getModifiers())) {
                publicFieldProperties.add(next);
                continue;
            }
            if (!this.hasJAXBAnnotations(next.getElement())) continue;
            publicFieldProperties.add(next);
        }
        for (Property next : methodProperties) {
            if (next.getElement() == null) continue;
            if (Modifier.isPublic(((JavaMethod)next.getElement()).getModifiers())) {
                publicMethodProperties.add(next);
                continue;
            }
            if (!this.hasJAXBAnnotations(next.getElement())) continue;
            publicMethodProperties.add(next);
        }
        if (publicFieldProperties.size() >= 0 && publicMethodProperties.size() == 0) {
            return publicFieldProperties;
        }
        if (publicMethodProperties.size() > 0 && publicFieldProperties.size() == 0) {
            return publicMethodProperties;
        }
        HashMap fieldPropertyMap = this.getPropertyMapFromArrayList(publicFieldProperties);
        for (int i = 0; i < publicMethodProperties.size(); ++i) {
            Property next = (Property)publicMethodProperties.get(i);
            if (fieldPropertyMap.get(next.getPropertyName()) != null) continue;
            publicFieldProperties.add(next);
        }
        return publicFieldProperties;
    }

    public HashMap getPropertyMapFromArrayList(ArrayList<Property> props) {
        HashMap<String, Property> propMap = new HashMap<String, Property>(props.size());
        for (Property next : props) {
            propMap.put(next.getPropertyName(), next);
        }
        return propMap;
    }

    public ArrayList getNoAccessTypePropertiesForClass(JavaClass cls, TypeInfo info) {
        JavaHasAnnotations elem;
        Property next;
        int i;
        ArrayList<Property> list = new ArrayList<Property>();
        if (cls == null) {
            return list;
        }
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, false);
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, false);
        for (i = 0; i < fieldProperties.size(); ++i) {
            next = fieldProperties.get(i);
            elem = next.getElement();
            if (!this.hasJAXBAnnotations(elem)) continue;
            list.add(next);
        }
        for (i = 0; i < methodProperties.size(); ++i) {
            next = methodProperties.get(i);
            elem = next.getElement();
            if (!this.hasJAXBAnnotations(elem)) continue;
            list.add(next);
        }
        return list;
    }

    public void processSchemaType(String name, String namespace, String jClassQualifiedName) {
        this.userDefinedSchemaTypes.put(jClassQualifiedName, new QName(namespace, name));
    }

    public void processSchemaType(XmlSchemaType type) {
        JavaClass jClass = this.helper.getJavaClass(type.type());
        if (jClass == null) {
            return;
        }
        this.processSchemaType(type.name(), type.namespace(), jClass.getQualifiedName());
    }

    public void addEnumTypeInfo(JavaClass javaClass, EnumTypeInfo info) {
        if (javaClass == null) {
            return;
        }
        info.setClassName(javaClass.getQualifiedName());
        Class restrictionClass = String.class;
        if (this.helper.isAnnotationPresent(javaClass, XmlEnum.class)) {
            XmlEnum xmlEnum = (XmlEnum)this.helper.getAnnotation(javaClass, XmlEnum.class);
            restrictionClass = xmlEnum.value();
        }
        QName restrictionBase = this.getSchemaTypeFor(this.helper.getJavaClass(restrictionClass));
        info.setRestrictionBase(restrictionBase);
        for (JavaField field : javaClass.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            String enumValue = field.getName();
            if (this.helper.isAnnotationPresent(field, XmlEnumValue.class)) {
                enumValue = ((XmlEnumValue)this.helper.getAnnotation(field, XmlEnumValue.class)).value();
            }
            info.addJavaFieldToXmlEnumValuePair(field.getName(), enumValue);
        }
    }

    private String decapitalize(String javaName) {
        int i;
        char[] name = javaName.toCharArray();
        for (i = 0; i < name.length && Character.isUpperCase(name[i]); ++i) {
        }
        if (i > 0) {
            name[0] = Character.toLowerCase(name[0]);
            for (int j = 1; j < i - 1; ++j) {
                name[j] = Character.toLowerCase(name[j]);
            }
            return new String(name);
        }
        return javaName;
    }

    public String getSchemaTypeNameForClassName(String className) {
        String typeName = "";
        typeName = className.indexOf(36) != -1 ? this.decapitalize(className.substring(className.lastIndexOf(36) + 1)) : this.decapitalize(className.substring(className.lastIndexOf(46) + 1));
        boolean inBreak = false;
        StringBuffer toReturn = new StringBuffer(typeName.length());
        for (int i = 0; i < typeName.length(); ++i) {
            char next = typeName.charAt(i);
            if (Character.isDigit(next)) {
                if (!inBreak) {
                    inBreak = true;
                }
                toReturn.append(next);
                continue;
            }
            if (inBreak) {
                toReturn.append(Character.toUpperCase(next));
                continue;
            }
            toReturn.append(next);
        }
        return toReturn.toString();
    }

    public QName getSchemaTypeOrNullFor(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        QName schemaType = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (schemaType == null) {
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        return schemaType;
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        QName schemaType = this.getSchemaTypeOrNullFor(javaClass);
        if (schemaType == null) {
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return schemaType;
    }

    public boolean isCollectionType(Property field) {
        return this.isCollectionType(field.getType());
    }

    public boolean isCollectionType(JavaClass type) {
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    public NamespaceInfo processNamespaceInformation(XmlSchema xmlSchema) {
        NamespaceInfo info = new NamespaceInfo();
        info.setNamespaceResolver(new NamespaceResolver());
        String packageNamespace = null;
        if (xmlSchema != null) {
            String namespaceMapping = xmlSchema.namespace();
            if (!namespaceMapping.equals("") && !namespaceMapping.equals("##default")) {
                packageNamespace = namespaceMapping;
            } else if (namespaceMapping.equals("##default")) {
                packageNamespace = this.defaultTargetNamespace;
            }
            info.setNamespace(packageNamespace);
            XmlNs[] xmlns = xmlSchema.xmlns();
            for (int i = 0; i < xmlns.length; ++i) {
                XmlNs next = xmlns[i];
                info.getNamespaceResolver().put(next.prefix(), next.namespaceURI());
            }
            info.setAttributeFormQualified(xmlSchema.attributeFormDefault() == XmlNsForm.QUALIFIED);
            info.setElementFormQualified(xmlSchema.elementFormDefault() == XmlNsForm.QUALIFIED);
            try {
                Method locationMethod = PrivilegedAccessHelper.getDeclaredMethod(XmlSchema.class, (String)"location", (Class[])new Class[0]);
                String location = (String)PrivilegedAccessHelper.invokeMethod((Method)locationMethod, (Object)xmlSchema, (Object[])new Object[0]);
                if (location != null) {
                    if (location.equals("##generate")) {
                        location = null;
                    } else if (location.equals("")) {
                        location = null;
                    }
                }
                info.setLocation(location);
            }
            catch (Exception ex) {}
        } else {
            info.setNamespace(this.defaultTargetNamespace);
        }
        if (!info.isElementFormQualified() || info.isAttributeFormQualified()) {
            this.isDefaultNamespaceAllowed = false;
        }
        return info;
    }

    public HashMap<String, TypeInfo> getTypeInfo() {
        return this.typeInfo;
    }

    public ArrayList<JavaClass> getTypeInfoClasses() {
        return this.typeInfoClasses;
    }

    public HashMap<String, QName> getUserDefinedSchemaTypes() {
        return this.userDefinedSchemaTypes;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public String getSchemaTypeNameFor(JavaClass javaClass, XmlType xmlType) {
        String typeName = "";
        if (javaClass == null) {
            return typeName;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType typeAnnotation = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            typeName = typeAnnotation.name();
            if (typeName.equals("#default")) {
                typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
            }
        } else {
            typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
        }
        return typeName;
    }

    public QName getQNameForProperty(String defaultName, JavaHasAnnotations element, NamespaceInfo namespaceInfo, String uri) {
        String name = "##default";
        String namespace = "##default";
        QName qName = null;
        if (this.helper.isAnnotationPresent(element, XmlAttribute.class)) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.helper.getAnnotation(element, XmlAttribute.class);
            name = xmlAttribute.name();
            namespace = xmlAttribute.namespace();
            if (name.equals("##default")) {
                name = defaultName;
            }
            if (!namespace.equals("##default")) {
                qName = new QName(namespace, name);
                this.isDefaultNamespaceAllowed = false;
            } else {
                qName = namespaceInfo.isAttributeFormQualified() ? new QName(uri, name) : new QName(name);
            }
        } else {
            if (this.helper.isAnnotationPresent(element, javax.xml.bind.annotation.XmlElement.class)) {
                javax.xml.bind.annotation.XmlElement xmlElement = (javax.xml.bind.annotation.XmlElement)this.helper.getAnnotation(element, javax.xml.bind.annotation.XmlElement.class);
                name = xmlElement.name();
                namespace = xmlElement.namespace();
            }
            if (name.equals("##default")) {
                name = defaultName;
            }
            if (!namespace.equals("##default")) {
                qName = new QName(namespace, name);
                if (namespace.equals("")) {
                    this.isDefaultNamespaceAllowed = false;
                }
            } else {
                qName = namespaceInfo.isElementFormQualified() ? new QName(uri, name) : new QName(name);
            }
        }
        return qName;
    }

    public HashMap<String, NamespaceInfo> getPackageToNamespaceMappings() {
        return this.packageToNamespaceMappings;
    }

    public void addPackageToNamespaceMapping(String packageName, NamespaceInfo nsInfo) {
        if (this.packageToNamespaceMappings == null) {
            this.packageToNamespaceMappings = new HashMap();
        }
        this.packageToNamespaceMappings.put(packageName, nsInfo);
    }

    public NamespaceInfo getNamespaceInfoForPackage(JavaClass javaClass) {
        NamespaceInfo packageNamespace = this.packageToNamespaceMappings.get(javaClass.getPackageName());
        if (packageNamespace == null) {
            packageNamespace = this.getNamespaceInfoForPackage(javaClass.getPackage());
        }
        return packageNamespace;
    }

    public NamespaceInfo getNamespaceInfoForPackage(JavaPackage pack) {
        NamespaceInfo packageNamespace = this.packageToNamespaceMappings.get(pack.getQualifiedName());
        if (packageNamespace == null) {
            XmlSchema xmlSchema = (XmlSchema)this.helper.getAnnotation(pack, XmlSchema.class);
            packageNamespace = this.processNamespaceInformation(xmlSchema);
            if (packageNamespace.getNamespace() == null) {
                packageNamespace.setNamespace("");
            }
            if (this.helper.isAnnotationPresent(pack, XmlAccessorType.class)) {
                XmlAccessorType xmlAccessorType = (XmlAccessorType)this.helper.getAnnotation(pack, XmlAccessorType.class);
                packageNamespace.setAccessType(XmlAccessType.fromValue(xmlAccessorType.value().name()));
            }
            if (this.helper.isAnnotationPresent(pack, XmlAccessorOrder.class)) {
                XmlAccessorOrder xmlAccessorOrder = (XmlAccessorOrder)this.helper.getAnnotation(pack, XmlAccessorOrder.class);
                packageNamespace.setAccessOrder(XmlAccessOrder.fromValue(xmlAccessorOrder.value().name()));
            }
            this.packageToNamespaceMappings.put(pack.getQualifiedName(), packageNamespace);
        }
        return packageNamespace;
    }

    public NamespaceInfo getNamespaceInfoForPackage(String packageName) {
        NamespaceInfo packageNamespace = this.packageToNamespaceMappings.get(packageName);
        if (packageName == null) {
            packageNamespace = new NamespaceInfo();
            packageNamespace.setNamespaceResolver(new NamespaceResolver());
            this.packageToNamespaceMappings.put(packageName, packageNamespace);
        }
        return packageNamespace;
    }

    private void checkForCallbackMethods() {
        for (JavaClass next : this.typeInfoClasses) {
            if (next == null) continue;
            JavaClass unmarshallerCls = this.helper.getJavaClass(Unmarshaller.class);
            JavaClass marshallerCls = this.helper.getJavaClass(Marshaller.class);
            JavaClass objectCls = this.helper.getJavaClass(Object.class);
            JavaClass[] unmarshalParams = new JavaClass[]{unmarshallerCls, objectCls};
            JavaClass[] marshalParams = new JavaClass[]{marshallerCls};
            UnmarshalCallback unmarshalCallback = null;
            MarshalCallback marshalCallback = null;
            if (next.getMethod("beforeUnmarshal", unmarshalParams) != null) {
                unmarshalCallback = new UnmarshalCallback();
                unmarshalCallback.setDomainClassName(next.getQualifiedName());
                unmarshalCallback.setHasBeforeUnmarshalCallback();
            }
            if (next.getMethod("afterUnmarshal", unmarshalParams) != null) {
                if (unmarshalCallback == null) {
                    unmarshalCallback = new UnmarshalCallback();
                    unmarshalCallback.setDomainClassName(next.getQualifiedName());
                }
                unmarshalCallback.setHasAfterUnmarshalCallback();
            }
            if (unmarshalCallback != null) {
                if (this.unmarshalCallbacks == null) {
                    this.unmarshalCallbacks = new HashMap();
                }
                this.unmarshalCallbacks.put(next.getQualifiedName(), unmarshalCallback);
            }
            if (next.getMethod("beforeMarshal", marshalParams) != null) {
                marshalCallback = new MarshalCallback();
                marshalCallback.setDomainClassName(next.getQualifiedName());
                marshalCallback.setHasBeforeMarshalCallback();
            }
            if (next.getMethod("afterMarshal", marshalParams) != null) {
                if (marshalCallback == null) {
                    marshalCallback = new MarshalCallback();
                    marshalCallback.setDomainClassName(next.getQualifiedName());
                }
                marshalCallback.setHasAfterMarshalCallback();
            }
            if (marshalCallback == null) continue;
            if (this.marshalCallbacks == null) {
                this.marshalCallbacks = new HashMap();
            }
            this.marshalCallbacks.put(next.getQualifiedName(), marshalCallback);
        }
    }

    public HashMap<String, MarshalCallback> getMarshalCallbacks() {
        return this.marshalCallbacks;
    }

    public HashMap<String, UnmarshalCallback> getUnmarshalCallbacks() {
        return this.unmarshalCallbacks;
    }

    public JavaClass[] processObjectFactory(JavaClass objectFactoryClass, ArrayList<JavaClass> classes) {
        HashMap<String, XmlRegistry.XmlElementDecl> elemDecls = new HashMap<String, XmlRegistry.XmlElementDecl>();
        org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry xmlReg = this.xmlRegistries.get(objectFactoryClass.getQualifiedName());
        if (xmlReg != null) {
            for (XmlRegistry.XmlElementDecl xmlElementDecl : xmlReg.getXmlElementDecl()) {
                elemDecls.put(xmlElementDecl.getJavaMethod(), xmlElementDecl);
            }
        }
        Collection methods = objectFactoryClass.getDeclaredMethods();
        Iterator methodsIter = methods.iterator();
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForPackage(objectFactoryClass);
        while (methodsIter.hasNext()) {
            JavaMethod next = (JavaMethod)methodsIter.next();
            if (!next.getName().startsWith("create")) continue;
            JavaClass type = next.getReturnType();
            if (type.getName().equals("javax.xml.bind.JAXBElement")) {
                type = (JavaClass)next.getReturnType().getActualTypeArguments().toArray()[0];
            } else {
                this.factoryMethods.put(next.getReturnType().getRawName(), next);
            }
            XmlRegistry.XmlElementDecl xmlEltDecl = (XmlRegistry.XmlElementDecl)elemDecls.get(next.getName());
            if (xmlEltDecl != null || this.helper.isAnnotationPresent(next, XmlElementDecl.class)) {
                HashMap<QName, ElementDeclaration> elements;
                String subHeadNamespace;
                String subHeadLocal;
                String localName;
                String url;
                QName substitutionHead = null;
                String defaultValue = null;
                Class<XmlElementDecl.GLOBAL> scopeClass = XmlElementDecl.GLOBAL.class;
                if (xmlEltDecl != null) {
                    JavaClass jScopeClass;
                    url = xmlEltDecl.getNamespace();
                    localName = xmlEltDecl.getName();
                    String scopeClassName = xmlEltDecl.getScope();
                    if (!scopeClassName.equals("javax.xml.bind.annotation.XmlElementDecl.GLOBAL") && (jScopeClass = this.helper.getJavaClass(scopeClassName)) != null && (scopeClass = this.helper.getClassForJavaClass(jScopeClass)) == null) {
                        scopeClass = XmlElementDecl.GLOBAL.class;
                    }
                    if (!xmlEltDecl.getSubstitutionHeadName().equals("")) {
                        subHeadLocal = xmlEltDecl.getSubstitutionHeadName();
                        subHeadNamespace = xmlEltDecl.getSubstitutionHeadNamespace();
                        if (subHeadNamespace.equals("##default")) {
                            subHeadNamespace = namespaceInfo.getNamespace();
                        }
                        substitutionHead = new QName(subHeadNamespace, subHeadLocal);
                    }
                    if (xmlEltDecl.getDefaultValue().length() != 1 || !xmlEltDecl.getDefaultValue().startsWith("\u0000")) {
                        defaultValue = xmlEltDecl.getDefaultValue();
                    }
                } else {
                    XmlElementDecl elementDecl = (XmlElementDecl)this.helper.getAnnotation(next, XmlElementDecl.class);
                    url = elementDecl.namespace();
                    localName = elementDecl.name();
                    scopeClass = elementDecl.scope();
                    if (!elementDecl.substitutionHeadName().equals("")) {
                        subHeadLocal = elementDecl.substitutionHeadName();
                        subHeadNamespace = elementDecl.substitutionHeadNamespace();
                        if (subHeadNamespace.equals("##default")) {
                            subHeadNamespace = namespaceInfo.getNamespace();
                        }
                        substitutionHead = new QName(subHeadNamespace, subHeadLocal);
                    }
                    if (elementDecl.defaultValue().length() != 1 || !elementDecl.defaultValue().startsWith("\u0000")) {
                        defaultValue = elementDecl.defaultValue();
                    }
                }
                if ("##default".equals(url)) {
                    url = namespaceInfo.getNamespace();
                }
                QName qname = new QName(url, localName);
                boolean isList = false;
                if ("java.util.List".equals(type.getName())) {
                    isList = true;
                    if (type.hasActualTypeArguments()) {
                        type = (JavaClass)type.getActualTypeArguments().toArray()[0];
                    }
                }
                ElementDeclaration declaration = new ElementDeclaration(qname, type, type.getQualifiedName(), isList, scopeClass);
                if (substitutionHead != null) {
                    declaration.setSubstitutionHead(substitutionHead);
                }
                if (defaultValue != null) {
                    declaration.setDefaultValue(defaultValue);
                }
                if (this.helper.isAnnotationPresent(next, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class)) {
                    javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter typeAdapter = (javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter)this.helper.getAnnotation(next, javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.class);
                    Class typeAdapterClass = typeAdapter.value();
                    declaration.setJavaTypeAdapterClass(typeAdapterClass);
                    Method[] tacMethods = typeAdapterClass.getMethods();
                    Class<?> declJavaType = null;
                    for (int i = 0; i < tacMethods.length; ++i) {
                        Method method = tacMethods[i];
                        if (!method.getName().equals("marshal")) continue;
                        declJavaType = method.getReturnType();
                        break;
                    }
                    declaration.setJavaType(this.helper.getJavaClass(declJavaType));
                    declaration.setAdaptedJavaType(type);
                }
                if ((elements = this.getElementDeclarationsForScope(scopeClass.getName())) == null) {
                    elements = new HashMap();
                    this.elementDeclarations.put(scopeClass.getName(), elements);
                }
                elements.put(qname, declaration);
            }
            if (this.helper.isBuiltInJavaType(type) || classes.contains(type)) continue;
            classes.add(type);
        }
        if (classes.size() > 0) {
            return classes.toArray(new JavaClass[classes.size()]);
        }
        return new JavaClass[0];
    }

    public HashMap<QName, ElementDeclaration> getGlobalElements() {
        return this.elementDeclarations.get(XmlElementDecl.GLOBAL.class.getName());
    }

    public void updateGlobalElements(JavaClass[] classesToProcess) {
        for (JavaClass javaClass : classesToProcess) {
            int idx;
            char ch;
            TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
            if (info == null || info.isTransient() || !info.isSetXmlRootElement()) continue;
            org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement xmlRE = info.getXmlRootElement();
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForPackage(javaClass);
            String elementName = xmlRE.getName();
            if ((elementName.equals("##default") || elementName.equals("")) && (elementName = javaClass.getName().indexOf("$") != -1 ? Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(36) + 1)) : Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(46) + 1))).length() >= 3 && Character.isDigit(ch = elementName.charAt((idx = elementName.length() - 1) - 1))) {
                char lastCh = Character.toUpperCase(elementName.charAt(idx));
                elementName = elementName.substring(0, idx) + lastCh;
            }
            String rootNamespace = xmlRE.getNamespace();
            QName rootElemName = null;
            if (rootNamespace.equals("##default")) {
                if (namespaceInfo == null) {
                    rootElemName = new QName(elementName);
                } else {
                    String rootNS = namespaceInfo.getNamespace();
                    rootElemName = new QName(rootNS, elementName);
                    if (rootNS.equals("")) {
                        this.isDefaultNamespaceAllowed = false;
                    }
                }
            } else {
                rootElemName = new QName(rootNamespace, elementName);
                if (rootNamespace.equals("")) {
                    this.isDefaultNamespaceAllowed = false;
                }
            }
            ElementDeclaration declaration = new ElementDeclaration(rootElemName, javaClass, javaClass.getQualifiedName(), false);
            declaration.setIsXmlRootElement(true);
            this.getGlobalElements().put(rootElemName, declaration);
            this.xmlRootElements.put(javaClass.getQualifiedName(), declaration);
        }
        for (QName next : this.getGlobalElements().keySet()) {
            ElementDeclaration nextDeclaration = this.getGlobalElements().get(next);
            QName substitutionHead = nextDeclaration.getSubstitutionHead();
            while (substitutionHead != null) {
                ElementDeclaration rootDeclaration = this.getGlobalElements().get(substitutionHead);
                rootDeclaration.addSubstitutableElement(nextDeclaration);
                substitutionHead = rootDeclaration.getSubstitutionHead();
            }
        }
    }

    private void addReferencedElement(Property property, ElementDeclaration referencedElement) {
        property.addReferencedElement(referencedElement);
        if (referencedElement.getSubstitutableElements() != null && referencedElement.getSubstitutableElements().size() > 0) {
            for (ElementDeclaration substitutable : referencedElement.getSubstitutableElements()) {
                this.addReferencedElement(property, substitutable);
            }
        }
    }

    private boolean hasJAXBAnnotations(JavaHasAnnotations elem) {
        return this.helper.isAnnotationPresent(elem, javax.xml.bind.annotation.XmlElement.class) || this.helper.isAnnotationPresent(elem, XmlAttribute.class) || this.helper.isAnnotationPresent(elem, XmlAnyElement.class) || this.helper.isAnnotationPresent(elem, XmlAnyAttribute.class) || this.helper.isAnnotationPresent(elem, XmlValue.class) || this.helper.isAnnotationPresent(elem, XmlElements.class) || this.helper.isAnnotationPresent(elem, XmlElementRef.class) || this.helper.isAnnotationPresent(elem, XmlElementRefs.class) || this.helper.isAnnotationPresent(elem, XmlID.class) || this.helper.isAnnotationPresent(elem, XmlSchemaType.class) || this.helper.isAnnotationPresent(elem, XmlElementWrapper.class) || this.helper.isAnnotationPresent(elem, XmlList.class) || this.helper.isAnnotationPresent(elem, XmlMimeType.class) || this.helper.isAnnotationPresent(elem, XmlIDREF.class);
    }

    private void validateElementIsInPropOrder(TypeInfo info, String name) {
        if (info.isTransient()) {
            return;
        }
        String[] propOrder = info.getPropOrder();
        if (propOrder.length > 0) {
            if (propOrder.length == 1 && propOrder[0].equals("")) {
                return;
            }
            List<String> propOrderList = Arrays.asList(info.getPropOrder());
            if (!propOrderList.contains(name)) {
                throw JAXBException.missingPropertyInPropOrder((String)name);
            }
        }
    }

    private void validatePropOrderForInfo(TypeInfo info) {
        if (info.isTransient()) {
            return;
        }
        String[] propOrder = info.getPropOrder();
        int propOrderLength = propOrder.length;
        if (propOrderLength > 0) {
            for (int i = 1; i < propOrderLength; ++i) {
                String nextPropName = propOrder[i];
                if (nextPropName.equals("") || info.getPropertyNames().contains(nextPropName)) continue;
                throw JAXBException.nonExistentPropertyInPropOrder((String)nextPropName);
            }
        }
    }

    private void validateXmlValueFieldOrProperty(JavaClass cls, Property property) {
        JavaClass ptype = property.getActualType();
        String propName = property.getPropertyName();
        for (JavaClass parent = cls.getSuperclass(); parent != null && !parent.getQualifiedName().equals("java.lang.Object"); parent = parent.getSuperclass()) {
            TypeInfo parentTypeInfo = this.typeInfo.get(parent.getQualifiedName());
            if (parentTypeInfo == null && !this.shouldGenerateTypeInfo(parent)) continue;
            throw JAXBException.propertyOrFieldCannotBeXmlValue((String)propName);
        }
        QName schemaQName = this.getSchemaTypeOrNullFor(ptype);
        if (schemaQName == null) {
            TypeInfo refInfo = this.typeInfo.get(ptype.getQualifiedName());
            if (refInfo != null) {
                if (!refInfo.isPostBuilt()) {
                    this.postBuildTypeInfo(new JavaClass[]{ptype});
                }
            } else if (this.shouldGenerateTypeInfo(ptype)) {
                JavaClass[] jClasses = new JavaClass[]{ptype};
                this.buildNewTypeInfo(jClasses);
                refInfo = this.typeInfo.get(ptype.getQualifiedName());
            }
            if (refInfo != null && !refInfo.isEnumerationType() && refInfo.getXmlValueProperty() == null) {
                throw JAXBException.invalidTypeForXmlValueField((String)propName);
            }
        }
    }

    public boolean isMapType(JavaClass type) {
        return this.helper.getJavaClass(Map.class).isAssignableFrom(type);
    }

    private Class generateWrapperForMapClass(JavaClass mapClass, JavaClass keyClass, JavaClass valueClass, TypeMappingInfo typeMappingInfo) {
        Annotation[] annotations;
        NamespaceInfo namespaceInfo;
        String namespace;
        Vector namespaces;
        String packageName = "jaxb.dev.java.net";
        NamespaceResolver combinedNamespaceResolver = new NamespaceResolver();
        if (!this.helper.isBuiltInJavaType(keyClass)) {
            String keyPackageName = keyClass.getPackageName();
            packageName = packageName + "." + keyPackageName;
            NamespaceInfo keyNamespaceInfo = this.getNamespaceInfoForPackage(keyClass);
            if (keyNamespaceInfo != null) {
                namespaces = keyNamespaceInfo.getNamespaceResolver().getNamespaces();
                for (Namespace n : namespaces) {
                    combinedNamespaceResolver.put(n.getPrefix(), n.getNamespaceURI());
                }
            }
        }
        if (!this.helper.isBuiltInJavaType(valueClass)) {
            String valuePackageName = valueClass.getPackageName();
            packageName = packageName + "." + valuePackageName;
            NamespaceInfo valueNamespaceInfo = this.getNamespaceInfoForPackage(valueClass);
            if (valueNamespaceInfo != null) {
                namespaces = valueNamespaceInfo.getNamespaceResolver().getNamespaces();
                for (Namespace n : namespaces) {
                    combinedNamespaceResolver.put(n.getPrefix(), n.getNamespaceURI());
                }
            }
        }
        if ((namespace = this.defaultTargetNamespace) == null) {
            namespace = "";
        }
        if ((namespaceInfo = this.packageToNamespaceMappings.get(mapClass.getPackageName())) == null) {
            namespaceInfo = this.getPackageToNamespaceMappings().get(packageName);
        } else {
            if (namespaceInfo.getNamespace() != null) {
                namespace = namespaceInfo.getNamespace();
            }
            this.getPackageToNamespaceMappings().put(packageName, namespaceInfo);
        }
        if (namespaceInfo == null) {
            namespaceInfo = new NamespaceInfo();
            namespaceInfo.setNamespace(namespace);
            namespaceInfo.setNamespaceResolver(combinedNamespaceResolver);
            this.getPackageToNamespaceMappings().put(packageName, namespaceInfo);
        }
        int beginIndex = keyClass.getName().lastIndexOf(".") + 1;
        String keyName = keyClass.getName().substring(beginIndex);
        int dollarIndex = keyName.indexOf(36);
        if (dollarIndex > -1) {
            keyName = keyName.substring(dollarIndex + 1);
        }
        beginIndex = valueClass.getName().lastIndexOf(".") + 1;
        String valueName = valueClass.getName().substring(beginIndex);
        dollarIndex = valueName.indexOf(36);
        if (dollarIndex > -1) {
            valueName = valueName.substring(dollarIndex + 1);
        }
        String collectionClassShortName = mapClass.getRawName().substring(mapClass.getRawName().lastIndexOf(46) + 1);
        String suggestedClassName = keyName + valueName + collectionClassShortName;
        String qualifiedClassName = packageName + "." + suggestedClassName;
        qualifiedClassName = this.getNextAvailableClassName(qualifiedClassName);
        String qualifiedInternalClassName = qualifiedClassName.replace('.', '/');
        String internalKeyName = keyClass.getQualifiedName().replace('.', '/');
        String internalValueName = valueClass.getQualifiedName().replace('.', '/');
        org.eclipse.persistence.internal.libraries.asm.Type mapType = org.eclipse.persistence.internal.libraries.asm.Type.getType((String)("L" + mapClass.getRawName().replace('.', '/') + ";"));
        ClassWriter cw = new ClassWriter(false);
        cw.visit(49, 33, qualifiedInternalClassName, "org/eclipse/persistence/internal/jaxb/many/MapValue", null, "StringEmployeeMap.java");
        RuntimeVisibleAnnotations fieldAttrs1 = new RuntimeVisibleAnnotations();
        if (typeMappingInfo != null && (annotations = typeMappingInfo.getAnnotations()) != null) {
            for (int i = 0; i < annotations.length; ++i) {
                Annotation nextAnnotation = annotations[i];
                if (nextAnnotation == null || nextAnnotation instanceof javax.xml.bind.annotation.XmlElement || nextAnnotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter) continue;
                String annotationClassName = nextAnnotation.annotationType().getName();
                org.eclipse.persistence.internal.libraries.asm.attrs.Annotation fieldAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("L" + annotationClassName.replace('.', '/') + ";");
                fieldAttrs1.annotations.add(fieldAttrs1ann0);
                for (Method next : nextAnnotation.annotationType().getDeclaredMethods()) {
                    try {
                        Object nextValue = next.invoke((Object)nextAnnotation, new Object[0]);
                        if (nextValue instanceof Class) {
                            org.eclipse.persistence.internal.libraries.asm.Type nextType = org.eclipse.persistence.internal.libraries.asm.Type.getType((String)("L" + ((Class)nextValue).getName().replace('.', '/') + ";"));
                            nextValue = nextType;
                        }
                        fieldAttrs1ann0.add(next.getName(), nextValue);
                    }
                    catch (InvocationTargetException ex) {
                    }
                    catch (IllegalAccessException ex) {
                        // empty catch block
                    }
                }
            }
        }
        SignatureAttribute fieldAttrs2 = new SignatureAttribute("L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;");
        fieldAttrs1.next = fieldAttrs2;
        cw.visitField(1, "entry", "L" + mapType.getInternalName() + ";", null, (Attribute)fieldAttrs1);
        CodeVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/many/MapValue", "<init>", "()V");
        cv.visitInsn(177);
        cv.visitMaxs(1, 1);
        RuntimeVisibleAnnotations methodAttrs1 = new RuntimeVisibleAnnotations();
        org.eclipse.persistence.internal.libraries.asm.attrs.Annotation methodAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlTransient;");
        methodAttrs1.annotations.add(methodAttrs1ann0);
        SignatureAttribute methodAttrs2 = new SignatureAttribute("(L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;)V");
        methodAttrs1.next = methodAttrs2;
        cv = cw.visitMethod(1, "setItem", "(L" + mapType.getInternalName() + ";)V", null, (Attribute)methodAttrs1);
        Label l0 = new Label();
        cv.visitLabel(l0);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitFieldInsn(181, qualifiedInternalClassName, "entry", "L" + mapType.getInternalName() + ";");
        cv.visitInsn(177);
        Label l1 = new Label();
        cv.visitLabel(l1);
        LocalVariableTypeTableAttribute cvAttr = new LocalVariableTypeTableAttribute();
        cv.visitAttribute((Attribute)cvAttr);
        cv.visitMaxs(2, 2);
        methodAttrs1 = new RuntimeVisibleAnnotations();
        methodAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlTransient;");
        methodAttrs1.annotations.add(methodAttrs1ann0);
        methodAttrs2 = new SignatureAttribute("()L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;");
        methodAttrs1.next = methodAttrs2;
        cv = cw.visitMethod(1, "getItem", "()L" + mapType.getInternalName() + ";", null, (Attribute)methodAttrs1);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, qualifiedInternalClassName, "entry", "L" + mapType.getInternalName() + ";");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(4161, "getItem", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(182, qualifiedInternalClassName, "getItem", "()L" + mapType.getInternalName() + ";");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(4161, "setItem", "(Ljava/lang/Object;)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, mapType.getInternalName());
        cv.visitMethodInsn(182, qualifiedInternalClassName, "setItem", "(L" + mapType.getInternalName() + ";)V");
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        RuntimeVisibleAnnotations annotationsAttr = new RuntimeVisibleAnnotations();
        org.eclipse.persistence.internal.libraries.asm.attrs.Annotation attrann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlType;");
        attrann0.add("namespace", (Object)namespace);
        annotationsAttr.annotations.add(attrann0);
        cw.visitAttribute((Attribute)annotationsAttr);
        SignatureAttribute attr = new SignatureAttribute("Lorg/eclipse/persistence/internal/jaxb/many/MapValue<L" + mapType.getInternalName() + "<L" + internalKeyName + ";L" + internalValueName + ";>;>;");
        cw.visitAttribute((Attribute)attr);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        return this.generateClassFromBytes(qualifiedClassName, classBytes);
    }

    private Class generateWrapperForArrayClass(JavaClass arrayClass, TypeMappingInfo typeMappingInfo, Class xmlElementType) {
        JavaClass componentClass = null;
        componentClass = typeMappingInfo != null && xmlElementType != null ? this.helper.getJavaClass(xmlElementType) : arrayClass.getComponentType();
        if (componentClass.isPrimitive()) {
            return this.generatePrimitiveArrayValue(arrayClass, componentClass, typeMappingInfo);
        }
        return this.generateObjectArrayValue(arrayClass, componentClass, typeMappingInfo);
    }

    private Class generatePrimitiveArrayValue(JavaClass arrayClass, JavaClass componentClass, TypeMappingInfo typeMappingInfo) {
        Annotation[] annotations;
        String packageName = "jaxb.dev.java.net.array";
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForPackage(packageName);
        if (namespaceInfo == null) {
            namespaceInfo = new NamespaceInfo();
            namespaceInfo.setNamespace("http://jaxb.dev.java.net/array");
            namespaceInfo.setNamespaceResolver(new NamespaceResolver());
            this.getPackageToNamespaceMappings().put(packageName, namespaceInfo);
        }
        int beginIndex = componentClass.getName().lastIndexOf(".") + 1;
        String name = componentClass.getName().substring(beginIndex);
        String suggestedClassName = name + "Array";
        String qualifiedClassName = packageName + "." + suggestedClassName;
        qualifiedClassName = this.getNextAvailableClassName(qualifiedClassName);
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        String primitiveClassName = componentClass.getRawName();
        Class primitiveClass = this.getPrimitiveClass(primitiveClassName);
        componentClass = this.helper.getJavaClass(this.getObjectClass(primitiveClass));
        String qualifiedInternalClassName = qualifiedClassName.replace('.', '/');
        org.eclipse.persistence.internal.libraries.asm.Type componentType = org.eclipse.persistence.internal.libraries.asm.Type.getType((String)("L" + componentClass.getRawName().replace('.', '/') + ";"));
        ClassWriter cw = new ClassWriter(false);
        cw.visit(49, 33, qualifiedInternalClassName, "org/eclipse/persistence/internal/jaxb/many/PrimitiveArrayValue", null, className.replace(".", "/") + ".java");
        RuntimeVisibleAnnotations fieldAttrs1 = new RuntimeVisibleAnnotations();
        if (typeMappingInfo != null && (annotations = this.getAnnotations(typeMappingInfo)) != null) {
            for (int i = 0; i < annotations.length; ++i) {
                Annotation nextAnnotation = annotations[i];
                if (nextAnnotation == null || nextAnnotation instanceof javax.xml.bind.annotation.XmlElement || nextAnnotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter) continue;
                String annotationClassName = nextAnnotation.getClass().getName();
                org.eclipse.persistence.internal.libraries.asm.attrs.Annotation fieldAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("L" + annotationClassName + ";");
                fieldAttrs1.annotations.add(fieldAttrs1ann0);
                for (Method next : nextAnnotation.annotationType().getDeclaredMethods()) {
                    try {
                        Object nextValue = next.invoke((Object)nextAnnotation, new Object[0]);
                        if (nextValue instanceof Class) {
                            org.eclipse.persistence.internal.libraries.asm.Type nextType = org.eclipse.persistence.internal.libraries.asm.Type.getType((String)("L" + ((Class)nextValue).getName().replace('.', '/') + ";"));
                            nextValue = nextType;
                        }
                        fieldAttrs1ann0.add(next.getName(), nextValue);
                    }
                    catch (InvocationTargetException ex) {
                    }
                    catch (IllegalAccessException ex) {
                        // empty catch block
                    }
                }
            }
        }
        SignatureAttribute fieldAttrs2 = new SignatureAttribute("Ljava/util/Collection<L" + componentType.getInternalName() + ";>;");
        fieldAttrs1.next = fieldAttrs2;
        cw.visitField(1, "item", "Ljava/util/Collection;", null, (Attribute)fieldAttrs1);
        CodeVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/many/PrimitiveArrayValue", "<init>", "()V");
        cv.visitInsn(177);
        cv.visitMaxs(1, 1);
        RuntimeVisibleAnnotations methodAttrs1 = new RuntimeVisibleAnnotations();
        org.eclipse.persistence.internal.libraries.asm.attrs.Annotation methodAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlTransient;");
        methodAttrs1.annotations.add(methodAttrs1ann0);
        cv = cw.visitMethod(1, "getItem", "()Ljava/lang/Object;", null, (Attribute)methodAttrs1);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, qualifiedInternalClassName, "item", "Ljava/util/Collection;");
        cv.visitMethodInsn(185, "java/util/Collection", "iterator", "()Ljava/util/Iterator;");
        cv.visitVarInsn(58, 1);
        Label l0 = new Label();
        cv.visitLabel(l0);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, qualifiedInternalClassName, "item", "Ljava/util/Collection;");
        cv.visitMethodInsn(185, "java/util/Collection", "size", "()I");
        cv.visitIntInsn(188, this.getNewArrayConstantForPrimitive(primitiveClassName));
        cv.visitVarInsn(58, 2);
        cv.visitInsn(3);
        cv.visitVarInsn(54, 3);
        Label l1 = new Label();
        cv.visitJumpInsn(167, l1);
        Label l2 = new Label();
        cv.visitLabel(l2);
        cv.visitVarInsn(25, 2);
        cv.visitVarInsn(21, 3);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;");
        cv.visitTypeInsn(192, componentType.getInternalName());
        cv.visitMethodInsn(182, componentType.getInternalName(), this.getToPrimitiveStringForObjectClass(primitiveClassName), this.getReturnTypeFor(primitiveClass));
        int iaStoreOpcode = org.eclipse.persistence.internal.libraries.asm.Type.getType((Class)primitiveClass).getOpcode(79);
        cv.visitInsn(iaStoreOpcode);
        cv.visitIincInsn(3, 1);
        cv.visitLabel(l1);
        cv.visitVarInsn(21, 3);
        cv.visitVarInsn(25, 2);
        cv.visitInsn(190);
        cv.visitJumpInsn(161, l2);
        cv.visitVarInsn(25, 2);
        cv.visitInsn(176);
        Label l3 = new Label();
        cv.visitLabel(l3);
        LocalVariableTypeTableAttribute cvAttr = new LocalVariableTypeTableAttribute();
        cv.visitAttribute((Attribute)cvAttr);
        cv.visitMaxs(3, 4);
        methodAttrs1 = new RuntimeVisibleAnnotations();
        methodAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlTransient;");
        methodAttrs1.annotations.add(methodAttrs1ann0);
        cv = cw.visitMethod(1, "setItem", "(Ljava/lang/Object;)V", null, (Attribute)methodAttrs1);
        cv.visitTypeInsn(187, "java/util/ArrayList");
        cv.visitInsn(89);
        cv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
        cv.visitVarInsn(58, 2);
        l0 = new Label();
        cv.visitLabel(l0);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, this.getCastTypeFor(primitiveClass));
        cv.visitVarInsn(58, 3);
        cv.visitInsn(3);
        cv.visitVarInsn(54, 4);
        l1 = new Label();
        cv.visitJumpInsn(167, l1);
        l2 = new Label();
        cv.visitLabel(l2);
        cv.visitVarInsn(25, 3);
        cv.visitVarInsn(21, 4);
        int iaLoadOpcode = org.eclipse.persistence.internal.libraries.asm.Type.getType((Class)primitiveClass).getOpcode(46);
        cv.visitInsn(iaLoadOpcode);
        cv.visitVarInsn(54, 5);
        cv.visitVarInsn(25, 2);
        cv.visitTypeInsn(187, componentType.getInternalName());
        cv.visitInsn(89);
        cv.visitVarInsn(21, 5);
        cv.visitMethodInsn(183, componentType.getInternalName(), "<init>", "(" + this.getShortNameForPrimitive(primitiveClass) + ")V");
        cv.visitMethodInsn(182, "java/util/ArrayList", "add", "(Ljava/lang/Object;)Z");
        cv.visitInsn(87);
        cv.visitIincInsn(4, 1);
        cv.visitLabel(l1);
        cv.visitVarInsn(21, 4);
        cv.visitVarInsn(25, 3);
        cv.visitInsn(190);
        cv.visitJumpInsn(161, l2);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 2);
        cv.visitFieldInsn(181, qualifiedInternalClassName, "item", "Ljava/util/Collection;");
        cv.visitInsn(177);
        l3 = new Label();
        cv.visitLabel(l3);
        cv.visitAttribute((Attribute)cvAttr);
        cv.visitMaxs(4, 6);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        return this.generateClassFromBytes(qualifiedClassName, classBytes);
    }

    private Class generateObjectArrayValue(JavaClass arrayClass, JavaClass componentClass, TypeMappingInfo typeMappingInfo) {
        Annotation[] annotations;
        NamespaceInfo namespaceInfo;
        String packageName = componentClass.getPackageName();
        packageName = "jaxb.dev.java.net.array." + packageName;
        if (this.helper.isBuiltInJavaType(componentClass)) {
            namespaceInfo = this.getPackageToNamespaceMappings().get(packageName);
            if (namespaceInfo == null) {
                namespaceInfo = new NamespaceInfo();
                namespaceInfo.setNamespace("http://jaxb.dev.java.net/array");
                namespaceInfo.setNamespaceResolver(new NamespaceResolver());
                this.getPackageToNamespaceMappings().put(packageName, namespaceInfo);
            }
        } else {
            namespaceInfo = this.getNamespaceInfoForPackage(componentClass.getPackage());
            this.getPackageToNamespaceMappings().put(packageName, namespaceInfo);
        }
        String name = componentClass.getName();
        int dollarIndex = name.indexOf(36);
        if (dollarIndex > -1) {
            name = name.substring(dollarIndex + 1);
        }
        int beginIndex = name.lastIndexOf(".") + 1;
        String suggestedClassName = name.substring(beginIndex) + "Array";
        String qualifiedClassName = packageName + "." + suggestedClassName;
        qualifiedClassName = this.getNextAvailableClassName(qualifiedClassName);
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        String qualifiedInternalClassName = qualifiedClassName.replace('.', '/');
        org.eclipse.persistence.internal.libraries.asm.Type componentType = org.eclipse.persistence.internal.libraries.asm.Type.getType((String)("L" + componentClass.getQualifiedName().replace('.', '/') + ";"));
        ClassWriter cw = new ClassWriter(false);
        cw.visit(49, 33, qualifiedInternalClassName, "org/eclipse/persistence/internal/jaxb/many/ObjectArrayValue", null, className.replace('.', '/') + ".java");
        RuntimeVisibleAnnotations fieldAttrs1 = new RuntimeVisibleAnnotations();
        if (typeMappingInfo != null && (annotations = this.getAnnotations(typeMappingInfo)) != null) {
            for (int i = 0; i < annotations.length; ++i) {
                Annotation nextAnnotation = annotations[i];
                if (nextAnnotation == null || nextAnnotation instanceof javax.xml.bind.annotation.XmlElement || nextAnnotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter) continue;
                String annotationClassName = nextAnnotation.getClass().getName();
                org.eclipse.persistence.internal.libraries.asm.attrs.Annotation fieldAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("L" + annotationClassName + ";");
                fieldAttrs1.annotations.add(fieldAttrs1ann0);
                for (Method next : nextAnnotation.annotationType().getDeclaredMethods()) {
                    try {
                        Object nextValue = next.invoke((Object)nextAnnotation, new Object[0]);
                        if (nextValue instanceof Class) {
                            org.eclipse.persistence.internal.libraries.asm.Type nextType = org.eclipse.persistence.internal.libraries.asm.Type.getType((String)("L" + ((Class)nextValue).getName().replace('.', '/') + ";"));
                            nextValue = nextType;
                        }
                        fieldAttrs1ann0.add(next.getName(), nextValue);
                    }
                    catch (InvocationTargetException ex) {
                    }
                    catch (IllegalAccessException ex) {
                        // empty catch block
                    }
                }
            }
        }
        SignatureAttribute fieldAttrs2 = new SignatureAttribute("Ljava/util/Collection<L" + componentType.getInternalName() + ";>;");
        fieldAttrs1.next = fieldAttrs2;
        cw.visitField(1, "item", "Ljava/util/Collection;", null, (Attribute)fieldAttrs1);
        CodeVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/many/ObjectArrayValue", "<init>", "()V");
        cv.visitInsn(177);
        cv.visitMaxs(1, 1);
        RuntimeVisibleAnnotations methodAttrs1 = new RuntimeVisibleAnnotations();
        org.eclipse.persistence.internal.libraries.asm.attrs.Annotation methodAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlTransient;");
        methodAttrs1.annotations.add(methodAttrs1ann0);
        cv = cw.visitMethod(1, "getItem", "()[Ljava/lang/Object;", null, (Attribute)methodAttrs1);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, qualifiedInternalClassName, "item", "Ljava/util/Collection;");
        cv.visitMethodInsn(182, qualifiedInternalClassName, "convertCollectionToArray", "(Ljava/util/Collection;)[Ljava/lang/Object;");
        cv.visitInsn(176);
        cv.visitMaxs(2, 1);
        methodAttrs1 = new RuntimeVisibleAnnotations();
        methodAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlTransient;");
        methodAttrs1.annotations.add(methodAttrs1ann0);
        cv = cw.visitMethod(1, "setItem", "([Ljava/lang/Object;)V", null, (Attribute)methodAttrs1);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(182, qualifiedInternalClassName, "convertArrayToList", "([Ljava/lang/Object;)Ljava/util/List;");
        cv.visitFieldInsn(181, qualifiedInternalClassName, "item", "Ljava/util/Collection;");
        cv.visitInsn(177);
        cv.visitMaxs(3, 2);
        methodAttrs1 = new RuntimeVisibleAnnotations();
        methodAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlTransient;");
        methodAttrs1.annotations.add(methodAttrs1ann0);
        cv = cw.visitMethod(1, "getComponentClass", "()Ljava/lang/Class;", null, (Attribute)methodAttrs1);
        cv.visitLdcInsn((Object)componentType);
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(4161, "getItem", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(182, qualifiedInternalClassName, "getItem", "()[Ljava/lang/Object;");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(4161, "setItem", "(Ljava/lang/Object;)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, "[Ljava/lang/Object;");
        cv.visitMethodInsn(182, qualifiedInternalClassName, "setItem", "([Ljava/lang/Object;)V");
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        SignatureAttribute attr = new SignatureAttribute("Lorg/eclipse/persistence/internal/jaxb/many/ObjectArrayValue<[Ljava/lang/Object;>;");
        cw.visitAttribute((Attribute)attr);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        return this.generateClassFromBytes(qualifiedClassName, classBytes);
    }

    private Class generateCollectionValue(JavaClass collectionClass, TypeMappingInfo typeMappingInfo, Class xmlElementType) {
        Annotation[] annotations;
        JavaClass componentClass = typeMappingInfo != null && xmlElementType != null ? this.helper.getJavaClass(xmlElementType) : (collectionClass.hasActualTypeArguments() ? (JavaClass)collectionClass.getActualTypeArguments().toArray()[0] : this.helper.getJavaClass(Object.class));
        if (componentClass.isPrimitive()) {
            Class primitiveClass = this.getPrimitiveClass(componentClass.getRawName());
            componentClass = this.helper.getJavaClass(this.getObjectClass(primitiveClass));
        }
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(collectionClass.getPackageName());
        String namespace = "";
        if (this.defaultTargetNamespace != null) {
            namespace = this.defaultTargetNamespace;
        }
        NamespaceInfo componentNamespaceInfo = this.getNamespaceInfoForPackage(componentClass);
        String packageName = componentClass.getPackageName();
        packageName = "jaxb.dev.java.net." + packageName;
        if (namespaceInfo == null) {
            namespaceInfo = this.getPackageToNamespaceMappings().get(packageName);
        } else {
            this.getPackageToNamespaceMappings().put(packageName, namespaceInfo);
            if (namespaceInfo.getNamespace() != null) {
                namespace = namespaceInfo.getNamespace();
            }
        }
        if (namespaceInfo == null) {
            if (componentNamespaceInfo != null) {
                namespaceInfo = componentNamespaceInfo;
            } else {
                namespaceInfo = new NamespaceInfo();
                namespaceInfo.setNamespaceResolver(new NamespaceResolver());
            }
            this.getPackageToNamespaceMappings().put(packageName, namespaceInfo);
        }
        String name = componentClass.getName();
        org.eclipse.persistence.internal.libraries.asm.Type componentType = org.eclipse.persistence.internal.libraries.asm.Type.getType((String)("L" + componentClass.getName().replace('.', '/') + ";"));
        String componentTypeInternalName = null;
        if (name.equals("[B")) {
            name = "byteArray";
            componentTypeInternalName = componentType.getInternalName();
        } else if (name.equals("[Ljava.lang.Byte;")) {
            name = "ByteArray";
            componentTypeInternalName = componentType.getInternalName() + ";";
        } else {
            componentTypeInternalName = "L" + componentType.getInternalName() + ";";
        }
        int beginIndex = name.lastIndexOf(46) + 1;
        name = name.substring(beginIndex);
        int dollarIndex = name.indexOf(36);
        if (dollarIndex > -1) {
            name = name.substring(dollarIndex + 1);
        }
        String collectionClassRawName = collectionClass.getRawName();
        String collectionClassShortName = collectionClassRawName.substring(collectionClassRawName.lastIndexOf(46) + 1);
        String suggestedClassName = collectionClassShortName + "Of" + name;
        String qualifiedClassName = packageName + "." + suggestedClassName;
        qualifiedClassName = this.getNextAvailableClassName(qualifiedClassName);
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        org.eclipse.persistence.internal.libraries.asm.Type collectionType = org.eclipse.persistence.internal.libraries.asm.Type.getType((String)("L" + collectionClassRawName.replace('.', '/') + ";"));
        String qualifiedInternalClassName = qualifiedClassName.replace('.', '/');
        ClassWriter cw = new ClassWriter(false);
        cw.visit(49, 33, qualifiedInternalClassName, "org/eclipse/persistence/internal/jaxb/many/CollectionValue", null, className.replace('.', '/') + ".java");
        RuntimeVisibleAnnotations fieldAttrs1 = new RuntimeVisibleAnnotations();
        if (typeMappingInfo != null && (annotations = this.getAnnotations(typeMappingInfo)) != null) {
            for (int i = 0; i < annotations.length; ++i) {
                Annotation nextAnnotation = annotations[i];
                if (nextAnnotation == null || nextAnnotation instanceof javax.xml.bind.annotation.XmlElement || nextAnnotation instanceof javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter) continue;
                String annotationClassName = nextAnnotation.annotationType().getName();
                org.eclipse.persistence.internal.libraries.asm.attrs.Annotation fieldAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("L" + annotationClassName.replace('.', '/') + ";");
                fieldAttrs1.annotations.add(fieldAttrs1ann0);
                for (Method next : nextAnnotation.annotationType().getDeclaredMethods()) {
                    try {
                        Object nextValue = next.invoke((Object)nextAnnotation, new Object[0]);
                        if (nextValue instanceof Class) {
                            org.eclipse.persistence.internal.libraries.asm.Type nextType = org.eclipse.persistence.internal.libraries.asm.Type.getType((String)("L" + ((Class)nextValue).getName().replace('.', '/') + ";"));
                            nextValue = nextType;
                        }
                        fieldAttrs1ann0.add(next.getName(), nextValue);
                    }
                    catch (InvocationTargetException ex) {
                    }
                    catch (IllegalAccessException ex) {
                        // empty catch block
                    }
                }
            }
        }
        SignatureAttribute fieldAttrs2 = new SignatureAttribute("L" + collectionType.getInternalName() + "<" + componentTypeInternalName + ">;");
        fieldAttrs1.next = fieldAttrs2;
        cw.visitField(1, "item", "L" + collectionType.getInternalName() + ";", null, (Attribute)fieldAttrs1);
        CodeVisitor cv = cw.visitMethod(1, "<init>", "()V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/many/CollectionValue", "<init>", "()V");
        cv.visitInsn(177);
        cv.visitMaxs(1, 1);
        RuntimeVisibleAnnotations methodAttrs1 = new RuntimeVisibleAnnotations();
        org.eclipse.persistence.internal.libraries.asm.attrs.Annotation methodAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlTransient;");
        methodAttrs1.annotations.add(methodAttrs1ann0);
        SignatureAttribute methodAttrs2 = new SignatureAttribute("(L" + collectionType.getInternalName() + "<" + componentTypeInternalName + ">;)V");
        methodAttrs1.next = methodAttrs2;
        cv = cw.visitMethod(1, "setItem", "(L" + collectionType.getInternalName() + ";)V", null, (Attribute)methodAttrs1);
        Label l0 = new Label();
        cv.visitLabel(l0);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitFieldInsn(181, qualifiedInternalClassName, "item", "L" + collectionType.getInternalName() + ";");
        cv.visitInsn(177);
        Label l1 = new Label();
        cv.visitLabel(l1);
        LocalVariableTypeTableAttribute cvAttr = new LocalVariableTypeTableAttribute();
        cv.visitAttribute((Attribute)cvAttr);
        cv.visitMaxs(2, 2);
        methodAttrs1 = new RuntimeVisibleAnnotations();
        methodAttrs1ann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlTransient;");
        methodAttrs1.annotations.add(methodAttrs1ann0);
        methodAttrs2 = new SignatureAttribute("()L" + collectionType.getInternalName() + "<" + componentTypeInternalName + ">;");
        methodAttrs1.next = methodAttrs2;
        cv = cw.visitMethod(1, "getItem", "()L" + collectionType.getInternalName() + ";", null, (Attribute)methodAttrs1);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, qualifiedInternalClassName, "item", "L" + collectionType.getInternalName() + ";");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(4161, "getItem", "()Ljava/lang/Object;", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(182, qualifiedInternalClassName, "getItem", "()L" + collectionType.getInternalName() + ";");
        cv.visitInsn(176);
        cv.visitMaxs(1, 1);
        cv = cw.visitMethod(4161, "setItem", "(Ljava/lang/Object;)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, "" + collectionType.getInternalName() + "");
        cv.visitMethodInsn(182, qualifiedInternalClassName, "setItem", "(L" + collectionType.getInternalName() + ";)V");
        cv.visitInsn(177);
        cv.visitMaxs(2, 2);
        RuntimeVisibleAnnotations annotationsAttr = new RuntimeVisibleAnnotations();
        org.eclipse.persistence.internal.libraries.asm.attrs.Annotation attrann0 = new org.eclipse.persistence.internal.libraries.asm.attrs.Annotation("Ljavax/xml/bind/annotation/XmlType;");
        attrann0.add("namespace", (Object)namespace);
        annotationsAttr.annotations.add(attrann0);
        cw.visitAttribute((Attribute)annotationsAttr);
        SignatureAttribute attr = new SignatureAttribute("Lorg/eclipse/persistence/internal/jaxb/many/CollectionValue<L" + collectionType.getInternalName() + "<" + componentTypeInternalName + ">;>;");
        cw.visitAttribute((Attribute)attr);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        return this.generateClassFromBytes(qualifiedClassName, classBytes);
    }

    private Class generateClassFromBytes(String className, byte[] classBytes) {
        JaxbClassLoader loader = (JaxbClassLoader)this.helper.getClassLoader();
        Class generatedClass = loader.generateClass(className, classBytes);
        return generatedClass;
    }

    private String getCastTypeFor(Class primitiveClass) {
        return "[" + this.getShortNameForPrimitive(primitiveClass);
    }

    private String getReturnTypeFor(Class primitiveClass) {
        return "()" + this.getShortNameForPrimitive(primitiveClass);
    }

    private int getNewArrayConstantForPrimitive(String primitiveClassName) {
        if (primitiveClassName == null) {
            return 0;
        }
        if ("char".equals(primitiveClassName)) {
            return 5;
        }
        if ("int".equals(primitiveClassName)) {
            return 10;
        }
        if ("double".equals(primitiveClassName)) {
            return 7;
        }
        if ("float".equals(primitiveClassName)) {
            return 6;
        }
        if ("long".equals(primitiveClassName)) {
            return 11;
        }
        if ("short".equals(primitiveClassName)) {
            return 9;
        }
        if ("byte".equals(primitiveClassName)) {
            return 8;
        }
        if ("boolean".equals(primitiveClassName)) {
            return 4;
        }
        return 0;
    }

    private String getNextAvailableClassName(String suggestedName) {
        int counter = 1;
        return this.getNextAvailableClassName(suggestedName, suggestedName, counter);
    }

    private String getNextAvailableClassName(String suggestedBaseName, String suggestedName, int counter) {
        for (Class nextClass : this.typeMappingInfoToGeneratedClasses.values()) {
            if (!nextClass.getName().equals(suggestedName)) continue;
            return this.getNextAvailableClassName(suggestedBaseName, suggestedBaseName + ++counter, counter);
        }
        return suggestedName;
    }

    private String getShortNameForPrimitive(Class primitiveClass) {
        org.eclipse.persistence.internal.libraries.asm.Type thePrimitiveType = org.eclipse.persistence.internal.libraries.asm.Type.getType((Class)primitiveClass);
        return thePrimitiveType.toString();
    }

    private String getToPrimitiveStringForObjectClass(String javaClassName) {
        if (javaClassName == null) {
            return null;
        }
        if ("char".equals(javaClassName)) {
            return "charValue";
        }
        if ("int".equals(javaClassName)) {
            return "intValue";
        }
        if ("double".equals(javaClassName)) {
            return "doubleValue";
        }
        if ("float".equals(javaClassName)) {
            return "floatValue";
        }
        if ("long".equals(javaClassName)) {
            return "longValue";
        }
        if ("short".equals(javaClassName)) {
            return "shortValue";
        }
        if ("byte".equals(javaClassName)) {
            return "byteValue";
        }
        if ("boolean".equals(javaClassName)) {
            return "booleanValue";
        }
        return null;
    }

    private Class getPrimitiveClass(String primitiveClassName) {
        return ConversionManager.getDefaultManager().convertClassNameToClass(primitiveClassName);
    }

    private Class getObjectClass(Class primitiveClass) {
        ConversionManager.getDefaultManager();
        return ConversionManager.getObjectClass((Class)primitiveClass);
    }

    public Map<Type, Class> getCollectionClassesToGeneratedClasses() {
        return this.collectionClassesToGeneratedClasses;
    }

    public Map<String, Class> getArrayClassesToGeneratedClasses() {
        return this.arrayClassesToGeneratedClasses;
    }

    public Map<Class, Type> getGeneratedClassesToCollectionClasses() {
        return this.generatedClassesToCollectionClasses;
    }

    public Map<Class, JavaClass> getGeneratedClassesToArrayClasses() {
        return this.generatedClassesToArrayClasses;
    }

    public Map<String, TypeInfo> getTypeInfosForPackage(String packageName) {
        HashMap<String, TypeInfo> typeInfos = new HashMap<String, TypeInfo>();
        ArrayList<JavaClass> jClasses = this.getTypeInfoClasses();
        for (JavaClass jClass : jClasses) {
            if (!jClass.getPackageName().equals(packageName)) continue;
            String key = jClass.getQualifiedName();
            typeInfos.put(key, this.typeInfo.get(key));
        }
        return typeInfos;
    }

    public void setPackageToNamespaceMappings(HashMap<String, NamespaceInfo> packageToNamespaceMappings) {
        this.packageToNamespaceMappings = packageToNamespaceMappings;
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
            return null;
        }
        if (this.typeInfo == null) {
            this.typeInfoClasses = new ArrayList();
            this.typeInfo = new HashMap();
            this.typeQNames = new ArrayList();
            this.userDefinedSchemaTypes = new HashMap();
            this.packageToNamespaceMappings = new HashMap();
            this.namespaceResolver = new NamespaceResolver();
        }
        JavaClass[] jClasses = new JavaClass[]{javaClass};
        this.buildNewTypeInfo(jClasses);
        TypeInfo info = this.typeInfo.get(javaClass.getQualifiedName());
        String packageName = javaClass.getPackageName();
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(packageName);
        SchemaTypeInfo schemaInfo = new SchemaTypeInfo();
        schemaInfo.setSchemaTypeName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        if (info.isSetXmlRootElement()) {
            int idx;
            char ch;
            org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement xmlRE = info.getXmlRootElement();
            String elementName = xmlRE.getName();
            if ((elementName.equals("##default") || elementName.equals("")) && (elementName = javaClass.getName().indexOf("$") != -1 ? Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(36) + 1)) : Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(46) + 1))).length() >= 3 && Character.isDigit(ch = elementName.charAt((idx = elementName.length() - 1) - 1))) {
                char lastCh = Character.toUpperCase(elementName.charAt(idx));
                elementName = elementName.substring(0, idx) + lastCh;
            }
            String rootNamespace = xmlRE.getNamespace();
            QName rootElemName = null;
            rootElemName = rootNamespace.equals("##default") ? new QName(namespaceInfo.getNamespace(), elementName) : new QName(rootNamespace, elementName);
            schemaInfo.getGlobalElementDeclarations().add(rootElemName);
            ElementDeclaration declaration = new ElementDeclaration(rootElemName, javaClass, javaClass.getRawName(), false);
            this.getGlobalElements().put(rootElemName, declaration);
        }
        return schemaInfo;
    }

    public void buildNewTypeInfo(JavaClass[] javaClasses) {
        this.preBuildTypeInfo(javaClasses);
        this.postBuildTypeInfo(javaClasses);
    }

    private void preProcessCustomizer(JavaClass jClass, TypeInfo tInfo) {
        XmlCustomizer xmlCustomizer = (XmlCustomizer)this.helper.getAnnotation(jClass, XmlCustomizer.class);
        if (xmlCustomizer != null) {
            tInfo.setXmlCustomizer(xmlCustomizer.value().getName());
        }
    }

    private JAXBMetadataLogger getLogger() {
        if (this.logger == null) {
            this.logger = new JAXBMetadataLogger();
        }
        return this.logger;
    }

    Helper getHelper() {
        return this.helper;
    }

    public boolean isDefaultNamespaceAllowed() {
        return this.isDefaultNamespaceAllowed;
    }

    public List<ElementDeclaration> getLocalElements() {
        return this.localElements;
    }

    public Map<TypeMappingInfo, Class> getTypeMappingInfoToGeneratedClasses() {
        return this.typeMappingInfoToGeneratedClasses;
    }

    public Map<TypeMappingInfo, Class> getTypeMappingInfoToAdapterClasses() {
        return this.typeMappingInfoToAdapterClasses;
    }

    public void addXmlRegistry(String factoryClassName, org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry xmlReg) {
        this.xmlRegistries.put(factoryClassName, xmlReg);
    }

    private boolean isXmlRegistry(JavaClass javaClass) {
        return this.helper.isAnnotationPresent(javaClass, XmlRegistry.class) || this.xmlRegistries.get(javaClass.getQualifiedName()) != null;
    }

    public Map<TypeMappingInfo, QName> getTypeMappingInfoToSchemaType() {
        return this.typeMappingInfoToSchemaType;
    }

    String getDefaultTargetNamespace() {
        return this.defaultTargetNamespace;
    }

    void setDefaultTargetNamespace(String defaultTargetNamespace) {
        this.defaultTargetNamespace = defaultTargetNamespace;
    }

    public void setDefaultNamespaceAllowed(boolean isDefaultNamespaceAllowed) {
        this.isDefaultNamespaceAllowed = isDefaultNamespaceAllowed;
    }

    HashMap<QName, ElementDeclaration> getElementDeclarationsForScope(String scopeClassName) {
        return this.elementDeclarations.get(scopeClassName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyComparitor
    implements Comparator<Property> {
        PropertyComparitor() {
        }

        @Override
        public int compare(Property p1, Property p2) {
            return p1.getPropertyName().compareTo(p2.getPropertyName());
        }
    }
}

