/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.util.smx;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.runtime.impl.MessageExchangeImpl;
import org.apache.servicemix.jbi.runtime.impl.NormalizedMessageImpl;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalReference;
import org.apache.servicemix.nmr.core.MessageImpl;
import org.eclipse.swordfish.core.resolver.EndpointDescription;
import org.eclipse.swordfish.internal.core.util.xml.StringSource;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMixSupport {
    private static final Log LOG = LogFactory.getLog(ServiceMixSupport.class);

    public static Exchange toNMRExchange(MessageExchange messageExchange) {
        Assert.notNull((Object)messageExchange);
        Assert.isTrue((boolean)(messageExchange instanceof MessageExchangeImpl));
        return ((MessageExchangeImpl)messageExchange).getInternalExchange();
    }

    public static void setStringMessage(MessageExchange source, String messageType, String content) {
        try {
            if (source.getMessage(messageType) != null) {
                source.getMessage(messageType).setContent((Source)new StringSource(content));
            } else {
                MessageImpl responseMessage = new MessageImpl();
                responseMessage.setBody((Object)new StringSource(content), Source.class);
                NormalizedMessageImpl responseNormalizedMessage = new NormalizedMessageImpl((Message)responseMessage);
                source.setMessage((NormalizedMessage)responseNormalizedMessage, messageType);
            }
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setSourceService(ComponentContext componentContext, MessageExchange messageExchange, QName sourceService) {
        Assert.notNull((Object)componentContext);
        Assert.notNull((Object)messageExchange);
        Assert.notNull((Object)sourceService);
        Object[] serviceEndpoints = componentContext.getEndpointsForService(sourceService);
        Assert.notEmpty((Object[])serviceEndpoints);
        messageExchange.setProperty("org.apache.servicemix.senderEndpoint", (Object)(serviceEndpoints[0].getServiceName() + ":" + serviceEndpoints[0].getEndpointName()));
    }

    public static DocumentFragment getEndpointReference(EndpointDescription description) {
        try {
            Assert.notNull((Object)description);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document doc = factory.newDocumentBuilder().newDocument();
            Element endpRef = doc.createElementNS("http://www.w3.org/2005/08/addressing", "EndpointReference");
            endpRef.setPrefix("wsa");
            Element address = doc.createElementNS("http://www.w3.org/2005/08/addressing", "Address");
            address.setPrefix("wsa");
            address.appendChild(doc.createTextNode(description.getAddress()));
            endpRef.appendChild(address);
            QName serviceName = description.getServiceName();
            Element metadata = doc.createElementNS("http://www.w3.org/2005/08/addressing", "Metadata");
            metadata.setPrefix("wsa");
            Element service = doc.createElementNS("http://www.w3.org/2005/08/addressing", "ServiceName");
            service.setAttribute("EndpointName", description.getName());
            service.setPrefix("wsaw");
            service.appendChild(doc.createTextNode(String.valueOf(serviceName.getNamespaceURI()) + "/" + serviceName.getLocalPart()));
            metadata.appendChild(service);
            endpRef.appendChild(metadata);
            doc.appendChild(endpRef);
            DocumentFragment frag = doc.createDocumentFragment();
            frag.appendChild(doc.getDocumentElement());
            return frag;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected failure of enpoint reference creation", e);
        }
    }

    public static InternalEndpoint getEndpoint(NMR nmr, Reference reference) {
        Iterator endpointsIterator = ((InternalReference)reference).choose(nmr.getEndpointRegistry()).iterator();
        if (!endpointsIterator.hasNext()) {
            return null;
        }
        return (InternalEndpoint)endpointsIterator.next();
    }

    public static InternalEndpoint getEndpoint(NMR nmr, Map<String, ?> props) {
        InternalReference reference = (InternalReference)nmr.getEndpointRegistry().lookup(props);
        Iterator endpointsIterator = reference.choose(nmr.getEndpointRegistry()).iterator();
        if (!endpointsIterator.hasNext()) {
            return null;
        }
        return (InternalEndpoint)endpointsIterator.next();
    }

    public static InputStream convertStringToIS(String xml, String encoding) {
        if (xml == null) {
            return null;
        }
        xml = xml.trim();
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(xml.getBytes(encoding));
        }
        catch (Exception exception) {}
        return in;
    }
}

