/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.backward;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.eclipse.sequoyah.device.backward.Messages;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.framework.DevicePlugin;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.manager.persistence.DeviceXmlReader;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DeviceBackwardPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = Messages.DeviceBackwardPlugin_0;
    private static DeviceBackwardPlugin plugin;
    private final String PROJECT_NAME = "sequoyah";
    private final String OLD_PROJECT_NAME = "tml";
    private final String DEVICE_XML_INFO_SUFFIX = ".info";
    private final String BACKWARD_MARK = "backward";
    private final String OLD_DEVICE_PLUGIN_ID = "org.eclipse.tml.framework.device";
    File deviceXmlLocation = DevicePlugin.getDeviceXmlLocation();
    File deviceXmlFile = new File(String.valueOf(this.deviceXmlLocation.getAbsolutePath()) + File.separator + DevicePlugin.getDeviceXmlFileName());
    File oldDeviceXmlFile = null;
    File oldDeviceXmlFileInfo = null;

    public DeviceBackwardPlugin() {
        String string = this.deviceXmlFile.getAbsolutePath().replaceAll("org.eclipse.sequoyah.device.framework", "org.eclipse.tml.framework.device").replaceAll("sequoyah", "tml");
        this.oldDeviceXmlFile = new File(string);
        this.oldDeviceXmlFileInfo = new File(String.valueOf(string) + ".info");
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        if (!this.getBackwardStatus()) {
            this.moveDeviceInstancesData();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static DeviceBackwardPlugin getDefault() {
        return plugin;
    }

    private boolean getBackwardStatus() {
        boolean bl = false;
        try {
            if (this.oldDeviceXmlFileInfo.exists()) {
                String string;
                FileReader fileReader = new FileReader(this.oldDeviceXmlFileInfo);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("backward")) continue;
                    bl = true;
                }
                fileReader.close();
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            BasePlugin.logError((String)Messages.DeviceBackwardPlugin_1);
        }
        return bl;
    }

    private void addBackwardStatus() {
        try {
            FileWriter fileWriter = new FileWriter(this.oldDeviceXmlFileInfo);
            fileWriter.write("backward=" + new Date().toString());
            fileWriter.close();
        }
        catch (IOException iOException) {
            BasePlugin.logError((String)Messages.DeviceBackwardPlugin_3);
        }
    }

    private void moveDeviceInstancesData() {
        if (this.oldDeviceXmlFile.exists()) {
            try {
                Collection collection = DeviceXmlReader.loadInstances((File)this.oldDeviceXmlFile);
                InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
                for (IInstance iInstance : collection) {
                    if (instanceRegistry.getInstancesByName(iInstance.getName()).size() != 0) continue;
                    instanceRegistry.addInstance(iInstance);
                }
                this.addBackwardStatus();
            }
            catch (Exception exception) {
                BasePlugin.logError((String)Messages.DeviceBackwardPlugin_4);
            }
        }
    }

    public void earlyStartup() {
    }
}

