/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.jdt;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jetty.osgi.boot.jdt.internal.NaiveJavaProjectToWebappContextDeployer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class JDTWebappDeploymentActivator
implements BundleActivator {
    private static JDTWebappDeploymentActivator _instance;

    public void start(BundleContext context) throws Exception {
        _instance = this;
        JDTWebappDeploymentActivator.deployWebappsEmbeddedInJDTProjects();
    }

    public void stop(BundleContext context) throws Exception {
        _instance = null;
    }

    public static BundleActivator getDefault() {
        return _instance;
    }

    private static void deployWebappsEmbeddedInJDTProjects() {
        String javaProjectsToDeploy = System.getProperty("jetty.jdtwebapps");
        if (javaProjectsToDeploy == null) {
            return;
        }
        System.err.println("  jetty.jdtwebapps=" + javaProjectsToDeploy + "\n  osgi.instance.area=" + System.getProperty("osgi.instance.area"));
        if (javaProjectsToDeploy.startsWith("\"") && javaProjectsToDeploy.endsWith("\"") || javaProjectsToDeploy.startsWith("'") && javaProjectsToDeploy.endsWith("'")) {
            javaProjectsToDeploy = javaProjectsToDeploy.substring(1, javaProjectsToDeploy.length() - 1);
        }
        HashSet<String> projectsToDeployAsWebapps = new HashSet<String>();
        String[] stringArray = javaProjectsToDeploy.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            projectsToDeployAsWebapps.add(p);
            ++n2;
        }
        try {
            IJavaProject[] javaProjects;
            IJavaProject[] iJavaProjectArray = javaProjects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            int n3 = javaProjects.length;
            n = 0;
            while (n < n3) {
                IJavaProject proj = iJavaProjectArray[n];
                IProject p = proj.getProject();
                if (projectsToDeployAsWebapps.contains(p.getName())) {
                    System.err.println(p.getName());
                    if (p.getDescription().hasNature("org.eclipse.pde.PluginNature")) {
                        System.err.println("Can't deploy " + p.getName() + " as a java project: it is an OSGi bundle.");
                    } else {
                        NaiveJavaProjectToWebappContextDeployer deployer = new NaiveJavaProjectToWebappContextDeployer(proj);
                        if (deployer.containsWebapp()) {
                            deployer.deploy();
                        } else {
                            System.err.println("WARNING: unable to locate a webapp inside the java project " + p.getName());
                        }
                    }
                }
                ++n;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

