/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.jdt.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.jdt.JDTWebappDeploymentActivator;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaiveJavaProjectToWebappContextDeployer {
    private final IJavaProject _project;
    private List<String> _jettyFileContextHandlers;
    private String _extraClasspath;
    private String _warFolder;
    private String _webappContext;

    public NaiveJavaProjectToWebappContextDeployer(IJavaProject project) {
        this._project = project;
        this.compute();
    }

    public String getContextPath() {
        return this._webappContext;
    }

    public String getWebappBaseFolderPath() {
        return this._warFolder;
    }

    public boolean containsWebapp() {
        return this._jettyFileContextHandlers != null || this._warFolder != null;
    }

    public void deploy() {
        IProject proj = this._project.getProject();
        String baseLocation = null;
        if (proj.getLocation() == null) {
            IPath p = proj.getFullPath();
            String workspace = System.getProperty("osgi.instance.area");
            File workspaceFile = new File(LocationManager.getInstanceLocation().getURL().getPath());
            if (!workspaceFile.exists()) {
                throw new IllegalStateException("Unable to resolve the location of the workspace. ${system:osgi.instance.area}=" + workspace + " file: " + workspaceFile + " does not exist.");
            }
            baseLocation = new File(workspaceFile, p.makeRelative().toString()).getAbsolutePath();
        } else {
            baseLocation = this._project.getProject().getLocation().toString();
        }
        Bundle thisBundle = FrameworkUtil.getBundle(JDTWebappDeploymentActivator.class);
        if (this._jettyFileContextHandlers != null) {
            for (String jettyContextFile : this._jettyFileContextHandlers) {
                try {
                    Hashtable<String, String> dic = new Hashtable<String, String>();
                    ((Dictionary)dic).put("thisBundleInstall", baseLocation);
                    ((Dictionary)dic).put("extraClasspath", this._extraClasspath);
                    ((Dictionary)dic).put("Java-Project", this._project.getProject().getName());
                    JettyBootstrapActivator.registerContext((Bundle)thisBundle, (String)jettyContextFile, dic);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        if (this._warFolder != null) {
            try {
                Hashtable<String, String> dic = new Hashtable<String, String>();
                ((Dictionary)dic).put("thisBundleInstall", baseLocation);
                ((Dictionary)dic).put("extraClasspath", this._extraClasspath);
                ((Dictionary)dic).put("Java-Project", this._project.getProject().getName());
                JettyBootstrapActivator.registerWebapplication((Bundle)thisBundle, (String)this._warFolder, (String)this._webappContext, dic);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected void compute() {
        IFile webxml;
        String contextFiles;
        try {
            this._project.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IFile manifest = this._project.getProject().getFile("META-INF/MANIFEST.MF");
        manifest.exists();
        Map<String, String> headers = this.parseManifest(manifest);
        String string = contextFiles = headers == null ? null : headers.get("Jetty-ContextFilePath");
        if (contextFiles != null) {
            String[] ctxts;
            this._jettyFileContextHandlers = new ArrayList<String>();
            String[] stringArray = ctxts = contextFiles.split(",;");
            int n = ctxts.length;
            int n2 = 0;
            while (n2 < n) {
                String jettyContextFile = stringArray[n2];
                this._jettyFileContextHandlers.add(jettyContextFile);
                ++n2;
            }
        }
        String webappContext = headers == null ? null : headers.get("Web-ContextPath");
        String warFolderPath = headers == null ? null : headers.get("Jetty-WarFolderPath");
        IFolder webappFolder = null;
        if (warFolderPath != null) {
            webappFolder = this._project.getProject().getFolder(new Path(warFolderPath).makeRelative());
        }
        if (webappFolder == null || !webappFolder.exists()) {
            webappFolder = this._project.getProject().getFolder((IPath)new Path("src/main/webapp"));
        }
        if (!webappFolder.exists()) {
            webappFolder = this._project.getProject();
        }
        if (!(webxml = webappFolder.getFile((IPath)new Path("WEB-INF/web.xml"))).exists()) {
            try {
                this._extraClasspath = this.computeRuntimeClasspath(null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return;
        }
        if (webappContext == null) {
            webappContext = "/" + this._project.getProject().getName();
        }
        this._warFolder = webappFolder.getLocation().toString();
        this._webappContext = webappContext;
        try {
            this._extraClasspath = this.computeRuntimeClasspath(webappFolder.getLocation().toOSString());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        WebAppContext jettyContext = new WebAppContext(this._project.getProject().getName(), webappContext);
        jettyContext.setWar(this._warFolder);
        jettyContext.setExtraClasspath(this._extraClasspath);
    }

    protected String computeRuntimeClasspath(String webapp) throws CoreException {
        StringBuilder sb = new StringBuilder();
        String webLib = webapp == null ? null : String.valueOf(webapp) + File.separator + "lib" + File.separator;
        String webClasses = webapp == null ? null : String.valueOf(webapp) + File.separator + "classes";
        String[] stringArray = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)this._project);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block22: {
                String entry = stringArray[n2];
                if (webapp == null || !entry.startsWith(webLib) && !entry.startsWith(webClasses)) {
                    if (!entry.endsWith(".jar")) {
                        if (sb.length() != 0) {
                            sb.append(";");
                        }
                        sb.append(entry);
                        if (!entry.endsWith(File.separator)) {
                            sb.append(File.separator);
                        }
                    } else {
                        JarFile jf = null;
                        try {
                            try {
                                jf = new JarFile(entry);
                                if (jf.getJarEntry("javax/servlet/Servlet.class") == null && jf.getEntry("javax/servlet/jsp/JspContext.class") == null) {
                                    if (sb.length() != 0) {
                                        sb.append(";");
                                    }
                                    sb.append(entry);
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                if (jf != null) {
                                    try {
                                        jf.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            if (jf != null) {
                                try {
                                    jf.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (jf != null) {
                            try {
                                jf.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    private Map<String, String> parseManifest(IFile manifest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

