/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.core.analysis;

import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTNameNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.SourceInfo;

public class OpenMPFortranASTVisitor
extends Parser.GenericASTVisitor {
    private static final String PREFIX = "OMP_";
    private ScanReturn scanReturn;
    private String fileName;

    public OpenMPFortranASTVisitor(String fileName, ScanReturn scanReturn) {
        this.scanReturn = scanReturn;
        this.fileName = fileName;
    }

    public void visitToken(Token node) {
        for (Token ompDirective : node.getOpenMPComments()) {
            this.addArtifact(ompDirective, 3);
        }
    }

    public void visitASTVarOrFnRefNode(ASTVarOrFnRefNode node) {
        ASTNameNode nameNode = node.getName();
        if (nameNode != null) {
            this.addArtifact(nameNode.getName(), 1);
        }
    }

    private void addArtifact(Token token, int artifactType) {
        String callname = token.getText().toUpperCase();
        if (artifactType == 3 || callname.startsWith(PREFIX)) {
            int start = token.getFileOffset();
            int end = token.getFileOffset() + token.getLength();
            SourceInfo si = new SourceInfo(token.getLine(), start, end, artifactType);
            this.scanReturn.addArtifact(new Artifact(this.fileName, token.getLine(), 1, callname, si));
        }
    }
}

