/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.http.registry.HttpContextExtensionService;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.resources.JsConcatenator;
import org.eclipse.rwt.internal.resources.ResourceManagerImpl;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.resources.IResourceManagerFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

final class ResourceManagerFactory
implements IResourceManagerFactory {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    ResourceManagerFactory() {
    }

    public IResourceManager create() {
        return new ResourceManagerWrapper(ResourceManagerImpl.getInstance());
    }

    private final class HttpContextWrapper
    implements HttpContext {
        private final HttpContext context;

        private HttpContextWrapper(HttpContext context) {
            Assert.isNotNull((Object)context);
            this.context = context;
        }

        public String getMimeType(String name) {
            return this.context.getMimeType(name);
        }

        public URL getResource(String name) {
            URL result = null;
            try {
                File file = new File(name);
                if (file.exists() && !file.isDirectory()) {
                    result = new URL("file", "", name);
                }
            }
            catch (MalformedURLException shouldNotHappen) {
                throw new RuntimeException(shouldNotHappen);
            }
            return result;
        }

        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
            return true;
        }
    }

    private final class ResourceManagerWrapper
    implements IResourceManager,
    Adaptable {
        private final IResourceManager resourceManager;
        private boolean httpServiceLoaded;

        private ResourceManagerWrapper(IResourceManager internal) {
            this.resourceManager = internal;
            Adaptable adaptable = (Adaptable)this.resourceManager;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rwt.internal.resources.JsConcatenator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JsConcatenator jsConcatenator = (JsConcatenator)adaptable.getAdapter((Class)clazz);
            jsConcatenator.startJsConcatenation();
        }

        public Object getAdapter(Class adapter) {
            return ((Adaptable)this.resourceManager).getAdapter(adapter);
        }

        public String getCharset(String name) {
            return this.resourceManager.getCharset(name);
        }

        public ClassLoader getContextLoader() {
            return this.resourceManager.getContextLoader();
        }

        public String getLocation(String name) {
            return this.resourceManager.getLocation(name);
        }

        public URL getResource(String name) {
            return this.resourceManager.getResource(name);
        }

        public InputStream getResourceAsStream(String name) {
            return this.resourceManager.getResourceAsStream(name);
        }

        public Enumeration getResources(String name) throws IOException {
            return this.resourceManager.getResources(name);
        }

        public boolean isRegistered(String name) {
            return this.resourceManager.isRegistered(name);
        }

        public void register(String name) {
            this.resourceManager.register(name);
            this.registerAtHttpService(name);
        }

        public void register(String name, InputStream is) {
            this.resourceManager.register(name, is);
            this.registerAtHttpService(name);
        }

        public void register(String name, String charset) {
            this.resourceManager.register(name, charset);
            this.registerAtHttpService(name);
        }

        public void register(String name, String charset, IResourceManager.RegisterOptions options) {
            this.resourceManager.register(name, charset, options);
            this.registerAtHttpService(name);
        }

        public void register(String name, InputStream is, String charset, IResourceManager.RegisterOptions options) {
            this.resourceManager.register(name, is, charset, options);
            this.registerAtHttpService(name);
        }

        public void setContextLoader(ClassLoader classLoader) {
            this.resourceManager.setContextLoader(classLoader);
        }

        private void registerAtHttpService(String name) {
            HttpService httpService = this.getHttpService();
            if (httpService != null) {
                HttpContext httpContext = this.getHttpContext();
                HttpContextWrapper wrapper = new HttpContextWrapper(httpContext);
                StringBuffer alias = new StringBuffer();
                alias.append("/");
                alias.append("rwt-resources");
                String contextRoot = ContextProvider.getWebAppBase();
                StringBuffer location = new StringBuffer(new Path(contextRoot).toString());
                location.append("/");
                location.append("rwt-resources");
                IPath path = new Path(name).removeLastSegments(1);
                if (!path.isEmpty()) {
                    alias.append("/");
                    alias.append(path.toString());
                    location.append("/");
                    location.append(path.toString());
                }
                try {
                    httpService.registerResources(alias.toString(), location.toString(), (HttpContext)wrapper);
                }
                catch (NamespaceException namespaceException) {}
            }
        }

        private HttpContext getHttpContext() {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.equinox.http.registry.HttpContextExtensionService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String contextExtension = clazz.getName();
            BundleContext context = WorkbenchPlugin.getDefault().getBundleContext();
            ServiceReference ref = context.getServiceReference(contextExtension);
            HttpContextExtensionService service = (HttpContextExtensionService)context.getService(ref);
            String id = "org.eclipse.rap.httpcontext";
            HttpContext result = null;
            ServiceReference httpServiceRef = this.getHttpServiceRef();
            if (httpServiceRef == null) {
                throw new IllegalStateException("HttpService is not available.");
            }
            result = service.getHttpContext(httpServiceRef, id);
            return result;
        }

        private HttpService getHttpService() {
            ServiceReference reference = this.getHttpServiceRef();
            BundleContext context = WorkbenchPlugin.getDefault().getBundleContext();
            HttpService result = null;
            if (reference != null) {
                result = (HttpService)context.getService(reference);
                this.httpServiceLoaded = true;
            } else if (!this.httpServiceLoaded) {
                throw new IllegalStateException("HttpService is not available.");
            }
            return result;
        }

        private ServiceReference getHttpServiceRef() {
            BundleContext context = WorkbenchPlugin.getDefault().getBundleContext();
            ServiceReference result = null;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.osgi.service.http.HttpService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String serviceName = clazz.getName();
            try {
                result = context.getServiceReference(serviceName);
            }
            catch (IllegalStateException illegalStateException) {}
            return result;
        }

        public InputStream getRegisteredContent(String name) {
            return this.resourceManager.getRegisteredContent(name);
        }
    }
}

