/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ActiveEditorAction;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;
import org.eclipse.ui.internal.tweaklets.Tweaklets;

public class PinEditorAction
extends ActiveEditorAction {
    private IPropertyListener propListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            WorkbenchPartReference ref;
            if (propId == 531) {
                WorkbenchPartReference ref2 = (WorkbenchPartReference)source;
                PinEditorAction.this.setChecked(ref2.isPinned());
            } else if (propId == 257 && ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).autoPinOnDirty() && (ref = (WorkbenchPartReference)source).isDirty()) {
                ref.setPinned(true);
            }
        }
    };

    public PinEditorAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.get().PinEditorAction_text, window);
        this.setActionDefinitionId("org.eclipse.ui.window.pinEditor");
        this.setToolTipText(WorkbenchMessages.get().PinEditorAction_toolTip);
        this.setId("org.eclipse.ui.internal.PinEditorAction");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_PIN_EDITOR"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_PIN_EDITOR_DISABLED"));
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            WorkbenchPartReference ref = this.getReference(editor);
            ref.setPinned(this.isChecked());
        }
    }

    private WorkbenchPartReference getReference(IEditorPart editor) {
        return (WorkbenchPartReference)((EditorSite)editor.getSite()).getPartReference();
    }

    protected void updateState() {
        if (this.getWorkbenchWindow() == null || this.getActivePage() == null) {
            this.setChecked(false);
            this.setEnabled(false);
            return;
        }
        IEditorPart editor = this.getActiveEditor();
        boolean enabled = editor != null;
        this.setEnabled(enabled);
        if (enabled) {
            this.setChecked(this.getReference(editor).isPinned());
        } else {
            this.setChecked(false);
        }
    }

    protected void editorActivated(IEditorPart part) {
        super.editorActivated(part);
        if (part != null) {
            this.getReference(part).addInternalPropertyListener(this.propListener);
        }
    }

    protected void editorDeactivated(IEditorPart part) {
        super.editorDeactivated(part);
        if (part != null) {
            this.getReference(part).removeInternalPropertyListener(this.propListener);
        }
    }

    public void dispose() {
        this.editorDeactivated(this.getActiveEditor());
        super.dispose();
    }
}

