/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OpenMPI131InputStream
extends FilterInputStream {
    private static final String startTag = "<ompi>";
    private static final String endTag = "</ompi>";
    private static final int PROLOG = 0;
    private static final int XML = 1;
    private static final int EPILOG = 2;
    private static final int EOF = 3;
    private int state = 0;
    private StringBuffer extra = new StringBuffer(6);

    protected OpenMPI131InputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        while (this.state != 3) {
            switch (this.state) {
                case 0: {
                    this.extra.insert(0, startTag);
                    this.state = 1;
                    break;
                }
                case 1: {
                    int ch;
                    if (this.extra.length() > 0) {
                        ch = this.extra.charAt(0);
                        this.extra.deleteCharAt(0);
                        return ch;
                    }
                    ch = super.read();
                    if (ch < 0) {
                        this.extra.append(endTag);
                        this.state = 2;
                        break;
                    }
                    return ch;
                }
                case 2: {
                    int ch;
                    if (this.extra.length() > 0) {
                        ch = this.extra.charAt(0);
                        this.extra.deleteCharAt(0);
                        return ch;
                    }
                    this.state = 3;
                }
            }
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int pos = off;
        int avail = this.available();
        if (avail > len) {
            avail = len;
        } else if (avail == 0) {
            avail = 1;
        }
        int i = 0;
        while (i < avail) {
            int ch = this.read();
            if (ch < 0) {
                return -1;
            }
            b[pos++] = (byte)(ch & 0xFF);
            ++i;
        }
        return pos - off;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        int available = 0;
        switch (this.state) {
            case 0: {
                available = startTag.length();
                break;
            }
            case 1: {
                available = this.extra.length() + super.available();
                break;
            }
            case 2: {
                available = this.extra.length();
            }
        }
        return available;
    }
}

