/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.IToolRMConfiguration;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.parameters.OmpiInfo;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.EffectiveOpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.IOpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIDiscoverJob;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIRuntimeSystemJob;

public class OpenMPIRuntimeSystem
extends AbstractToolRuntimeSystem {
    private OmpiInfo info = new OmpiInfo();
    private String machineID;
    private String queueID;
    private Map<String, String> nodeToIDMap = new HashMap<String, String>();

    public OpenMPIRuntimeSystem(Integer openmpi_rmid, IOpenMPIResourceManagerConfiguration config, AttributeDefinitionManager attrDefMgr) {
        super(openmpi_rmid, (IToolRMConfiguration)config, attrDefMgr);
    }

    public Job createRuntimeSystemJob(String jobID, String queueID, AttributeManager attrMgr) {
        return new OpenMPIRuntimeSystemJob(jobID, queueID, Messages.OpenMPIRuntimeSystem_JobName, this, attrMgr);
    }

    public String getMachineID() {
        return this.machineID;
    }

    public String getNodeIDforName(String hostname) {
        return this.nodeToIDMap.get(hostname);
    }

    public OmpiInfo getOmpiInfo() {
        return this.info;
    }

    public String getQueueID() {
        return this.queueID;
    }

    public AbstractEffectiveToolRMConfiguration retrieveEffectiveToolRmConfiguration() {
        return new EffectiveOpenMPIResourceManagerConfiguration(this.getRmConfiguration());
    }

    public void setNodeIDForName(String name, String id) {
        this.nodeToIDMap.put(name, id);
    }

    protected Job createContinuousMonitorJob(IProgressMonitor monitor) {
        return null;
    }

    protected Job createDiscoverJob(IProgressMonitor monitor) {
        if (!this.rmConfiguration.hasDiscoverCmd()) {
            return null;
        }
        OpenMPIDiscoverJob job = new OpenMPIDiscoverJob(this, monitor);
        job.setPriority(10);
        job.setSystem(false);
        job.setUser(false);
        return job;
    }

    protected Job createPeriodicMonitorJob(IProgressMonitor monitor) {
        return null;
    }

    protected void doFilterEvents(IPElement element, boolean filterChildren, AttributeManager filterAttributes) throws CoreException {
    }

    protected void doShutdown() throws CoreException {
    }

    protected void doStartEvents() throws CoreException {
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
    }

    protected void doStopEvents() throws CoreException {
    }

    protected void setMachineID(String machineID) {
        this.machineID = machineID;
    }

    protected void setQueueID(String queueID) {
        this.queueID = queueID;
    }
}

