/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.localization.tools.LocalizationToolsPlugin;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationProject;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.extensions.providers.LocalizationSchemaProvider;
import org.eclipse.sequoyah.localization.tools.managers.Messages;
import org.eclipse.sequoyah.localization.tools.managers.ProjectLocalizationManager;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationManager {
    private Map<String, ILocalizationSchema> localizationSchemas;
    private List<String> natures;
    private Map<IProject, ProjectLocalizationManager> projectLocalizationManagers = new HashMap<IProject, ProjectLocalizationManager>();
    private LocalizationSchemaProvider localizationSchemaProvider;
    private static LocalizationManager instance = null;
    private Map<IProject, IFileChangeListener> fileChangeListeners = new HashMap<IProject, IFileChangeListener>();
    private final IResourceChangeListener resourceChangelistener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            LocalizationDeltaVisitor localizationDeltaVisitor = new LocalizationDeltaVisitor();
            try {
                if (iResourceDelta != null) {
                    iResourceDelta.accept((IResourceDeltaVisitor)localizationDeltaVisitor);
                }
            }
            catch (CoreException coreException) {
                BasePlugin.logError((String)Messages.LocalizationManager_0);
            }
        }
    };

    public static LocalizationManager getInstance() {
        if (instance == null) {
            instance = new LocalizationManager();
        }
        return instance;
    }

    public LocalizationManager() {
        this.localizationSchemaProvider = LocalizationSchemaProvider.getInstance();
        this.localizationSchemas = this.localizationSchemaProvider.getLocalizationSchemas();
        this.natures = this.getNaturesInOrder();
    }

    public ProjectLocalizationManager getProjectLocalizationManager(IProject iProject, boolean bl) throws IOException {
        ILocalizationSchema iLocalizationSchema;
        ProjectLocalizationManager projectLocalizationManager = this.projectLocalizationManagers.get(iProject);
        if (projectLocalizationManager == null && (iLocalizationSchema = this.getLocalizationSchema(iProject)) != null) {
            projectLocalizationManager = new ProjectLocalizationManager(iProject, iLocalizationSchema);
            this.projectLocalizationManagers.put(iProject, projectLocalizationManager);
        }
        if (projectLocalizationManager != null && projectLocalizationManager.getLocalizationProject() == null) {
            iLocalizationSchema = this.getLocalizationSchema(iProject);
            if (iLocalizationSchema != null) {
                projectLocalizationManager.setProject(iProject);
                ArrayList<LocalizationFile> arrayList = new ArrayList<LocalizationFile>();
                arrayList.addAll(iLocalizationSchema.loadAllFiles(iProject).values());
                projectLocalizationManager.setLocalizationProject(new LocalizationProject(iProject, arrayList));
            }
        } else if (bl) {
            projectLocalizationManager.reload(iProject);
        }
        return projectLocalizationManager;
    }

    public void unloadProjectLocalizationManager(IProject iProject) {
        this.projectLocalizationManagers.remove(iProject);
    }

    public ILocalizationSchema getLocalizationSchema(IProject iProject) {
        ILocalizationSchema iLocalizationSchema = null;
        try {
            for (String string : this.natures) {
                if (!this.projectHasNature(iProject, string)) continue;
                iLocalizationSchema = this.localizationSchemas.get(string);
            }
        }
        catch (CoreException coreException) {
            BasePlugin.logError((String)(String.valueOf(this.getClass().getName()) + Messages.LocalizationManager_1));
        }
        return iLocalizationSchema;
    }

    private boolean projectHasNature(IProject iProject, String string) throws CoreException {
        String[] stringArray;
        boolean bl = false;
        String[] stringArray2 = stringArray = iProject.getDescription().getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public ILocalizationSchema getLocalizationSchema(String string) {
        return this.localizationSchemas.get(string);
    }

    private void addWorkspaceListener() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        iWorkspace.removeResourceChangeListener(this.resourceChangelistener);
        iWorkspace.addResourceChangeListener(this.resourceChangelistener, 5);
    }

    private void handleFileDeletion(IFile iFile) {
        ProjectLocalizationManager projectLocalizationManager = null;
        try {
            projectLocalizationManager = this.getProjectLocalizationManager(iFile.getProject(), false);
        }
        catch (IOException iOException) {}
        if (projectLocalizationManager != null) {
            projectLocalizationManager.deleteFileMetaExtraData(iFile);
        }
    }

    private void handleFileChange(IFile iFile, IResourceDelta iResourceDelta) {
        LocalizationFile localizationFile;
        IDE.setDefaultEditor((IFile)iFile, (String)LocalizationToolsPlugin.EDITOR_ID);
        ProjectLocalizationManager projectLocalizationManager = null;
        try {
            projectLocalizationManager = LocalizationManager.getInstance().getProjectLocalizationManager(iFile.getProject(), false);
        }
        catch (IOException iOException) {}
        if (projectLocalizationManager != null && (localizationFile = projectLocalizationManager.getLocalizationProject().getLocalizationFile(iFile)) != null && !localizationFile.isToBeDeleted() && this.hasFileChanged(iFile, localizationFile, projectLocalizationManager)) {
            this.notifyInputChange(iFile);
        }
    }

    private boolean hasFileChanged(IFile iFile, LocalizationFile localizationFile, ProjectLocalizationManager projectLocalizationManager) {
        boolean bl = false;
        try {
            LocalizationFile localizationFile2 = projectLocalizationManager.getProjectLocalizationSchema().loadFile(iFile);
            if (!localizationFile.equals(localizationFile2)) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            BasePlugin.logError((String)Messages.LocalizationManager_2);
        }
        return bl;
    }

    private void handleFileAddition(IFile iFile) {
        IDE.setDefaultEditor((IFile)iFile, (String)LocalizationToolsPlugin.EDITOR_ID);
    }

    private List<String> getNaturesInOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ILocalizationSchema iLocalizationSchema : this.localizationSchemas.values()) {
            arrayList.add(iLocalizationSchema.getNatureName());
        }
        return arrayList;
    }

    public void initialize() {
        List<IProject> list = this.getSupportedProjects();
        for (IProject iProject : list) {
            ILocalizationSchema iLocalizationSchema = this.getLocalizationSchema(iProject);
            Map<LocaleInfo, IFile> map = iLocalizationSchema.getLocalizationFiles(iProject);
            for (IFile iFile : map.values()) {
                this.handleFileAddition(iFile);
            }
        }
        this.addWorkspaceListener();
    }

    public List<IProject> getSupportedProjects() {
        IProject[] iProjectArray;
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        IProject[] iProjectArray2 = iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            if (this.getLocalizationSchema(iProject) != null) {
                arrayList.add(iProject);
            }
            ++n2;
        }
        return arrayList;
    }

    public void addFileChangeListener(IFileChangeListener iFileChangeListener) {
        this.fileChangeListeners.put(iFileChangeListener.getProject(), iFileChangeListener);
    }

    public void removeFileChangeListener(IFileChangeListener iFileChangeListener) {
        this.fileChangeListeners.remove(iFileChangeListener.getProject());
    }

    public void notifyInputChange(IFile iFile) {
        IFileChangeListener iFileChangeListener = this.fileChangeListeners.get(iFile.getProject());
        if (iFileChangeListener != null) {
            iFileChangeListener.fileChanged(iFile);
        }
    }

    public static interface IFileChangeListener {
        public void fileChanged(IFile var1);

        public IProject getProject();
    }

    class LocalizationDeltaVisitor
    implements IResourceDeltaVisitor {
        LocalizationDeltaVisitor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) {
            ILocalizationSchema iLocalizationSchema;
            IProject iProject;
            IResource iResource = iResourceDelta.getResource();
            if (iResource != null && (iProject = iResource.getProject()) != null && (iLocalizationSchema = LocalizationManager.this.getLocalizationSchema(iProject)) != null && iResource instanceof IFile && iLocalizationSchema.isLocalizationFile((IFile)iResource)) {
                if (iResourceDelta.getKind() == 1) {
                    LocalizationManager.this.handleFileAddition((IFile)iResource);
                } else if (iResourceDelta.getKind() == 4) {
                    LocalizationManager.this.handleFileChange((IFile)iResource, iResourceDelta);
                } else if (iResourceDelta.getKind() == 2) {
                    LocalizationManager.this.handleFileDeletion((IFile)iResource);
                }
            }
            return true;
        }
    }
}

