/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory;

import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPBasicBlock;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFGNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPPragmaNode;

public class OMPCFGResult {
    protected LinkedList chains_ = new LinkedList();
    protected LinkedList unconnectedChains_ = new LinkedList();
    protected LinkedList unresolvedControlFlow_ = new LinkedList();
    protected Hashtable labelMap_ = new Hashtable();
    protected LinkedList pragmaNodeList_ = new LinkedList();
    public static final int TermUnknown = -1;
    public static final int TermForward = 0;
    public static final int TermContinue = 1;
    public static final int TermBreak = 2;
    public static final int TermReturn = 3;
    public static final int TermGoto = 4;

    public Chain addChain(OMPCFGNode headNode, OMPCFGNode tailNode, int terminationReason, IASTStatement termStmt) {
        Chain chain = new Chain(headNode, tailNode, terminationReason, termStmt);
        this.chains_.add(chain);
        this.addLabels(chain);
        this.addPragmas(chain);
        return chain;
    }

    public Chain addChain(Chain chain) {
        this.chains_.add(chain);
        this.addLabels(chain);
        this.addPragmas(chain);
        return chain;
    }

    private void addLabels(Chain chain) {
        OMPCFGNode node = chain.getHeadNode();
        while (node != null) {
            IASTName label;
            if (node instanceof OMPBasicBlock && (label = ((OMPBasicBlock)node).getLabel()) != null && !this.labelMap_.containsKey(label)) {
                this.labelMap_.put(label, new LabeledBlock(node, chain));
            }
            node = node.getSuccessor();
        }
    }

    private void addPragmas(Chain chain) {
        OMPCFGNode node = chain.getHeadNode();
        while (node != null) {
            if (node instanceof OMPPragmaNode && !this.pragmaNodeList_.contains(node)) {
                this.pragmaNodeList_.add(node);
            }
            node = node.getSuccessor();
        }
    }

    public void merge(OMPCFGResult result) {
        this.unconnectedChains_.addAll(result.getUnconnectedChains());
        this.unresolvedControlFlow_.addAll(result.getUnresolvedControlFlow());
        this.labelMap_.putAll(result.getLabelMap());
        this.pragmaNodeList_.addAll(result.getPragmaNodeList());
    }

    public void resolve() {
        for (Chain uChain : this.unresolvedControlFlow_) {
            IASTName targetLabel;
            OMPCFGNode lNode;
            IASTStatement tStmt;
            if (uChain.getTerminationReason() != 4 || (tStmt = uChain.getTerminationStmt()) == null || !(tStmt instanceof IASTGotoStatement) || (lNode = (OMPCFGNode)this.labelMap_.get(targetLabel = ((IASTGotoStatement)tStmt).getName())) == null) continue;
            uChain.getTailNode().connectTo(lNode);
            this.removeUnresolvedControlFlow(uChain);
        }
    }

    public void addUnconnectedChain(Chain chain) {
        this.unconnectedChains_.add(chain);
    }

    public void addUnresolvedControlFlow(Chain chain) {
        this.unresolvedControlFlow_.add(chain);
    }

    public void removeUnresolvedControlFlow(Chain chain) {
        this.unresolvedControlFlow_.remove(chain);
    }

    public int getNumberOfLabels() {
        return this.labelMap_.size();
    }

    public int getNumberOfPragmas() {
        return this.pragmaNodeList_.size();
    }

    public LinkedList getChains() {
        return this.chains_;
    }

    public LinkedList getUnconnectedChains() {
        return this.unconnectedChains_;
    }

    public LinkedList getUnresolvedControlFlow() {
        return this.unresolvedControlFlow_;
    }

    public Hashtable getLabelMap() {
        return this.labelMap_;
    }

    public LinkedList getPragmaNodeList() {
        return this.pragmaNodeList_;
    }

    public Chain getFirstChain() {
        return this.chains_.size() > 0 ? (Chain)this.chains_.getFirst() : null;
    }

    public Chain getLastChain() {
        return this.chains_.size() > 0 ? (Chain)this.chains_.getLast() : null;
    }

    public static class Chain {
        protected OMPCFGNode headNode_ = null;
        protected OMPCFGNode tailNode_ = null;
        protected int terminationReason_ = -1;
        protected IASTStatement terminationStmt_ = null;

        public Chain(OMPCFGNode headNode, OMPCFGNode tailNode, int terminationReason, IASTStatement termStatement) {
            this.headNode_ = headNode;
            this.tailNode_ = tailNode;
            this.terminationReason_ = terminationReason;
            this.terminationStmt_ = termStatement;
        }

        public OMPCFGNode getHeadNode() {
            return this.headNode_;
        }

        public OMPCFGNode getTailNode() {
            return this.tailNode_;
        }

        public int getTerminationReason() {
            return this.terminationReason_;
        }

        public IASTStatement getTerminationStmt() {
            return this.terminationStmt_;
        }
    }

    public static class LabeledBlock {
        protected OMPCFGNode labeledBlock_ = null;
        protected Chain relatedChain_ = null;

        public LabeledBlock(OMPCFGNode labeledBlock, Chain relatedChain) {
            this.labeledBlock_ = labeledBlock;
            this.relatedChain_ = relatedChain;
        }

        public OMPCFGNode getLabeledBlock() {
            return this.labeledBlock_;
        }

        public Chain getRelatedChain() {
            return this.relatedChain_;
        }
    }
}

