/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.services.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceConfiguration
implements IServiceConfiguration {
    protected String fName;
    protected Map<IService, IServiceProvider> fServiceToProviderMap = new HashMap<IService, IServiceProvider>();

    public ServiceConfiguration(String name) {
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public IServiceProvider getServiceProvider(IService service) {
        return this.fServiceToProviderMap.get(service);
    }

    @Override
    public void setServiceProvider(IService service, IServiceProvider provider) {
        this.fServiceToProviderMap.remove(service);
        this.fServiceToProviderMap.put(service, provider);
    }

    @Override
    public Set<IService> getServices() {
        return Collections.unmodifiableSet(this.fServiceToProviderMap.keySet());
    }

    public String toString() {
        return "ServiceConfiguration: " + this.fName + " -> " + this.fServiceToProviderMap;
    }
}

