/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.samples.dynamic.service;

import java.util.Date;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import org.eclipse.swordfish.samples.dynamic.service.FlightService;
import org.eclipse.swordfish.samples.dynamic.service.domain.Flights;
import org.eclipse.swordfish.samples.dynamic.service.domain.Location;
import org.eclipse.swordfish.samples.dynamic.service.util.FlightServiceHelper;

@WebService(endpointInterface="org.eclipse.swordfish.samples.dynamic.service.FlightService", serviceName="FlightServiceImpl")
public class FlightServiceImpl
implements FlightService {
    private FlightServiceHelper helper;

    @WebResult(name="flights")
    public Flights searchFlights(@WebParam(name="departure") Location departurePoint, @WebParam(name="destination") Location destinationPoint, @WebParam(name="date") Date departureDate) {
        if (departurePoint == null) {
            throw new IllegalArgumentException("The supplied departure point is null");
        }
        if (destinationPoint == null) {
            throw new IllegalArgumentException("The supplied destination is null");
        }
        if (departureDate == null) {
            throw new IllegalArgumentException("The supplied departure date is null");
        }
        return this.getHelper().getFlightsFor(departurePoint, destinationPoint, departureDate);
    }

    public FlightServiceHelper getHelper() {
        return this.helper;
    }

    public void setHelper(FlightServiceHelper helper) {
        this.helper = helper;
    }
}

