/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.samples.dynamic.service.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.samples.dynamic.service.domain.Flight;
import org.eclipse.swordfish.samples.dynamic.service.domain.Flights;
import org.eclipse.swordfish.samples.dynamic.service.domain.Location;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlightServiceHelper {
    private List<Flight> availableFlights = new ArrayList<Flight>();
    private URL dataUrl;

    public void initFlightsData() {
        try {
            Assert.notNull((Object)this.getDataUrl());
            InputStreamReader dataReader = new InputStreamReader(this.getDataUrl().openStream());
            Flights unmarshaledflights = (Flights)JAXB.unmarshal((Reader)dataReader, Flights.class);
            this.availableFlights.addAll(unmarshaledflights.getFlight());
        }
        catch (IOException e) {
            throw new SwordfishException((Throwable)e);
        }
    }

    public Flights getFlightsFor(Location departurePoint, Location destinationPoint, Date departureDate) {
        ArrayList<Flight> foundFlights = new ArrayList<Flight>();
        Flights flights = new Flights();
        flights.setFlight(foundFlights);
        for (Flight nextFlight : this.getAvailableFlights()) {
            if (!departurePoint.equals(nextFlight.getDeparture()) || !destinationPoint.equals(nextFlight.getDestination())) continue;
            XMLGregorianCalendar flightDate = nextFlight.getDate();
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT" + flightDate.getTimezone()));
            int year = flightDate.getYear();
            int month = flightDate.getMonth();
            int day = flightDate.getDay();
            calendar.set(year, month - 1, day, 0, 0, 0);
            calendar.set(14, 0);
            Calendar depDateCalendar = Calendar.getInstance();
            depDateCalendar.setTime(departureDate);
            if (depDateCalendar.compareTo(calendar) != 0) continue;
            foundFlights.add(nextFlight);
        }
        return flights;
    }

    public List<Flight> getAvailableFlights() {
        return this.availableFlights;
    }

    public URL getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(URL dataUrl) {
        this.dataUrl = dataUrl;
    }
}

