/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.preservation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.rephraserengine.core.preservation.PostTransformationContext;
import org.eclipse.rephraserengine.core.preservation.PreservationRule;
import org.eclipse.rephraserengine.core.preservation.ResetOffsetLength;
import org.eclipse.rephraserengine.core.util.OffsetLength;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.internal.core.preservation.Model;
import org.eclipse.rephraserengine.internal.core.preservation.ModelDiff;
import org.eclipse.rephraserengine.internal.core.preservation.PrimitiveOp;
import org.eclipse.rephraserengine.internal.core.preservation.PrimitiveOpList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreservationAnalysis {
    private IAdapterManager adapterManager = Platform.getAdapterManager();
    private EclipseVPG vpg;
    private Model initialModel;
    private PrimitiveOpList primitiveOps;
    private Set<PreservationRule> preserveEdgeTypes;

    public PreservationAnalysis(EclipseVPG vpg, IProgressMonitor progressMonitor, int ticks, IFile file, PreservationRule ... edgeTypes) {
        this(vpg, progressMonitor, ticks, EclipseVPG.getFilenameForIFile(file), edgeTypes);
    }

    public PreservationAnalysis(EclipseVPG vpg, IProgressMonitor progressMonitor, int ticks, Collection<IFile> files, PreservationRule ... edgeTypes) {
        this(vpg, progressMonitor, ticks, PreservationAnalysis.getFilenames(files), edgeTypes);
    }

    public PreservationAnalysis(EclipseVPG vpg, IProgressMonitor progressMonitor, int ticks, String filename, PreservationRule ... edgeTypes) {
        this(vpg, progressMonitor, ticks, Collections.singletonList(filename), edgeTypes);
    }

    public PreservationAnalysis(EclipseVPG vpg, IProgressMonitor progressMonitor, int ticks, List<String> filenames, PreservationRule ... edgeTypes) {
        this.vpg = vpg;
        this.primitiveOps = new PrimitiveOpList();
        this.preserveEdgeTypes = new HashSet<PreservationRule>(edgeTypes.length);
        PreservationRule[] preservationRuleArray = edgeTypes;
        int n = edgeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            PreservationRule type = preservationRuleArray[n2];
            this.preserveEdgeTypes.add(type);
            ++n2;
        }
        progressMonitor.subTask("Please wait; switching database to hypothetical mode");
        this.ensureDatabaseIsInHypotheticalMode();
        this.initialModel = new Model("initial model", progressMonitor, ticks, vpg, filenames);
    }

    private static List<String> getFilenames(Collection<IFile> files) {
        ArrayList<String> result = new ArrayList<String>(files.size());
        for (IFile file : files) {
            result.add(EclipseVPG.getFilenameForIFile(file));
        }
        return result;
    }

    private void ensureDatabaseIsInHypotheticalMode() throws Error {
        if (!this.vpg.db.isInHypotheticalMode()) {
            try {
                this.vpg.db.enterHypotheticalMode();
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }

    public void markAlpha(IFile file, Object node) {
        String filename = EclipseVPG.getFilenameForIFile(file);
        OffsetLength offsetLength = (OffsetLength)this.adapterManager.getAdapter(node, OffsetLength.class);
        if (offsetLength == null) {
            throw new Error("Unable to get OffsetLength adapter for " + node.getClass().getName());
        }
        PrimitiveOp.Alpha alpha = PrimitiveOp.alpha(filename, offsetLength.getOffset(), offsetLength.getPositionPastEnd());
        this.primitiveOps.add(alpha);
        this.adapterManager.getAdapter(node, ResetOffsetLength.class);
    }

    public void markEpsilon(IFile file, Object node) {
        String filename = EclipseVPG.getFilenameForIFile(file);
        OffsetLength offsetLength = (OffsetLength)this.adapterManager.getAdapter(node, OffsetLength.class);
        if (offsetLength == null) {
            throw new Error("Unable to get OffsetLength adapter for " + node.getClass().getName());
        }
        PrimitiveOp.Epsilon epsilon = PrimitiveOp.epsilon(filename, offsetLength.getOffset(), offsetLength.getPositionPastEnd());
        this.primitiveOps.add(epsilon);
    }

    public void markRho(IFile file, Object node, int oldLength, int newLength) {
        String filename = EclipseVPG.getFilenameForIFile(file);
        OffsetLength offsetLength = (OffsetLength)this.adapterManager.getAdapter(node, OffsetLength.class);
        if (offsetLength == null) {
            throw new Error("Unable to get OffsetLength adapter for " + node.getClass().getName());
        }
        PrimitiveOp.Rho rho = PrimitiveOp.rho(filename, offsetLength.getOffset(), oldLength, newLength);
        this.primitiveOps.add(rho);
    }

    public String toString() {
        return this.primitiveOps.toString();
    }

    public void checkForPreservation(RefactoringStatus status, IProgressMonitor progressMonitor, int ticks) {
        this.printDebug("INITIAL MODEL", this.initialModel);
        this.printDebug("NORMALIZING RELATIVE TO", this.primitiveOps);
        this.initialModel.inormalize(this.primitiveOps, this.preserveEdgeTypes, progressMonitor);
        this.printDebug("NORMALIZED INITIAL MODEL", this.initialModel);
        this.printDebug("File ordering:", this.initialModel.getFiles());
        Model derivativeModel = new Model("derivative model", progressMonitor, ticks + 3, this.vpg, this.initialModel.getFiles());
        this.printDebug("DERIVATIVE MODEL", derivativeModel);
        derivativeModel.dnormalize(this.primitiveOps, this.preserveEdgeTypes, progressMonitor);
        this.printDebug("NORMALIZED DERIVATIVE MODEL", derivativeModel);
        ModelDiff diff = this.initialModel.compareAgainst(derivativeModel, progressMonitor);
        this.describeDifferences(status, diff);
        this.leaveHypotheticalMode(progressMonitor);
    }

    private void leaveHypotheticalMode(IProgressMonitor progressMonitor) throws Error {
        try {
            progressMonitor.subTask("Switching database out of hypothetical mode");
            this.vpg.db.leaveHypotheticalMode();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void printDebug(String string, Object object) {
        System.out.println();
        System.out.println();
        System.out.print(string);
        System.out.println(":");
        System.out.println(object.toString());
    }

    private void describeDifferences(final RefactoringStatus status, ModelDiff diff) {
        final HashMap modifiedSourceCode = new HashMap();
        diff.processUsing(new ModelDiff.ModelDiffProcessor(){

            @Override
            public void processAllEdgesDeleted(Set<String> filesWithAllEdgesDeleted) {
                String msg = "The following files will not compile if the transformation is completed:";
                status.addError(msg);
                for (String filename : filesWithAllEdgesDeleted) {
                    status.addError("    " + filename, (RefactoringStatusContext)new FileStatusContext(EclipseVPG.getIFileForFilename(filename), null));
                }
            }

            private String getCode(IFile file, HashMap<IFile, String> modifiedSourceCode2) {
                if (file == null) {
                    return null;
                }
                if (modifiedSourceCode2.containsKey(file)) {
                    return modifiedSourceCode2.get(file);
                }
                Object ast = PreservationAnalysis.this.vpg.acquireTransientAST(EclipseVPG.getFilenameForIFile(file));
                if (ast == null) {
                    return null;
                }
                String code = PreservationAnalysis.this.vpg.getSourceCodeFromAST(ast);
                if (code == null) {
                    return null;
                }
                modifiedSourceCode2.put(file, code);
                return code;
            }

            @Override
            public void processEdgeAdded(ModelDiff.EdgeAdded addition) {
                String msg = "Completing this transformation will introduce an unexpected " + PreservationAnalysis.this.vpg.describeEdgeType(addition.edgeType).toLowerCase() + " (" + addition + ")";
                status.addError(msg);
                status.addError("    from here (click to view)", (RefactoringStatusContext)new PostTransformationContext(addition.getFileContainingSourceRegion(), this.getCode(addition.getFileContainingSourceRegion(), modifiedSourceCode), addition.getSourceRegion()));
                status.addError("    to here (click to view)", (RefactoringStatusContext)new PostTransformationContext(addition.getFileContainingSinkRegion(), this.getCode(addition.getFileContainingSinkRegion(), modifiedSourceCode), addition.getSinkRegion()));
            }

            @Override
            public void processEdgeDeleted(ModelDiff.EdgeDeleted deletion) {
                String msg = "Completing this transformation will cause an existing " + PreservationAnalysis.this.vpg.describeEdgeType(deletion.edgeType).toLowerCase() + " to be eliminated" + " (" + deletion + ")";
                status.addError(msg);
                status.addError("    from here (click to view)", (RefactoringStatusContext)new FileStatusContext(deletion.getFileContainingSourceRegion(), deletion.getSourceRegion()));
                status.addError("    to here (click to view)", (RefactoringStatusContext)new FileStatusContext(deletion.getFileContainingSinkRegion(), deletion.getSinkRegion()));
            }

            @Override
            public void processEdgeSinkChanged(ModelDiff.EdgeSinkChanged change) {
                String msg = "Completing this transformation will cause an existing " + PreservationAnalysis.this.vpg.describeEdgeType(change.edgeType).toLowerCase() + " to change" + " (" + change + ")";
                status.addError(msg);
                status.addError("    The " + PreservationAnalysis.this.vpg.describeEdgeType(change.edgeType).toLowerCase() + " from here (click to view)", (RefactoringStatusContext)new PostTransformationContext(change.getFileContainingSourceRegion(), this.getCode(change.getFileContainingSourceRegion(), modifiedSourceCode), change.getSourceRegion()));
                status.addError("    to here (click to view)", (RefactoringStatusContext)new PostTransformationContext(change.getFileContainingSinkRegion(), this.getCode(change.getFileContainingSinkRegion(), modifiedSourceCode), change.getSinkRegion()));
                status.addError("    will instead point here (click to view)", (RefactoringStatusContext)new PostTransformationContext(change.getFileContainingNewSinkRegion(), this.getCode(change.getFileContainingNewSinkRegion(), modifiedSourceCode), change.getNewSinkRegion()));
            }
        });
    }
}

