/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.statushandlers;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.statushandlers.AbstractStatusAreaProvider;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class StackTraceSupportArea
extends AbstractStatusAreaProvider {
    private List list;

    public Control createSupportArea(Composite parent, StatusAdapter statusAdapter) {
        Label label = new Label(parent, 0);
        label.setText(WorkbenchMessages.get().StackTraceSupportArea_Title);
        this.list = new List(parent, 770);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 250;
        this.list.setLayoutData((Object)gd);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StackTraceSupportArea.this.list.selectAll();
                super.widgetSelected(e);
            }
        });
        this.list.removeAll();
        this.populateList(statusAdapter.getStatus().getException());
        this.createDNDSource();
        this.createCopyAction(parent);
        return parent;
    }

    private void createDNDSource() {
    }

    private void createCopyAction(Composite parent) {
    }

    private void populateList(Throwable t) {
        if (t == null) {
            this.list.add(WorkbenchMessages.get().StackTraceSupportArea_NoStackTrace);
            return;
        }
        this.list.add(t.toString());
        StackTraceElement[] ste = t.getStackTrace();
        int i = 0;
        while (i < ste.length) {
            this.list.add(ste[i].toString());
            ++i;
        }
        if (t.getCause() != null) {
            this.list.add(WorkbenchMessages.get().StackTraceSupportArea_CausedBy);
            this.populateList(t.getCause());
        }
    }

    public List getList() {
        return this.list;
    }
}

