/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rwt.internal.lifecycle.UICallBackManager;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.ServletLog;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

public class UICallBackServiceHandler
implements IServiceHandler {
    public static final String HANDLER_ID;
    private static final String JS_SEND_CALLBACK_REQUEST = "org.eclipse.swt.Request.getInstance().enableUICallBack();";
    private static final String JS_SEND_UI_REQUEST = "org.eclipse.swt.Request.getInstance().send();";
    private static final String BUFFERED_SEND_CALLBACK_REQUEST;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HANDLER_ID = clazz.getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BUFFERED_SEND_CALLBACK_REQUEST = String.valueOf(clazz2.getName()) + "#jsUICallback";
    }

    public void service() throws IOException, ServletException {
        ISessionStore sessionStore = RWT.getSessionStore();
        if (!UICallBackManager.getInstance().blockCallBackRequest() && ContextProvider.hasContext() && sessionStore.isBound()) {
            UICallBackServiceHandler.writeResponse();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runNonUIThreadWithFakeContext(Display display, Runnable runnable) {
        boolean wasMapped;
        ServiceContext contextBuffer;
        boolean useDifferentContext;
        block8: {
            Object var7_7;
            boolean useFakeContext;
            Display sessionDisplay = RWTLifeCycle.getSessionDisplay();
            useDifferentContext = ContextProvider.hasContext() && sessionDisplay != display;
            contextBuffer = null;
            wasMapped = false;
            if (useDifferentContext) {
                contextBuffer = ContextProvider.getContext();
                wasMapped = ContextProvider.releaseContextHolder();
            }
            boolean bl = useFakeContext = !ContextProvider.hasContext();
            if (useFakeContext) {
                IDisplayAdapter adapter = UICallBackServiceHandler.getDisplayAdapter(display);
                ISessionStore session = adapter.getSession();
                DummyRequest request = new DummyRequest(session.getHttpSession());
                DummyResponse response = new DummyResponse();
                ServiceContext context = new ServiceContext(request, response, session);
                ContextProvider.setContext(context);
            }
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                var7_7 = null;
                if (useFakeContext) {
                    ContextProvider.disposeContext();
                }
                if (!useDifferentContext) throw throwable;
                if (wasMapped) {
                    ContextProvider.setContext(contextBuffer, Thread.currentThread());
                    throw throwable;
                }
                ContextProvider.setContext(contextBuffer);
                throw throwable;
            }
            {
                var7_7 = null;
                if (!useFakeContext) break block8;
            }
            ContextProvider.disposeContext();
        }
        if (!useDifferentContext) return;
        if (wasMapped) {
            ContextProvider.setContext(contextBuffer, Thread.currentThread());
            return;
        }
        ContextProvider.setContext(contextBuffer);
    }

    public static ServiceContext getFakeContext(HttpSession session) {
        String id = SessionStoreImpl.ID_SESSION_STORE;
        ISessionStore sessionStore = (ISessionStore)session.getAttribute(id);
        return UICallBackServiceHandler.getFakeContext(sessionStore);
    }

    public static ServiceContext getFakeContext(ISessionStore store) {
        DummyRequest request = new DummyRequest(store.getHttpSession());
        DummyResponse response = new DummyResponse();
        return new ServiceContext(request, response, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activateUICallBacksFor(String id) {
        int size;
        if (id == null) {
            SWT.error(4);
        }
        Object object = IdManager.getInstance().getLock();
        synchronized (object) {
            IdManager.getInstance().add(id);
            size = IdManager.getInstance().size();
        }
        if (size == 1) {
            UICallBackServiceHandler.registerUICallBackActivator();
        }
    }

    private static void registerUICallBackActivator() {
        final String id = ContextProvider.getSession().getId();
        LifeCycleFactory.getLifeCycle().addPhaseListener(new PhaseListener(){
            private static final long serialVersionUID = 1L;

            public void beforePhase(PhaseEvent event) {
            }

            public void afterPhase(PhaseEvent event) {
                if (id.equals(ContextProvider.getSession().getId())) {
                    LifeCycleFactory.getLifeCycle().removePhaseListener(this);
                    UICallBackManager.getInstance().setActive(true);
                    IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
                    HtmlResponseWriter writer = stateInfo.getResponseWriter();
                    try {
                        writer.write(UICallBackServiceHandler.jsEnableUICallBack());
                    }
                    catch (IOException e) {
                        ServletLog.log("", e);
                    }
                }
            }

            public PhaseId getPhaseId() {
                return PhaseId.RENDER;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deactivateUICallBacksFor(String id) {
        boolean empty;
        if (id == null) {
            SWT.error(4);
        }
        Object object = IdManager.getInstance().getLock();
        synchronized (object) {
            IdManager.getInstance().remove(id);
            empty = IdManager.getInstance().isEmpty();
        }
        if (empty) {
            UICallBackManager instance = UICallBackManager.getInstance();
            instance.setActive(false);
            instance.sendUICallBack();
        }
    }

    private static IDisplayAdapter getDisplayAdapter(Display display) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IDisplayAdapter)display.getAdapter(clazz);
    }

    static void writeResponse() throws IOException {
        HttpServletResponse response = ContextProvider.getResponse();
        response.setHeader("Content-Type", "text/javascript; charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.print(UICallBackServiceHandler.jsUICallBack());
        writer.flush();
    }

    private static String jsUICallBack() {
        String result;
        if (UICallBackServiceHandler.isUICallBackActive() && !UICallBackManager.getInstance().isCallBackRequestBlocked()) {
            ISessionStore session = ContextProvider.getSession();
            String bufferedCode = (String)session.getAttribute(BUFFERED_SEND_CALLBACK_REQUEST);
            if (bufferedCode == null) {
                StringBuffer code = new StringBuffer();
                code.append(JS_SEND_UI_REQUEST);
                code.append(JS_SEND_CALLBACK_REQUEST);
                bufferedCode = code.toString();
                session.setAttribute(BUFFERED_SEND_CALLBACK_REQUEST, bufferedCode);
            }
            result = bufferedCode;
        } else {
            result = JS_SEND_UI_REQUEST;
        }
        return result;
    }

    public static String jsEnableUICallBack() {
        String result = "";
        if (UICallBackServiceHandler.isUICallBackActive() && !UICallBackManager.getInstance().isCallBackRequestBlocked()) {
            result = JS_SEND_CALLBACK_REQUEST;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUICallBackActive() {
        Object object = IdManager.getInstance().getLock();
        synchronized (object) {
            return !IdManager.getInstance().isEmpty();
        }
    }

    private static final class DummyRequest
    implements HttpServletRequest {
        private final HttpSession session;

        private DummyRequest(HttpSession session) {
            this.session = session;
        }

        public String getAuthType() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String name) {
            return 0L;
        }

        public String getHeader(String name) {
            return null;
        }

        public Enumeration getHeaderNames() {
            return null;
        }

        public Enumeration getHeaders(String name) {
            return null;
        }

        public int getIntHeader(String name) {
            return 0;
        }

        public String getMethod() {
            return null;
        }

        public String getPathInfo() {
            return null;
        }

        public String getPathTranslated() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public String getRemoteUser() {
            return null;
        }

        public String getRequestURI() {
            return null;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getServletPath() {
            return null;
        }

        public HttpSession getSession() {
            return this.session;
        }

        public HttpSession getSession(boolean create) {
            return this.session;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public String getLocalAddr() {
            return null;
        }

        public String getLocalName() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration getLocales() {
            return null;
        }

        public String getParameter(String name) {
            return null;
        }

        public Map getParameterMap() {
            return null;
        }

        public Enumeration getParameterNames() {
            return null;
        }

        public String[] getParameterValues(String name) {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRealPath(String path) {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public boolean isSecure() {
            return false;
        }

        public void removeAttribute(String name) {
        }

        public void setAttribute(String name, Object o) {
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        }
    }

    private static final class DummyResponse
    implements HttpServletResponse {
        private DummyResponse() {
        }

        public void addCookie(Cookie cookie) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void addHeader(String name, String value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public String encodeURL(String url) {
            return null;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public void sendError(int sc) throws IOException {
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendRedirect(String location) throws IOException {
        }

        public void setDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void setStatus(int sc) {
        }

        public void setStatus(int sc, String sm) {
        }

        public void flushBuffer() throws IOException {
        }

        public int getBufferSize() {
            return 0;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            return null;
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void resetBuffer() {
        }

        public void setBufferSize(int size) {
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int len) {
        }

        public void setContentType(String type) {
        }

        public void setLocale(Locale loc) {
        }
    }

    private static final class IdManager {
        private final Set ids = new HashSet();

        static IdManager getInstance() {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler$IdManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IdManager)SessionSingletonBase.getInstance(clazz);
        }

        IdManager() {
        }

        Object getLock() {
            return this.ids;
        }

        void add(String id) {
            this.ids.add(id);
        }

        void remove(String id) {
            this.ids.remove(id);
        }

        boolean isEmpty() {
            return this.ids.isEmpty();
        }

        int size() {
            return this.ids.size();
        }
    }
}

