/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.RWTRequestVersionControl;
import org.eclipse.rwt.internal.service.AbstractServiceHandler;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.RequestParameterBuffer;
import org.eclipse.rwt.internal.service.ServiceStateInfo;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.internal.service.StartupPage;
import org.eclipse.rwt.service.ISessionStore;

public class LifeCycleServiceHandler
extends AbstractServiceHandler {
    public static final String RWT_INITIALIZE = "rwt_initialize";
    private static final String PATTERN_RELOAD = "qx.core.Init.getInstance().getApplication().reload( \"{0}\" )";
    static final String SESSION_INITIALIZED;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.LifeCycleServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SESSION_INITIALIZED = String.valueOf(clazz.getName()) + "#isSessionInitialized";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() throws IOException, ServletException {
        ISessionStore iSessionStore = ContextProvider.getSession();
        synchronized (iSessionStore) {
            this.synchronizedService();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void synchronizedService() throws ServletException, IOException {
        LifeCycleServiceHandler.initializeStateInfo();
        RWTRequestVersionControl.beforeService();
        try {
            if (RWTRequestVersionControl.isValid() || LifeCycleServiceHandler.isSessionRestart() || ContextProvider.getRequest().getSession().isNew()) {
                LifeCycleServiceHandler.runLifeCycle();
            } else {
                LifeCycleServiceHandler.handleInvalidRequestCounter();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            RWTRequestVersionControl.afterService();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        RWTRequestVersionControl.afterService();
    }

    private static void runLifeCycle() throws ServletException, IOException {
        LifeCycleServiceHandler.checkRequest();
        LifeCycleServiceHandler.initializeSession();
        if (LifeCycleServiceHandler.isSessionInitialized()) {
            RequestParameterBuffer.merge();
            LifeCycle lifeCycle = (LifeCycle)LifeCycleFactory.getLifeCycle();
            lifeCycle.execute();
        } else {
            Map parameters = ContextProvider.getRequest().getParameterMap();
            RequestParameterBuffer.store(parameters);
            StartupPage.send();
        }
        LifeCycleServiceHandler.writeOutput();
    }

    private static boolean isSessionRestart() {
        HttpServletRequest request = LifeCycleServiceHandler.getRequest();
        boolean startup = request.getParameter("startup") != null;
        String uiRoot = request.getParameter("uiRoot");
        HttpSession session = request.getSession();
        return !session.isNew() && !startup && uiRoot == null || startup && LifeCycleServiceHandler.isSessionInitialized();
    }

    private static void initializeStateInfo() {
        if (ContextProvider.getStateInfo() == null) {
            ServiceStateInfo stateInfo = new ServiceStateInfo();
            ContextProvider.getContext().setStateInfo(stateInfo);
        }
        if (ContextProvider.getStateInfo().getResponseWriter() == null) {
            HtmlResponseWriter htmlResponseWriter = new HtmlResponseWriter();
            ContextProvider.getStateInfo().setResponseWriter(htmlResponseWriter);
        }
    }

    private static void handleInvalidRequestCounter() throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HtmlResponseWriter out = stateInfo.getResponseWriter();
        String message = RWTMessages.getMessage("RWT_MultipleInstancesError");
        Object[] args = new Object[]{message};
        out.write(MessageFormat.format(PATTERN_RELOAD, args));
        HttpServletResponse response = ContextProvider.getResponse();
        response.setContentType("text/javascript; charset=UTF-8");
        LifeCycleServiceHandler.writeOutput();
    }

    private static boolean isSessionInitialized() {
        ISessionStore session = ContextProvider.getSession();
        return Boolean.TRUE.equals(session.getAttribute(SESSION_INITIALIZED));
    }

    public static void initializeSession() {
        if (!LifeCycleServiceHandler.isSessionInitialized() && LifeCycleServiceHandler.getRequest().getParameter(RWT_INITIALIZE) != null) {
            ISessionStore session = ContextProvider.getSession();
            session.setAttribute(SESSION_INITIALIZED, Boolean.TRUE);
        }
    }

    private static void checkRequest() {
        if (LifeCycleServiceHandler.isSessionRestart()) {
            LifeCycleServiceHandler.clearSession(LifeCycleServiceHandler.getRequest().getSession());
        }
    }

    private static void clearSession(HttpSession session) {
        Enumeration keys = session.getAttributeNames();
        ArrayList keyBuffer = new ArrayList();
        while (keys.hasMoreElements()) {
            keyBuffer.add(keys.nextElement());
        }
        Object[] attributeNames = keyBuffer.toArray();
        int i = 0;
        while (i < attributeNames.length) {
            String idSessionStore = SessionStoreImpl.ID_SESSION_STORE;
            if (!idSessionStore.equals(attributeNames[i])) {
                session.removeAttribute((String)attributeNames[i]);
            } else {
                SessionStoreImpl sessionStore = (SessionStoreImpl)session.getAttribute(idSessionStore);
                sessionStore.valueUnbound(null);
                sessionStore.valueBound(null);
                sessionStore.setAttribute(SessionSingletonBase.LOCK, new Object());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeOutput() throws IOException {
        if (ContextProvider.getContext().isDisposed()) return;
        HtmlResponseWriter content = ContextProvider.getStateInfo().getResponseWriter();
        PrintWriter out = LifeCycleServiceHandler.getOutputWriter();
        try {
            int i = 0;
            while (i < content.getBodySize()) {
                out.print(content.getBodyToken(i));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            out.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
            out.close();
            return;
        }
    }
}

