/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.rwt.internal.util.ParamCheck;

public final class StartupPageTemplateHolder {
    private static final int[] EMPTY_INDICES = new int[0];
    private static final String TOKEN_BACKGROUND_IMAGE = "backgroundImage";
    private static final String TOKEN_LIBRARIES = "libraries";
    private static final String TOKEN_APPSCRIPT = "appScript";
    private static final String TOKEN_SERVLET = "servlet";
    private static final String TOKEN_ENTRY_POINT = "entrypoint";
    private static final String TOKEN_BODY = "body";
    private static final String TOKEN_TITLE = "title";
    private static final String TOKEN_HEADERS = "headers";
    private static final String TOKEN_STARTUP = "startup";
    private static final String TOKEN_EXIT_CONFIRMATION = "exitConfirmation";
    private static final String TOKEN_NO_SCRIPT_MESSAGE = "noScriptMessage";
    public static final Variable VAR_BACKGROUND_IMAGE = new Variable("backgroundImage");
    public static final Variable VAR_LIBRARIES = new Variable("libraries");
    public static final Variable VAR_APPSCRIPT = new Variable("appScript");
    public static final Variable VAR_SERVLET = new Variable("servlet");
    public static final Variable VAR_ENTRY_POINT = new Variable("entrypoint");
    public static final Variable VAR_BODY = new Variable("body");
    public static final Variable VAR_TITLE = new Variable("title");
    public static final Variable VAR_HEADERS = new Variable("headers");
    public static final Variable VAR_STARTUP = new Variable("startup");
    public static final Variable VAR_EXIT_CONFIRMATION = new Variable("exitConfirmation");
    public static final Variable VAR_NO_SCRIPT_MESSAGE = new Variable("noScriptMessage");
    private final String[] tokens;
    private final Map replacementIndices;

    public StartupPageTemplateHolder(String template) {
        ParamCheck.notNull(template, "template");
        this.replacementIndices = new HashMap();
        StringTokenizer tokenizer = new StringTokenizer(template, "${}", true);
        int countTokens = tokenizer.countTokens();
        this.tokens = new String[countTokens];
        boolean ignoreNextToken = false;
        int i = 0;
        while (i < this.tokens.length) {
            String nextToken = tokenizer.nextToken();
            if (ignoreNextToken) {
                ignoreNextToken = false;
            } else if (!this.isVariableToken(nextToken)) {
                this.tokens[i] = nextToken;
            } else {
                Variable variable = Variable.lookup(nextToken);
                this.addReplacementIndex(variable, i);
                this.tokens[i - 1] = "";
                this.tokens[i - 2] = "";
                this.tokens[i + 1] = "";
                ignoreNextToken = true;
            }
            ++i;
        }
    }

    private boolean isVariableToken(String nextToken) {
        return nextToken.equals(TOKEN_BACKGROUND_IMAGE.toString()) || nextToken.equals(TOKEN_LIBRARIES.toString()) || nextToken.equals(TOKEN_APPSCRIPT.toString()) || nextToken.equals(TOKEN_SERVLET.toString()) || nextToken.equals(TOKEN_ENTRY_POINT.toString()) || nextToken.equals(TOKEN_BODY.toString()) || nextToken.equals(TOKEN_TITLE.toString()) || nextToken.equals(TOKEN_HEADERS.toString()) || nextToken.equals(TOKEN_STARTUP.toString()) || nextToken.equals(TOKEN_EXIT_CONFIRMATION.toString()) || nextToken.equals(TOKEN_NO_SCRIPT_MESSAGE.toString());
    }

    private void addReplacementIndex(Variable variable, int index) {
        ArrayList<Integer> indices = (ArrayList<Integer>)this.replacementIndices.get(variable);
        if (indices == null) {
            indices = new ArrayList<Integer>();
            this.replacementIndices.put(variable, indices);
        }
        indices.add(new Integer(index));
    }

    private int[] getReplacementIndices(Variable variable) {
        List indices = (List)this.replacementIndices.get(variable);
        int[] result = null;
        if (indices == null) {
            result = EMPTY_INDICES;
        } else {
            Object[] buffer = indices.toArray();
            result = new int[buffer.length];
            int i = 0;
            while (i < result.length) {
                result[i] = (Integer)buffer[i];
                ++i;
            }
        }
        return result;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public void replace(Variable toReplace, String replacement) {
        int[] indices = this.getReplacementIndices(toReplace);
        int i = 0;
        while (i < indices.length) {
            this.tokens[indices[i]] = replacement;
            ++i;
        }
    }

    public void reset() {
        Iterator iterator = Variable.NAMES.values().iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            int[] indices = this.getReplacementIndices(variable);
            int i = 0;
            while (i < indices.length) {
                this.tokens[indices[i]] = null;
                ++i;
            }
        }
    }

    public static final class Variable {
        private static final Map NAMES = new HashMap();
        private final String name;

        private Variable(String varName) {
            this.name = varName;
            NAMES.put(varName, this);
        }

        private static Variable lookup(String name) {
            return (Variable)NAMES.get(name);
        }

        public String toString() {
            return "${" + this.name + "}";
        }
    }
}

