/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.ResourceLoader;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.ResourceFactory;

public final class QxImage
implements QxType {
    private static final String NONE_INPUT = "none";
    public static final QxImage NONE = new QxImage(true, null, null, null, null);
    public final boolean none;
    public final String path;
    public final ResourceLoader loader;
    public final String[] gradientColors;
    public final float[] gradientPercents;
    public final int width;
    public final int height;

    private QxImage(boolean none, String path, ResourceLoader loader, String[] gradientColors, float[] gradientPercents) {
        this.none = none;
        this.path = path;
        this.loader = loader;
        this.gradientColors = gradientColors;
        this.gradientPercents = gradientPercents;
        if (none) {
            this.width = 0;
            this.height = 0;
        } else {
            try {
                Point size = QxImage.readImageSize(path, loader);
                if (size == null) {
                    throw new IllegalArgumentException("Failed to read image '" + path + "'");
                }
                this.width = size.x;
                this.height = size.y;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read image " + path + ": " + e.getMessage());
            }
        }
    }

    public static QxImage valueOf(String input, ResourceLoader loader) {
        QxImage result;
        if (NONE_INPUT.equals(input)) {
            result = NONE;
        } else {
            if (input == null || loader == null) {
                throw new NullPointerException("null argument");
            }
            if (input.length() == 0) {
                throw new IllegalArgumentException("Empty image path");
            }
            result = new QxImage(false, input, loader, null, null);
        }
        return result;
    }

    public static QxImage createGradient(String[] gradientColors, float[] gradientPercents) {
        if (gradientColors == null || gradientPercents == null) {
            throw new NullPointerException("null argument");
        }
        QxImage result = new QxImage(true, null, null, gradientColors, gradientPercents);
        return result;
    }

    public String getResourceName() {
        String result = null;
        if (this.path != null) {
            result = "themes/images/" + Theme.createCssKey(this);
        }
        return result;
    }

    public String toDefaultString() {
        return this.none ? NONE_INPUT : "";
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object instanceof QxImage) {
            QxImage other = (QxImage)object;
            result = (this.path == null ? other.path == null : this.path.equals(other.path)) && (this.loader == null ? other.loader == null : this.loader.equals(other.loader)) && (this.gradientColors == null ? other.gradientColors == null : Arrays.equals(this.gradientColors, other.gradientColors)) && (this.gradientPercents == null ? other.gradientPercents == null : Arrays.equals(this.gradientPercents, other.gradientPercents));
        }
        return result;
    }

    public int hashCode() {
        int result = -1;
        if (this.none) {
            if (this.gradientColors != null && this.gradientPercents != null) {
                result = 29;
                int i = 0;
                while (i < this.gradientColors.length) {
                    result += 31 * result + this.gradientColors[i].hashCode();
                    ++i;
                }
                i = 0;
                while (i < this.gradientPercents.length) {
                    result += 31 * result + Float.floatToIntBits(this.gradientPercents[i]);
                    ++i;
                }
            }
        } else {
            result = this.path.hashCode();
        }
        return result;
    }

    public String toString() {
        return "QxImage{ " + (this.none ? NONE_INPUT : this.path) + " }";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Point readImageSize(String path, ResourceLoader loader) throws IOException {
        Point result = null;
        InputStream inputStream = loader.getResourceAsStream(path);
        if (inputStream == null) return result;
        try {
            result = ResourceFactory.readImageSize(inputStream);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            inputStream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        inputStream.close();
        return result;
    }
}

