/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.rwt.internal.theme.QxFont;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.SimpleSelector;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ResourceFactory;

public abstract class Device
implements Drawable {
    private boolean disposed;

    public Color getSystemColor(int id) {
        Color result;
        this.checkDevice();
        switch (id) {
            case 1: {
                result = ResourceFactory.getColor(255, 255, 255);
                break;
            }
            case 2: {
                result = ResourceFactory.getColor(0, 0, 0);
                break;
            }
            case 3: {
                result = ResourceFactory.getColor(255, 0, 0);
                break;
            }
            case 4: {
                result = ResourceFactory.getColor(128, 0, 0);
                break;
            }
            case 5: {
                result = ResourceFactory.getColor(0, 255, 0);
                break;
            }
            case 6: {
                result = ResourceFactory.getColor(0, 128, 0);
                break;
            }
            case 7: {
                result = ResourceFactory.getColor(255, 255, 0);
                break;
            }
            case 8: {
                result = ResourceFactory.getColor(128, 128, 0);
                break;
            }
            case 9: {
                result = ResourceFactory.getColor(0, 0, 255);
                break;
            }
            case 10: {
                result = ResourceFactory.getColor(0, 0, 128);
                break;
            }
            case 11: {
                result = ResourceFactory.getColor(255, 0, 255);
                break;
            }
            case 12: {
                result = ResourceFactory.getColor(128, 0, 128);
                break;
            }
            case 13: {
                result = ResourceFactory.getColor(0, 255, 255);
                break;
            }
            case 14: {
                result = ResourceFactory.getColor(0, 128, 128);
                break;
            }
            case 15: {
                result = ResourceFactory.getColor(192, 192, 192);
                break;
            }
            case 16: {
                result = ResourceFactory.getColor(128, 128, 128);
                break;
            }
            default: {
                result = ResourceFactory.getColor(0, 0, 0);
            }
        }
        return result;
    }

    public Font getSystemFont() {
        this.checkDevice();
        QxType font = ThemeUtil.getCssValue("Display", "font", SimpleSelector.DEFAULT);
        return QxFont.createFont((QxFont)font);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        FontData[] result;
        block7: {
            this.checkDevice();
            result = new FontData[]{};
            if (!scalable) break block7;
            QxFont fontList = (QxFont)ThemeUtil.getCssValue("Display", "rwt-fontlist", SimpleSelector.DEFAULT);
            if (faceName == null) {
                result = new FontData[fontList.family.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = new FontData(fontList.family[i], 0, 0);
                    ++i;
                }
            } else {
                int counter = 0;
                int i = 0;
                while (i < fontList.family.length) {
                    if (fontList.family[i].startsWith(faceName)) {
                        ++counter;
                    }
                    ++i;
                }
                result = new FontData[counter];
                counter = 0;
                i = 0;
                while (i < fontList.family.length) {
                    if (fontList.family[i].startsWith(faceName)) {
                        result[counter++] = new FontData(fontList.family[i], 0, 0);
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, 0, 0);
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.release();
            this.destroy();
            this.disposed = true;
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    protected void release() {
    }

    protected void destroy() {
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }
}

