/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class GC
extends Resource {
    private Font font;
    private Color background;
    private Color foreground;

    public GC(Drawable drawable) {
        super(GC.determineDevice(drawable));
        if (drawable == null) {
            SWT.error(4);
        }
        this.font = GC.determineFont(drawable);
        this.background = GC.determineBackground(drawable);
        this.foreground = GC.determineForeground(drawable);
    }

    public void setFont(Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
    }

    public Font getFont() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.font;
    }

    public int getCharWidth(char ch) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return Graphics.stringExtent((Font)this.font, (String)Character.toString((char)ch)).x;
    }

    public Point stringExtent(String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return Graphics.stringExtent(this.font, string);
    }

    public Point textExtent(String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return Graphics.textExtent(this.font, string, 0);
    }

    public FontMetrics getFontMetrics() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new FontMetrics(this.font);
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.background = color;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.background;
    }

    public void setForeground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.foreground = color;
    }

    public Color getForeground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.foreground;
    }

    private static Device determineDevice(Drawable drawable) {
        Device result = null;
        if (drawable instanceof Control) {
            result = ((Control)drawable).getDisplay();
        } else if (drawable instanceof Device) {
            result = (Device)drawable;
        }
        return result;
    }

    private static Font determineFont(Drawable drawable) {
        Font result = null;
        if (drawable instanceof Control) {
            result = ((Control)drawable).getFont();
        } else if (drawable instanceof Display) {
            result = ((Display)drawable).getSystemFont();
        }
        return result;
    }

    private static Color determineBackground(Drawable drawable) {
        Color result = null;
        if (drawable instanceof Control) {
            result = ((Control)drawable).getBackground();
        } else if (drawable instanceof Display) {
            result = ((Display)drawable).getSystemColor(1);
        }
        return result;
    }

    private static Color determineForeground(Drawable drawable) {
        Color result = null;
        if (drawable instanceof Control) {
            result = ((Control)drawable).getForeground();
        } else if (drawable instanceof Display) {
            result = ((Display)drawable).getSystemColor(2);
        }
        return result;
    }
}

