/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.AdapterManagerImpl;
import org.eclipse.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rwt.internal.lifecycle.UICallBackManager;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServletLog;
import org.eclipse.rwt.internal.theme.QxColor;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.SimpleSelector;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.rwt.service.IServiceStore;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device
implements Adaptable {
    private static final String AVAILABLE_WIDTH = "w4t_width";
    private static final String AVAILABLE_HEIGHT = "w4t_height";
    private static final String ATTR_INVALIDATE_FOCUS;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    private static final int DOUBLE_CLICK_TIME = 500;
    private static final int GROW_SIZE = 1024;
    private static String appName;
    private static String appVersion;
    private final List shells;
    private final Thread thread = Thread.currentThread();
    private final ISessionStore session = ContextProvider.getSession();
    private Rectangle bounds;
    private final Point cursorLocation;
    private int scrollBarSize;
    private Shell activeShell;
    private List filters;
    private Control focusControl;
    private final Monitor monitor;
    private IDisplayAdapter displayAdapter;
    private WidgetAdapter widgetAdapter;
    private Set closeListeners;
    private Set disposeListeners;
    private Runnable[] disposeList;
    private Composite[] layoutDeferred;
    private int layoutDeferredCount;
    private Widget[] skinList;
    private int skinCount;
    private Set skinListeners;
    private Object data;
    private String[] keys;
    private Object[] values;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Display$DisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ATTR_INVALIDATE_FOCUS = String.valueOf(clazz.getName()) + "#invalidateFocus";
        appName = "RAP";
        appVersion = "";
    }

    public static Display getCurrent() {
        Display result = RWTLifeCycle.getSessionDisplay();
        if (result != null && (result.getThread() != Thread.currentThread() || result.isDisposed())) {
            result = null;
        }
        return result;
    }

    public static Display getDefault() {
        Display result = RWTLifeCycle.getSessionDisplay();
        if (result == null && Display.isUIThread()) {
            result = new Display();
        }
        return result;
    }

    private static boolean isUIThread() {
        return ContextProvider.hasContext() && RWTLifeCycle.getUIThreadHolder() != null && RWTLifeCycle.getUIThreadHolder().getThread() != null && Thread.currentThread() == RWTLifeCycle.getUIThreadHolder().getThread();
    }

    public Display() {
        if (Display.getCurrent() != null) {
            SWT.error(20, null, " [multiple displays]");
        }
        RWTLifeCycle.setSessionDisplay(this);
        this.shells = new ArrayList();
        this.readInitialBounds();
        this.readScrollBarSize();
        this.monitor = new Monitor(this);
        this.cursorLocation = new Point(0, 0);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public Control getFocusControl() {
        this.checkDevice();
        return this.focusControl;
    }

    private void setFocusControl(Control focusControl) {
        if (this.focusControl != focusControl) {
            FocusEvent event;
            if (this.focusControl != null && !this.focusControl.isInDispose()) {
                event = new FocusEvent(this.focusControl, 16);
                event.processEvent();
            }
            this.focusControl = focusControl;
            if (this.focusControl != null) {
                event = new FocusEvent(this.focusControl, 15);
                event.processEvent();
            }
        }
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            SWT.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        this.checkDevice();
        Rectangle rectangle = this.map(from, to, x, y, 0, 0);
        return new Point(rectangle.x, rectangle.y);
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        this.checkDevice();
        int newX = x;
        int newY = y;
        if (from != null) {
            Point fromOrigin = Display.getAbsoluteOrigin(from);
            newX += fromOrigin.x;
            newY += fromOrigin.y;
        }
        if (to != null) {
            Point toOrigin = Display.getAbsoluteOrigin(to);
            newX -= toOrigin.x;
            newY -= toOrigin.y;
        }
        return new Rectangle(newX, newY, width, height);
    }

    private static Point getAbsoluteOrigin(Control control) {
        Control currentControl = control;
        Point absolute = new Point(0, 0);
        while (currentControl != null) {
            Point origin = Display.getOrigin(currentControl);
            absolute.x += origin.x;
            absolute.y += origin.y;
            currentControl = currentControl instanceof Shell ? null : currentControl.getParent();
        }
        return new Point(absolute.x, absolute.y);
    }

    private static Point getOrigin(Control control) {
        Point result = control.getLocation();
        if (control instanceof Composite) {
            int borderWidth = control.getBorderWidth();
            result.x += borderWidth;
            result.y += borderWidth;
        }
        return result;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (eventType == 21) {
            if (this.closeListeners == null) {
                this.closeListeners = new HashSet();
            }
            this.closeListeners.add(listener);
        } else if (eventType == 12) {
            if (this.disposeListeners == null) {
                this.disposeListeners = new HashSet();
            }
            this.disposeListeners.add(listener);
        } else if (eventType == 45) {
            if (this.skinListeners == null) {
                this.skinListeners = new HashSet();
            }
            this.skinListeners.add(listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (eventType == 21 && this.closeListeners != null) {
            this.closeListeners.remove(listener);
            if (this.closeListeners.size() == 0) {
                this.closeListeners = null;
            }
        } else if (eventType == 12 && this.disposeListeners != null) {
            this.disposeListeners.remove(listener);
            if (this.disposeListeners.size() == 0) {
                this.disposeListeners = null;
            }
        } else if (eventType == 45 && this.skinListeners != null) {
            this.skinListeners.remove(listener);
            if (this.skinListeners.size() == 0) {
                this.skinListeners = null;
            }
        }
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        event.display = this;
        event.type = 21;
        this.notifyFilters(event);
        if (this.closeListeners != null) {
            Listener[] listeners = new Listener[this.closeListeners.size()];
            this.closeListeners.toArray(listeners);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleEvent(event);
                ++i;
            }
        }
        if (event.doit) {
            this.dispose();
        }
    }

    protected void release() {
        this.sendDisposeEvent();
        this.disposeShells();
        this.runDisposeExecs();
    }

    private void sendDisposeEvent() {
        Event event = new Event();
        event.display = this;
        event.type = 12;
        this.notifyFilters(event);
        if (this.disposeListeners != null) {
            Listener[] listeners = new Listener[this.disposeListeners.size()];
            this.disposeListeners.toArray(listeners);
            int i = 0;
            while (i < listeners.length) {
                try {
                    listeners[i].handleEvent(event);
                }
                catch (Throwable thr) {
                    String msg = "Exception while executing dispose-listener.";
                    ServletLog.log(msg, thr);
                }
                ++i;
            }
        }
    }

    private void disposeShells() {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            try {
                shell.dispose();
            }
            catch (Throwable thr) {
                ServletLog.log("Exception while disposing shell: " + shell, thr);
            }
            ++i;
        }
    }

    private void runDisposeExecs() {
        if (this.disposeList != null) {
            int i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    try {
                        this.disposeList[i].run();
                    }
                    catch (Throwable thr) {
                        String msg = "Exception while executing dispose-runnable.";
                        ServletLog.log(msg, thr);
                    }
                }
                ++i;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.displayAdapter == null) {
                this.displayAdapter = new DisplayAdapter(this.session);
            }
            result = this.displayAdapter;
        } else {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.rwt.lifecycle.IWidgetAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                if (this.widgetAdapter == null) {
                    this.widgetAdapter = new WidgetAdapter("w1");
                }
                result = this.widgetAdapter;
            } else {
                result = AdapterManagerImpl.getInstance().getAdapter(this, adapter);
            }
        }
        return result;
    }

    public Shell[] getShells() {
        this.checkDevice();
        Shell[] result = new Shell[this.shells.size()];
        this.shells.toArray(result);
        return result;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    final void setActiveShell(Shell activeShell) {
        this.checkDevice();
        if (this.activeShell != activeShell) {
            ShellEvent shellEvent;
            Shell lastActiveShell = this.activeShell;
            if (this.activeShell != null) {
                this.activeShell.saveFocus();
            }
            if (activeShell != null) {
                this.shells.remove(activeShell);
                this.shells.add(activeShell);
            }
            if (lastActiveShell != null && (lastActiveShell.state & 0x1000) == 0) {
                shellEvent = new ShellEvent(lastActiveShell, 27);
                shellEvent.processEvent();
            }
            this.activeShell = activeShell;
            if (activeShell != null) {
                shellEvent = new ShellEvent(activeShell, 26);
                shellEvent.processEvent();
            }
            if (this.activeShell != null) {
                this.activeShell.restoreFocus();
            }
        }
    }

    final void addShell(Shell shell) {
        this.shells.add(shell);
    }

    final void removeShell(Shell shell) {
        this.shells.remove(shell);
        if (shell == this.activeShell) {
            if (this.shells.size() > 0) {
                this.setActiveShell((Shell)this.shells.get(this.shells.size() - 1));
            } else {
                this.setActiveShell(null);
            }
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public void asyncExec(final Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        UICallBack.runNonUIThreadWithFakeContext(this, new Runnable(){

            public void run() {
                UICallBackManager.getInstance().addAsync(Display.this, runnable);
            }
        });
    }

    public void syncExec(final Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        UICallBack.runNonUIThreadWithFakeContext(this, new Runnable(){

            public void run() {
                UICallBackManager.getInstance().addSync(Display.this, runnable);
            }
        });
    }

    public void timerExec(int milliseconds, final Runnable runnable) {
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        final long time = System.currentTimeMillis() + (long)milliseconds;
        UICallBack.runNonUIThreadWithFakeContext(this, new Runnable(){

            public void run() {
                UICallBackManager callBackManager = UICallBackManager.getInstance();
                callBackManager.addTimer(Display.this, runnable, time);
            }
        });
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        return RWTLifeCycle.readAndDispatch();
    }

    public boolean sleep() {
        this.checkDevice();
        RWTLifeCycle lifeCycle = (RWTLifeCycle)LifeCycleFactory.getLifeCycle();
        lifeCycle.sleep();
        return true;
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.getThread() != Thread.currentThread()) {
            UICallBack.runNonUIThreadWithFakeContext(this, new Runnable(){

                public void run() {
                    UICallBackManager.getInstance().sendUICallBack();
                }
            });
        }
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        Color result = null;
        QxType value = null;
        switch (id) {
            case 17: {
                value = ThemeUtil.getCssValue("Display", "rwt-darkshadow-color", SimpleSelector.DEFAULT);
                break;
            }
            case 18: {
                value = ThemeUtil.getCssValue("Display", "rwt-shadow-color", SimpleSelector.DEFAULT);
                break;
            }
            case 19: {
                value = ThemeUtil.getCssValue("Display", "rwt-lightshadow-color", SimpleSelector.DEFAULT);
                break;
            }
            case 20: {
                value = ThemeUtil.getCssValue("Display", "rwt-highlight-color", SimpleSelector.DEFAULT);
                break;
            }
            case 23: {
                value = ThemeUtil.getCssValue("Display", "rwt-thinborder-color", SimpleSelector.DEFAULT);
                break;
            }
            case 22: {
                value = ThemeUtil.getCssValue("NONE", "background-color", SimpleSelector.DEFAULT);
                break;
            }
            case 21: {
                value = ThemeUtil.getCssValue("NONE", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 24: {
                value = ThemeUtil.getCssValue("List", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 25: {
                value = ThemeUtil.getCssValue("List", "background-color", SimpleSelector.DEFAULT);
                break;
            }
            case 26: {
                value = ThemeUtil.getCssValue("List-Item", "background-color", SimpleSelector.SELECTED);
                break;
            }
            case 27: {
                value = ThemeUtil.getCssValue("List-Item", "color", SimpleSelector.SELECTED);
                break;
            }
            case 28: {
                value = ThemeUtil.getCssValue("ToolTip", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 29: {
                value = ThemeUtil.getCssValue("Display", "rwt-infobackground-color", SimpleSelector.DEFAULT);
                break;
            }
            case 30: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 33: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "color", SimpleSelector.INACTIVE);
                break;
            }
            case 31: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-color", SimpleSelector.DEFAULT);
                break;
            }
            case 34: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-color", SimpleSelector.INACTIVE);
                break;
            }
            case 32: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-gradient-color", SimpleSelector.DEFAULT);
                break;
            }
            case 35: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-gradient-color", SimpleSelector.INACTIVE);
                break;
            }
            default: {
                result = super.getSystemColor(id);
            }
        }
        if (value != null && (result = QxColor.createColor((QxColor)value)) == null) {
            throw new IllegalArgumentException("Transparent system color");
        }
        return result;
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        Image result = null;
        QxType value = null;
        switch (id) {
            case 1: {
                value = ThemeUtil.getCssValue("Display", "rwt-error-image", SimpleSelector.DEFAULT);
                break;
            }
            case 2: 
            case 16: {
                value = ThemeUtil.getCssValue("Display", "rwt-information-image", SimpleSelector.DEFAULT);
                break;
            }
            case 4: {
                value = ThemeUtil.getCssValue("Display", "rwt-question-image", SimpleSelector.DEFAULT);
                break;
            }
            case 8: {
                value = ThemeUtil.getCssValue("Display", "rwt-warning-image", SimpleSelector.DEFAULT);
            }
        }
        if (value != null) {
            QxImage image = (QxImage)value;
            try {
                InputStream inStream = image.loader.getResourceAsStream(image.path);
                result = Graphics.getImage(image.path, inStream);
                inStream.close();
            }
            catch (IOException shouldNotHappen) {
                String txt = "Could not read system image from ''{0}''.";
                String msg = MessageFormat.format(txt, image.path);
                throw new RuntimeException(msg, shouldNotHappen);
            }
        }
        return result;
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        return ResourceFactory.getCursor(id);
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return 500;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public Point getCursorLocation() {
        this.checkDevice();
        return new Point(this.cursorLocation.x, this.cursorLocation.y);
    }

    public void addFilter(final int eventType, final Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        this.filters.add(new IDisplayAdapter.IFilterEntry(){

            public Listener getListener() {
                return listener;
            }

            public int getType() {
                return eventType;
            }
        });
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        IDisplayAdapter.IFilterEntry[] entries = this.getFilterEntries();
        boolean found = false;
        int i = 0;
        while (!found && i < entries.length) {
            boolean bl = found = entries[i].getListener() == listener && entries[i].getType() == eventType;
            if (found) {
                this.filters.remove(entries[i]);
            }
            ++i;
        }
        if (this.filters != null && this.filters.isEmpty()) {
            this.filters = null;
        }
    }

    void error(int code) {
        SWT.error(code);
    }

    void addLayoutDeferred(Composite comp) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] temp = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, temp, 0, this.layoutDeferred.length);
            this.layoutDeferred = temp;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = comp;
    }

    boolean runDeferredLayouts() {
        boolean result = false;
        if (this.layoutDeferredCount != 0) {
            Composite[] temp = this.layoutDeferred;
            int count = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int i = 0;
            while (i < count) {
                Composite comp = temp[i];
                if (!comp.isDisposed()) {
                    comp.setLayoutDeferred(false);
                }
                ++i;
            }
            result = true;
        }
        return result;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinList == null) {
            this.skinList = new Widget[1024];
        }
        if (this.skinCount >= this.skinList.length) {
            Widget[] newSkinWidgets = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, newSkinWidgets, 0, this.skinList.length);
            this.skinList = newSkinWidgets;
        }
        this.skinList[this.skinCount++] = widget;
    }

    boolean runSkin() {
        boolean result = false;
        if (this.skinCount > 0) {
            Widget[] oldSkinWidgets = this.skinList;
            int count = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            int i = 0;
            while (i < count) {
                Widget widget = oldSkinWidgets[i];
                if (widget != null && !widget.isDisposed()) {
                    widget.state &= 0xFFDFFFFF;
                    oldSkinWidgets[i] = null;
                    this.sendSkinEvent(widget);
                }
                ++i;
            }
            result = true;
        }
        return result;
    }

    private void sendSkinEvent(Widget widget) {
        Event event = new Event();
        event.widget = widget;
        event.display = this;
        event.type = 45;
        this.notifyFilters(event);
        if (this.skinListeners != null) {
            Listener[] listeners = new Listener[this.skinListeners.size()];
            this.skinListeners.toArray(listeners);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleEvent(event);
                ++i;
            }
        }
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        Monitor[] result = new Monitor[]{this.monitor};
        return result;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        return this.monitor;
    }

    public void update() {
        this.checkDevice();
    }

    public static String getAppName() {
        return appName;
    }

    public static String getAppVersion() {
        return appVersion;
    }

    public static void setAppName(String name) {
        appName = name;
    }

    public static void setAppVersion(String version) {
        appVersion = version;
    }

    static boolean isValidClass(Class clazz) {
        return true;
    }

    protected void checkDevice() {
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    private void readInitialBounds() {
        HttpServletRequest request = ContextProvider.getRequest();
        String widthVal = request.getParameter(AVAILABLE_WIDTH);
        int width = 1024;
        if (widthVal != null) {
            width = Integer.parseInt(widthVal);
        }
        String heightVal = request.getParameter(AVAILABLE_HEIGHT);
        int height = 768;
        if (heightVal != null) {
            height = Integer.parseInt(heightVal);
        }
        this.bounds = new Rectangle(0, 0, width, height);
    }

    private void readScrollBarSize() {
        String parameterName;
        this.scrollBarSize = 16;
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter(parameterName = String.valueOf(DisplayUtil.getId(this)) + ".scrollbar.size");
        if (value != null) {
            this.scrollBarSize = Integer.parseInt(value);
        }
    }

    private void notifyFilters(Event event) {
        IDisplayAdapter.IFilterEntry[] filterEntries = this.getFilterEntries();
        int i = 0;
        while (i < filterEntries.length) {
            if (filterEntries[i].getType() == event.type) {
                try {
                    filterEntries[i].getListener().handleEvent(event);
                }
                catch (Throwable thr) {
                    String msg = "Exception while executing filter.";
                    ServletLog.log(msg, thr);
                }
            }
            ++i;
        }
    }

    private IDisplayAdapter.IFilterEntry[] getFilterEntries() {
        IDisplayAdapter.IFilterEntry[] result = IDisplayAdapter.EMPTY_FILTERS;
        if (this.filters != null) {
            result = new IDisplayAdapter.IFilterEntry[this.filters.size()];
            this.filters.toArray(result);
        }
        return result;
    }

    private final class DisplayAdapter
    implements IDisplayAdapter {
        private final ISessionStore session;

        private DisplayAdapter(ISessionStore session) {
            this.session = session;
        }

        public void setBounds(Rectangle bounds) {
            if (bounds == null) {
                SWT.error(4);
            }
            Display.this.bounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        }

        public void setCursorLocation(int x, int y) {
            ((Display)Display.this).cursorLocation.x = x;
            ((Display)Display.this).cursorLocation.y = y;
        }

        public void setActiveShell(Shell activeShell) {
            Display.this.setActiveShell(activeShell);
        }

        public void setFocusControl(Control focusControl) {
            Display.this.setFocusControl(focusControl);
        }

        public void invalidateFocus() {
            RWT.getServiceStore().setAttribute(ATTR_INVALIDATE_FOCUS, Boolean.TRUE);
        }

        public boolean isFocusInvalidated() {
            IServiceStore serviceStore = RWT.getServiceStore();
            Object value = serviceStore.getAttribute(ATTR_INVALIDATE_FOCUS);
            return value != null;
        }

        public Shell[] getShells() {
            Shell[] result = new Shell[Display.this.shells.size()];
            Display.this.shells.toArray(result);
            return result;
        }

        public ISessionStore getSession() {
            return this.session;
        }

        public IDisplayAdapter.IFilterEntry[] getFilters() {
            return Display.this.getFilterEntries();
        }

        public void setScrollBarSize(int size) {
            Display.this.scrollBarSize = size;
        }

        public int getScrollBarSize() {
            return Display.this.scrollBarSize;
        }
    }
}

