/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.browser.browserkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.rwt.internal.resources.ResourceManager;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.internal.widgets.IBrowserAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class BrowserLCA
extends AbstractWidgetLCA {
    static final String BLANK_HTML = "<html><script></script></html>";
    private static final String QX_TYPE = "org.eclipse.swt.browser.Browser";
    private static final String QX_FIELD_SOURCE = "source";
    private static final String PARAM_EXECUTE_RESULT = "executeResult";
    static final String PARAM_EXECUTE_FUNCTION = "executeFunction";
    static final String PARAM_EXECUTE_ARGUMENTS = "executeArguments";
    static final String EXECUTED_FUNCTION_NAME;
    static final String EXECUTED_FUNCTION_RESULT;
    static final String EXECUTED_FUNCTION_ERROR;
    private static final String FUNCTIONS_TO_CREATE;
    private static final String FUNCTIONS_TO_DESTROY;
    private static final String PROP_URL = "url";
    private static final String PROP_TEXT = "text";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName(QX_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EXECUTED_FUNCTION_NAME = String.valueOf(clazz.getName()) + "#executedFunctionName.";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName(QX_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EXECUTED_FUNCTION_RESULT = String.valueOf(clazz2.getName()) + "#executedFunctionResult.";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName(QX_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EXECUTED_FUNCTION_ERROR = String.valueOf(clazz3.getName()) + "#executedFunctionError.";
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName(QX_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FUNCTIONS_TO_CREATE = String.valueOf(clazz4.getName()) + "#functionsToCreate.";
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName(QX_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FUNCTIONS_TO_DESTROY = String.valueOf(clazz5.getName()) + "#functionsToDestroy.";
    }

    public void preserveValues(Widget widget) {
        Browser browser = (Browser)widget;
        ControlLCAUtil.preserveValues((Control)browser);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)browser);
        adapter.preserve(PROP_URL, (Object)browser.getUrl());
        adapter.preserve(PROP_TEXT, (Object)BrowserLCA.getText(browser));
        WidgetLCAUtil.preserveCustomVariant((Widget)browser);
    }

    public void readData(Widget widget) {
        Browser browser = (Browser)widget;
        String value = WidgetLCAUtil.readPropertyValue((Widget)browser, PARAM_EXECUTE_RESULT);
        if (value != null) {
            boolean executeResult = Boolean.valueOf(value);
            BrowserLCA.getAdapter(browser).setExecuteResult(executeResult);
        }
        this.executeFunction(browser);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Browser browser = (Browser)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)browser);
        writer.newWidget(QX_TYPE);
        ControlLCAUtil.writeStyleFlags((Control)browser);
    }

    public void renderChanges(Widget widget) throws IOException {
        Browser browser = (Browser)widget;
        ControlLCAUtil.writeChanges((Control)browser);
        BrowserLCA.destroyBrowserFunctions(browser);
        BrowserLCA.writeUrl(browser);
        BrowserLCA.createBrowserFunctions(browser);
        BrowserLCA.writeExecute(browser);
        BrowserLCA.writeFunctionResult(browser);
        WidgetLCAUtil.writeCustomVariant((Widget)browser);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void writeUrl(Browser browser) throws IOException {
        if (BrowserLCA.hasUrlChanged(browser)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)browser);
            writer.set(QX_FIELD_SOURCE, BrowserLCA.getUrl(browser));
        }
    }

    static boolean hasUrlChanged(Browser browser) {
        boolean initialized = WidgetUtil.getAdapter((Widget)browser).isInitialized();
        return !initialized || WidgetLCAUtil.hasChanged((Widget)browser, PROP_TEXT, BrowserLCA.getText(browser)) || WidgetLCAUtil.hasChanged((Widget)browser, PROP_URL, browser.getUrl());
    }

    static String getUrl(Browser browser) throws IOException {
        String text = BrowserLCA.getText(browser);
        String url = browser.getUrl();
        String result = !"".equals(text.trim()) ? BrowserLCA.registerHtml(text) : (!"".equals(url.trim()) ? url : BrowserLCA.registerHtml(BLANK_HTML));
        return result;
    }

    private static void writeExecute(Browser browser) throws IOException {
        IBrowserAdapter adapter = BrowserLCA.getAdapter(browser);
        String executeScript = adapter.getExecuteScript();
        if (executeScript != null) {
            JSWriter writer = JSWriter.getWriterFor((Widget)browser);
            writer.call("execute", new Object[]{executeScript});
        }
    }

    private static String registerHtml(String html) throws IOException {
        String name = BrowserLCA.createUrlFromHtml(html);
        byte[] bytes = html.getBytes("UTF-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ResourceManager.getInstance().register(name, (InputStream)inputStream);
        return ResourceManager.getInstance().getLocation(name);
    }

    private static String createUrlFromHtml(String html) {
        StringBuffer result = new StringBuffer();
        result.append("org.eclipse.swt.browser/text");
        result.append(String.valueOf(html.hashCode()));
        result.append(".html");
        return result.toString();
    }

    private static String getText(Browser browser) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IBrowserAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = browser.getAdapter((Class)clazz);
        IBrowserAdapter browserAdapter = (IBrowserAdapter)adapter;
        return browserAdapter.getText();
    }

    private static IBrowserAdapter getAdapter(Browser browser) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IBrowserAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IBrowserAdapter)browser.getAdapter((Class)clazz);
    }

    private static void createBrowserFunctions(Browser browser) throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        String[] functions = (String[])stateInfo.getAttribute(String.valueOf(FUNCTIONS_TO_CREATE) + id);
        if (functions != null) {
            int i = 0;
            while (i < functions.length) {
                JSWriter writer = JSWriter.getWriterFor((Widget)browser);
                writer.call("createFunction", new Object[]{functions[i]});
                ++i;
            }
        }
    }

    private static void destroyBrowserFunctions(Browser browser) throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        String[] functions = (String[])stateInfo.getAttribute(String.valueOf(FUNCTIONS_TO_DESTROY) + id);
        if (functions != null) {
            int i = 0;
            while (i < functions.length) {
                JSWriter writer = JSWriter.getWriterFor((Widget)browser);
                writer.call("destroyFunction", new Object[]{functions[i]});
                ++i;
            }
        }
    }

    private void executeFunction(final Browser browser) {
        String function = WidgetLCAUtil.readPropertyValue((Widget)browser, PARAM_EXECUTE_FUNCTION);
        String arguments = WidgetLCAUtil.readPropertyValue((Widget)browser, PARAM_EXECUTE_ARGUMENTS);
        if (function != null) {
            IBrowserAdapter adapter = BrowserLCA.getAdapter(browser);
            BrowserFunction[] functions = adapter.getBrowserFunctions();
            boolean found = false;
            int i = 0;
            while (i < functions.length && !found) {
                final BrowserFunction current = functions[i];
                if (current.getName().equals(function)) {
                    final Object[] args = BrowserLCA.parseArguments(arguments);
                    ProcessActionRunner.add((Runnable)new Runnable(){

                        public void run() {
                            try {
                                BrowserLCA.setExecutedFunctionName(browser, current.getName());
                                Object executedFunctionResult = current.function(args);
                                BrowserLCA.setExecutedFunctionResult(browser, executedFunctionResult);
                            }
                            catch (Exception e) {
                                BrowserLCA.setExecutedFunctionError(browser, e.getMessage());
                            }
                        }
                    });
                    found = true;
                }
                ++i;
            }
        }
    }

    private static void writeFunctionResult(Browser browser) throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        String function = (String)stateInfo.getAttribute(String.valueOf(EXECUTED_FUNCTION_NAME) + id);
        if (function != null) {
            Object result = stateInfo.getAttribute(String.valueOf(EXECUTED_FUNCTION_RESULT) + id);
            if (result != null) {
                result = new JSVar(BrowserLCA.toJson(result, true));
            }
            String error = (String)stateInfo.getAttribute(String.valueOf(EXECUTED_FUNCTION_ERROR) + id);
            JSWriter writer = JSWriter.getWriterFor((Widget)browser);
            writer.call("setFunctionResult", new Object[]{result, error});
        }
    }

    private static void setExecutedFunctionName(Browser browser, String name) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        stateInfo.setAttribute(String.valueOf(EXECUTED_FUNCTION_NAME) + id, (Object)name);
    }

    private static void setExecutedFunctionResult(Browser browser, Object result) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        stateInfo.setAttribute(String.valueOf(EXECUTED_FUNCTION_RESULT) + id, result);
    }

    private static void setExecutedFunctionError(Browser browser, String error) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        String id = WidgetUtil.getId((Widget)browser);
        stateInfo.setAttribute(String.valueOf(EXECUTED_FUNCTION_ERROR) + id, (Object)error);
    }

    static Object[] parseArguments(String arguments) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (arguments.startsWith("[") && arguments.endsWith("]")) {
            String arg;
            String args = arguments.substring(1, arguments.length() - 1);
            int openQuotes = 0;
            int openBrackets = 0;
            StringBuffer argBuff = new StringBuffer();
            int prevChar = 32;
            int i = 0;
            while (i < args.length()) {
                char ch = args.charAt(i);
                if (ch == ',' && openQuotes == 0 && openBrackets == 0) {
                    arg = argBuff.toString();
                    if (arg.startsWith("[")) {
                        result.add(BrowserLCA.parseArguments(arg));
                    } else {
                        arg = arg.replaceAll("\\\\\"", "\"");
                        result.add(BrowserLCA.withType(arg));
                    }
                    argBuff.setLength(0);
                } else {
                    if (ch == '\"' && prevChar != 92) {
                        openQuotes = openQuotes == 0 ? ++openQuotes : --openQuotes;
                    } else if (ch == '[' && openQuotes == 0) {
                        ++openBrackets;
                    } else if (ch == ']' && openQuotes == 0) {
                        --openBrackets;
                    }
                    argBuff.append(ch);
                }
                prevChar = ch;
                ++i;
            }
            arg = argBuff.toString();
            if (arg.startsWith("[")) {
                result.add(BrowserLCA.parseArguments(arg));
            } else if (!arg.equals("")) {
                arg = arg.replaceAll("\\\\\"", "\"");
                result.add(BrowserLCA.withType(arg));
            }
        }
        return result.toArray();
    }

    static Object withType(String argument) {
        Object result;
        if (argument.equals("null") || argument.equals("undefined")) {
            result = null;
        } else if (argument.equals("true") || argument.equals("false")) {
            result = new Boolean(argument);
        } else if (argument.startsWith("\"")) {
            result = new String(argument.substring(1, argument.length() - 1));
        } else {
            try {
                result = Double.valueOf(argument);
            }
            catch (NumberFormatException numberFormatException) {
                result = argument;
            }
        }
        return result;
    }

    static String toJson(Object object, boolean deleteLastChar) {
        StringBuffer result = new StringBuffer();
        if (object == null) {
            result.append("null");
            result.append(",");
        } else if (object instanceof String) {
            result.append("\"");
            result.append((String)object);
            result.append("\"");
            result.append(",");
        } else if (object instanceof Boolean) {
            result.append(((Boolean)object).toString());
            result.append(",");
        } else if (object instanceof Number) {
            result.append(((Number)object).toString());
            result.append(",");
        } else if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            result.append("[");
            int i = 0;
            while (i < array.length) {
                result.append(BrowserLCA.toJson(array[i], false));
                ++i;
            }
            result.insert(result.length() - 1, "]");
        }
        if (deleteLastChar) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }
}

