/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menukit;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.internal.widgets.menukit.MenuDelegateLCA;
import org.eclipse.swt.internal.widgets.menukit.MenuLCAUtil;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

final class DropDownMenuLCA
extends MenuDelegateLCA {
    DropDownMenuLCA() {
    }

    void preserveValues(Menu menu) {
        MenuLCAUtil.preserveEnabled(menu);
        MenuLCAUtil.preserveMenuListener(menu);
        MenuLCAUtil.preserveWidth(menu);
        WidgetLCAUtil.preserveCustomVariant((Widget)menu);
        WidgetLCAUtil.preserveHelpListener((Widget)menu);
    }

    void readData(Menu menu) {
        MenuLCAUtil.readMenuEvent(menu);
        WidgetLCAUtil.processHelp((Widget)menu);
    }

    void renderInitialization(Menu menu) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)menu);
        writer.newWidget("org.eclipse.rwt.widgets.Menu");
        MenuItem[] menuItems = DropDownMenuLCA.findReferringMenuItems(menu);
        int i = 0;
        while (i < menuItems.length) {
            writer.call((Widget)menuItems[i], "setMenu", new Object[]{menu});
            ++i;
        }
    }

    void renderChanges(Menu menu) throws IOException {
        MenuLCAUtil.writeEnabled(menu);
        MenuLCAUtil.writeMenuListener(menu);
        MenuLCAUtil.writeUnhideMenu(menu);
        WidgetLCAUtil.writeCustomVariant((Widget)menu);
        WidgetLCAUtil.writeHelpListener((Widget)menu);
    }

    private static MenuItem[] findReferringMenuItems(final Menu menu) {
        final ArrayList menuItems = new ArrayList();
        Decorations parent = menu.getParent();
        WidgetTreeVisitor.accept((Widget)parent, (WidgetTreeVisitor)new WidgetTreeVisitor.AllWidgetTreeVisitor(){

            public boolean doVisit(Widget widget) {
                MenuItem menuItem;
                if (widget instanceof MenuItem && (menuItem = (MenuItem)widget).getMenu() == menu) {
                    menuItems.add(menuItem);
                }
                return true;
            }
        });
        MenuItem[] result = new MenuItem[menuItems.size()];
        menuItems.toArray(result);
        return result;
    }
}

