/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablecolumnkit;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.lifecycle.JSConst;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.tablekit.TableLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public final class TableColumnLCA
extends AbstractWidgetLCA {
    static final String PROP_LEFT = "left";
    static final String PROP_WIDTH = "width";
    static final String PROP_Z_INDEX = "zIndex";
    static final String PROP_SORT_DIRECTION = "sortDirection";
    static final String PROP_RESIZABLE = "resizable";
    static final String PROP_MOVEABLE = "moveable";
    private static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    private static final Integer DEFAULT_LEFT = new Integer(0);
    private static final JSListenerInfo SELECTION_LISTENER = new JSListenerInfo("click", "this.onClick", JSListenerType.ACTION);
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        TableColumn column = (TableColumn)widget;
        ItemLCAUtil.preserve((Item)column);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)column);
        WidgetLCAUtil.preserveToolTipText((Widget)column, column.getToolTipText());
        TableLCAUtil.preserveAlignment(column);
        adapter.preserve(PROP_Z_INDEX, (Object)new Integer(TableColumnLCA.getZIndex(column)));
        adapter.preserve(PROP_LEFT, (Object)new Integer(TableColumnLCA.getLeft(column)));
        adapter.preserve(PROP_WIDTH, (Object)new Integer(column.getWidth()));
        adapter.preserve(PROP_SORT_DIRECTION, (Object)TableColumnLCA.getSortDirection(column));
        adapter.preserve(PROP_RESIZABLE, (Object)column.getResizable());
        adapter.preserve(PROP_MOVEABLE, (Object)column.getMoveable());
        adapter.preserve(PROP_SELECTION_LISTENERS, (Object)SelectionEvent.hasListener((Adaptable)column));
        WidgetLCAUtil.preserveCustomVariant((Widget)column);
    }

    public void readData(Widget widget) {
        final TableColumn column = (TableColumn)widget;
        String value = WidgetLCAUtil.readPropertyValue((Widget)column, PROP_WIDTH);
        if (value != null) {
            final int newWidth = Integer.parseInt(value);
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    column.setWidth(newWidth);
                }
            });
        }
        if ((value = WidgetLCAUtil.readPropertyValue((Widget)column, PROP_LEFT)) != null) {
            final int newLeft = Integer.parseInt(value);
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    TableColumnLCA.moveColumn(column, newLeft);
                }
            });
        }
        ControlLCAUtil.processSelection((Widget)column, null, false);
    }

    public void renderInitialization(Widget widget) throws IOException {
        TableColumn column = (TableColumn)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Object[] args = new Object[]{column.getParent()};
        writer.newWidget("org.eclipse.swt.widgets.TableColumn", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        TableColumn column = (TableColumn)widget;
        ItemLCAUtil.writeChanges((Item)column);
        TableColumnLCA.writeLeft(column);
        TableColumnLCA.writeWidth(column);
        TableColumnLCA.writeZIndex(column);
        WidgetLCAUtil.writeToolTip((Widget)column, column.getToolTipText());
        TableColumnLCA.writeSortDirection(column);
        TableColumnLCA.writeResizable(column);
        TableColumnLCA.writeMoveable(column);
        TableColumnLCA.writeAlignment(column);
        TableColumnLCA.writeSelectionListener(column);
        WidgetLCAUtil.writeCustomVariant((Widget)column);
    }

    public void renderDispose(Widget widget) throws IOException {
        TableColumn column = (TableColumn)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        writer.dispose();
    }

    private static void writeLeft(TableColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Integer newValue = new Integer(TableColumnLCA.getLeft(column));
        writer.set(PROP_LEFT, PROP_LEFT, newValue, DEFAULT_LEFT);
    }

    private static void writeWidth(TableColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Integer newValue = new Integer(column.getWidth());
        writer.set(PROP_WIDTH, PROP_WIDTH, newValue, null);
    }

    private static void writeZIndex(TableColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Integer newValue = new Integer(TableColumnLCA.getZIndex(column));
        writer.set(PROP_Z_INDEX, PROP_Z_INDEX, newValue, null);
    }

    private static void writeSortDirection(TableColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        String newValue = TableColumnLCA.getSortDirection(column);
        writer.set(PROP_SORT_DIRECTION, PROP_SORT_DIRECTION, newValue, null);
    }

    private static void writeResizable(TableColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Boolean newValue = column.getResizable();
        writer.set(PROP_RESIZABLE, PROP_RESIZABLE, newValue, Boolean.TRUE);
    }

    private static void writeMoveable(TableColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Boolean newValue = column.getMoveable();
        writer.set(PROP_MOVEABLE, PROP_MOVEABLE, newValue, Boolean.FALSE);
    }

    private static void writeAlignment(TableColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        if (TableLCAUtil.hasAlignmentChanged(column)) {
            Integer newValue = new Integer(column.getAlignment());
            JSVar alignment = JSConst.QX_CONST_ALIGN_LEFT;
            if (newValue == 0x1000000) {
                alignment = JSConst.QX_CONST_ALIGN_CENTER;
            } else if (newValue == 131072) {
                alignment = JSConst.QX_CONST_ALIGN_RIGHT;
            }
            writer.set("horizontalChildrenAlign", new Object[]{alignment});
        }
    }

    private static void writeSelectionListener(TableColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        writer.updateListener(SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)column));
    }

    static int getLeft(TableColumn column) {
        Table table = column.getParent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = table.getAdapter((Class)clazz);
        ITableAdapter tableAdapter = (ITableAdapter)adapter;
        return tableAdapter.getColumnLeft(column);
    }

    static int getZIndex(TableColumn column) {
        return ControlLCAUtil.getZIndex((Control)column.getParent()) + 1;
    }

    static String getSortDirection(TableColumn column) {
        String result = null;
        Table table = column.getParent();
        if (table.getSortColumn() == column) {
            if (table.getSortDirection() == 128) {
                result = "up";
            } else if (table.getSortDirection() == 1024) {
                result = "down";
            }
        }
        return result;
    }

    static void moveColumn(TableColumn column, int newLeft) {
        Table table = column.getParent();
        int targetColumn = TableColumnLCA.findMoveTarget(table, newLeft);
        int[] columnOrder = table.getColumnOrder();
        int index = table.indexOf(column);
        int orderIndex = TableColumnLCA.arrayIndexOf(columnOrder, index);
        columnOrder = TableColumnLCA.arrayRemove(columnOrder, orderIndex);
        if (orderIndex < targetColumn) {
            --targetColumn;
        }
        if (Arrays.equals(columnOrder = TableColumnLCA.arrayInsert(columnOrder, targetColumn, index), table.getColumnOrder())) {
            TableColumn[] columns = table.getColumns();
            int i = 0;
            while (i < columns.length) {
                IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)columns[i]);
                adapter.preserve(PROP_LEFT, null);
                ++i;
            }
        } else {
            table.setColumnOrder(columnOrder);
        }
    }

    private static int findMoveTarget(Table table, int newLeft) {
        int result = -1;
        TableColumn[] columns = table.getColumns();
        int[] columnOrder = table.getColumnOrder();
        if (newLeft < 0) {
            result = 0;
        } else {
            int i = 0;
            while (result == -1 && i < columns.length) {
                int left = TableColumnLCA.getLeft(columns[columnOrder[i]]);
                int width = columns[columnOrder[i]].getWidth();
                if (newLeft >= left && newLeft <= left + width) {
                    result = i;
                    if (newLeft >= left + width / 2 && result < columns.length) {
                        ++result;
                    }
                }
                ++i;
            }
        }
        if (result == -1) {
            result = columns.length;
        }
        return result;
    }

    private static int arrayIndexOf(int[] array, int value) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < array.length) {
            if (array[i] == value) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private static int[] arrayRemove(int[] array, int index) {
        int length = array.length;
        int[] result = new int[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    private static int[] arrayInsert(int[] array, int index, int value) {
        int length = array.length;
        int[] result = new int[length + 1];
        System.arraycopy(array, 0, result, 0, length);
        System.arraycopy(result, index, result, index + 1, length - index);
        result[index] = value;
        return result;
    }
}

