/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treecolumnkit;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.lifecycle.JSConst;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public final class TreeColumnLCA
extends AbstractWidgetLCA {
    static final String PROP_LEFT = "left";
    static final String PROP_WIDTH = "width";
    static final String PROP_Z_INDEX = "zIndex";
    static final String PROP_SORT_DIRECTION = "sortDirection";
    static final String PROP_RESIZABLE = "resizable";
    static final String PROP_MOVEABLE = "moveable";
    static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    private static final Integer DEFAULT_LEFT = new Integer(0);
    private static final Integer DEFAULT_ALIGNMENT = new Integer(16384);
    private static final JSListenerInfo SELECTION_LISTENER = new JSListenerInfo("click", "this.onClick", JSListenerType.ACTION);

    public void preserveValues(Widget widget) {
        TreeColumn column = (TreeColumn)widget;
        ItemLCAUtil.preserve((Item)column);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)column);
        WidgetLCAUtil.preserveToolTipText((Widget)column, column.getToolTipText());
        adapter.preserve(PROP_Z_INDEX, (Object)new Integer(TreeColumnLCA.getZIndex(column)));
        adapter.preserve(PROP_LEFT, (Object)new Integer(TreeColumnLCA.getLeft(column)));
        adapter.preserve(PROP_WIDTH, (Object)new Integer(column.getWidth()));
        adapter.preserve(PROP_SORT_DIRECTION, (Object)TreeColumnLCA.getSortDirection(column));
        adapter.preserve(PROP_RESIZABLE, (Object)column.getResizable());
        adapter.preserve(PROP_MOVEABLE, (Object)column.getMoveable());
        adapter.preserve(PROP_ALIGNMENT, (Object)new Integer(column.getAlignment()));
        adapter.preserve(PROP_SELECTION_LISTENERS, (Object)SelectionEvent.hasListener((Adaptable)column));
        WidgetLCAUtil.preserveCustomVariant((Widget)column);
    }

    public void readData(Widget widget) {
        final TreeColumn column = (TreeColumn)widget;
        String value = WidgetLCAUtil.readPropertyValue((Widget)column, PROP_WIDTH);
        if (value != null) {
            final int newWidth = Integer.parseInt(value);
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    column.setWidth(newWidth);
                }
            });
        }
        if ((value = WidgetLCAUtil.readPropertyValue((Widget)column, PROP_LEFT)) != null) {
            final int newLeft = Integer.parseInt(value);
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    TreeColumnLCA.moveColumn(column, newLeft);
                }
            });
        }
        ControlLCAUtil.processSelection((Widget)column, null, false);
    }

    public void renderInitialization(Widget widget) throws IOException {
        TreeColumn column = (TreeColumn)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Object[] args = new Object[]{column.getParent()};
        writer.newWidget("org.eclipse.swt.widgets.TreeColumn", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        TreeColumn column = (TreeColumn)widget;
        ItemLCAUtil.writeChanges((Item)column);
        TreeColumnLCA.writeLeft(column);
        TreeColumnLCA.writeWidth(column);
        TreeColumnLCA.writeZIndex(column);
        WidgetLCAUtil.writeToolTip((Widget)column, column.getToolTipText());
        TreeColumnLCA.writeSortDirection(column);
        TreeColumnLCA.writeResizable(column);
        TreeColumnLCA.writeMoveable(column);
        TreeColumnLCA.writeAlignment(column);
        TreeColumnLCA.writeSelectionListener(column);
        WidgetLCAUtil.writeCustomVariant((Widget)column);
    }

    public void renderDispose(Widget widget) throws IOException {
        TreeColumn column = (TreeColumn)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        writer.dispose();
    }

    private static void writeLeft(TreeColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Integer newValue = new Integer(TreeColumnLCA.getLeft(column));
        writer.set(PROP_LEFT, PROP_LEFT, newValue, DEFAULT_LEFT);
    }

    private static void writeWidth(TreeColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Integer newValue = new Integer(column.getWidth());
        writer.set(PROP_WIDTH, PROP_WIDTH, newValue, null);
    }

    private static void writeZIndex(TreeColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Integer newValue = new Integer(TreeColumnLCA.getZIndex(column));
        writer.set(PROP_Z_INDEX, PROP_Z_INDEX, newValue, null);
    }

    private static void writeSortDirection(TreeColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        String newValue = TreeColumnLCA.getSortDirection(column);
        writer.set(PROP_SORT_DIRECTION, PROP_SORT_DIRECTION, newValue, null);
    }

    private static void writeResizable(TreeColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Boolean newValue = column.getResizable();
        writer.set(PROP_RESIZABLE, PROP_RESIZABLE, newValue, Boolean.TRUE);
    }

    private static void writeMoveable(TreeColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Boolean newValue = column.getMoveable();
        writer.set(PROP_MOVEABLE, PROP_MOVEABLE, newValue, Boolean.FALSE);
    }

    private static void writeAlignment(TreeColumn column) throws IOException {
        Integer defValue;
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        Integer newValue = new Integer(column.getAlignment());
        if (WidgetLCAUtil.hasChanged((Widget)column, PROP_ALIGNMENT, newValue, defValue = DEFAULT_ALIGNMENT)) {
            JSVar alignment = JSConst.QX_CONST_ALIGN_LEFT;
            if (newValue == 0x1000000) {
                alignment = JSConst.QX_CONST_ALIGN_CENTER;
            } else if (newValue == 131072) {
                alignment = JSConst.QX_CONST_ALIGN_RIGHT;
            }
            writer.set("horizontalChildrenAlign", new Object[]{alignment});
        }
    }

    private static void writeSelectionListener(TreeColumn column) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)column);
        writer.updateListener(SELECTION_LISTENER, PROP_SELECTION_LISTENERS, SelectionEvent.hasListener((Adaptable)column));
    }

    static int getLeft(TreeColumn column) {
        Tree parent = column.getParent();
        int result = 0;
        TreeColumn[] columns = parent.getColumns();
        int[] columnOrder = parent.getColumnOrder();
        int orderedIndex = -1;
        int i = 0;
        while (orderedIndex == -1 && i < columnOrder.length) {
            if (columnOrder[i] == parent.indexOf(column)) {
                orderedIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < orderedIndex) {
            result += columns[columnOrder[i]].getWidth();
            ++i;
        }
        return result;
    }

    static int getZIndex(TreeColumn column) {
        return ControlLCAUtil.getZIndex((Control)column.getParent()) + 1;
    }

    static String getSortDirection(TreeColumn column) {
        String result = null;
        Tree tree = column.getParent();
        if (tree.getSortColumn() == column) {
            if (tree.getSortDirection() == 128) {
                result = "up";
            } else if (tree.getSortDirection() == 1024) {
                result = "down";
            }
        }
        return result;
    }

    static void moveColumn(TreeColumn column, int newLeft) {
        Tree tree = column.getParent();
        int targetColumn = TreeColumnLCA.findMoveTarget(tree, newLeft);
        int[] columnOrder = tree.getColumnOrder();
        int index = tree.indexOf(column);
        int orderIndex = TreeColumnLCA.arrayIndexOf(columnOrder, index);
        columnOrder = TreeColumnLCA.arrayRemove(columnOrder, orderIndex);
        if (orderIndex < targetColumn) {
            --targetColumn;
        }
        if (Arrays.equals(columnOrder = TreeColumnLCA.arrayInsert(columnOrder, targetColumn, index), tree.getColumnOrder())) {
            TreeColumn[] columns = tree.getColumns();
            int i = 0;
            while (i < columns.length) {
                IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)columns[i]);
                adapter.preserve(PROP_LEFT, null);
                ++i;
            }
        } else {
            tree.setColumnOrder(columnOrder);
        }
    }

    private static int findMoveTarget(Tree tree, int newLeft) {
        int result = -1;
        TreeColumn[] columns = tree.getColumns();
        int[] columnOrder = tree.getColumnOrder();
        if (newLeft < 0) {
            result = 0;
        } else {
            int i = 0;
            while (result == -1 && i < columns.length) {
                int left = TreeColumnLCA.getLeft(columns[i]);
                int width = columns[i].getWidth();
                if (newLeft >= left && newLeft <= left + width) {
                    result = columnOrder[i];
                    if (newLeft >= left + width / 2 && result < columns.length) {
                        ++result;
                    }
                }
                ++i;
            }
        }
        if (result == -1) {
            result = columns.length;
        }
        return result;
    }

    private static int arrayIndexOf(int[] array, int value) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < array.length) {
            if (array[i] == value) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private static int[] arrayRemove(int[] array, int index) {
        int length = array.length;
        int[] result = new int[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    private static int[] arrayInsert(int[] array, int index, int value) {
        int length = array.length;
        int[] result = new int[length + 1];
        System.arraycopy(array, 0, result, 0, length);
        System.arraycopy(result, index, result, index + 1, length - index);
        result[index] = value;
        return result;
    }
}

