/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.launch;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabDataSource;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabWidgetListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public abstract class BaseRMLaunchConfigurationDynamicTab
implements IRMLaunchConfigurationDynamicTab {
    private final ListenerList listenerList = new ListenerList();
    private final RMLaunchConfigurationDynamicTabDataSource dataSource = this.createDataSource();
    private final RMLaunchConfigurationDynamicTabWidgetListener widgetListener = this.createListener();

    protected abstract RMLaunchConfigurationDynamicTabWidgetListener createListener();

    protected abstract RMLaunchConfigurationDynamicTabDataSource createDataSource();

    protected RMLaunchConfigurationDynamicTabWidgetListener getListener() {
        return this.widgetListener;
    }

    protected RMLaunchConfigurationDynamicTabDataSource getDataSource() {
        return this.dataSource;
    }

    public void addContentsChangedListener(IRMLaunchConfigurationContentsChangedListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeContentsChangedListener(IRMLaunchConfigurationContentsChangedListener listener) {
        this.listenerList.remove((Object)listener);
    }

    protected void fireContentsChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRMLaunchConfigurationContentsChangedListener)listener).handleContentsChanged((IRMLaunchConfigurationDynamicTab)this);
            ++n2;
        }
    }

    public RMLaunchValidation canSave(Control control, IResourceManager rm, IPQueue queue) {
        if (this.dataSource.canSave()) {
            return new RMLaunchValidation(true, null);
        }
        return new RMLaunchValidation(false, this.dataSource.getErrorMessage());
    }

    public RMLaunchValidation isValid(ILaunchConfiguration launchConfig, IResourceManager rm, IPQueue queue) {
        if (this.dataSource.canAccept()) {
            return new RMLaunchValidation(true, null);
        }
        return new RMLaunchValidation(false, this.dataSource.getErrorMessage());
    }

    public RMLaunchValidation initializeFrom(Control control, IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration) {
        this.dataSource.setResourceManager(rm);
        this.dataSource.setQueue(queue);
        this.dataSource.setConfiguration(configuration);
        this.widgetListener.disable();
        this.dataSource.loadAndUpdate();
        this.widgetListener.enable();
        if (this.dataSource.getErrorMessage() == null) {
            return new RMLaunchValidation(true, null);
        }
        return new RMLaunchValidation(false, this.dataSource.getErrorMessage());
    }

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        this.dataSource.setResourceManager(rm);
        this.dataSource.setQueue(queue);
        this.dataSource.setConfigurationWorkingCopy(configuration);
        this.dataSource.storeAndValidate();
        if (this.dataSource.getErrorMessage() == null) {
            return new RMLaunchValidation(true, null);
        }
        return new RMLaunchValidation(false, this.dataSource.getErrorMessage());
    }

    public abstract Image getImage();

    public abstract String getText();

    public abstract void updateControls();
}

