/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rap.ui.internal.intro.target.InstallTargetDialog;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;
import org.eclipse.rap.ui.internal.intro.target.TargetProvider;
import org.eclipse.rap.ui.internal.intro.target.TargetSwitcher34;
import org.eclipse.rap.ui.internal.intro.target.TargetSwitcher35;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.framework.Bundle;

public class InstallRAPTargetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell shell = workbench.getActiveWorkbenchWindow().getShell();
        InstallTargetDialog dialog = new InstallTargetDialog(shell);
        int result = dialog.open();
        if (result == 0) {
            InstallRAPTargetHandler.execute(dialog.getTargetDestination(), dialog.shouldSwitchTarget());
        }
        return null;
    }

    public static void execute(final String targetDestination, final boolean switchTarget) throws ExecutionException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    TargetProvider.install(targetDestination, monitor);
                    if (switchTarget) {
                        InstallRAPTargetHandler.switchTarget(targetDestination, monitor);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            String msg = IntroMessages.InstallRAPTargetHandler_InstallFailed;
            throw new ExecutionException(msg, cause);
        }
        catch (InterruptedException interruptedException) {
            String msg = IntroMessages.InstallRAPTargetHandler_InstallInterrupted;
            throw new ExecutionException(msg);
        }
    }

    private static void switchTarget(String targetDestination, IProgressMonitor monitor) throws CoreException {
        if (InstallRAPTargetHandler.isPDECore34()) {
            TargetSwitcher34.switchTarget(targetDestination, monitor);
        } else {
            TargetSwitcher35.switchTarget(targetDestination, monitor);
        }
    }

    private static boolean isPDECore34() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.pde.core");
        Dictionary headers = bundle.getHeaders();
        String version = (String)headers.get("Bundle-Version");
        return version.startsWith("3.4");
    }
}

