/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.rap.ui.internal.intro.Images;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;
import org.eclipse.rap.ui.internal.intro.target.TargetProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class InstallTargetDialog
extends TitleAreaDialog {
    private boolean shouldSwitchTarget = true;
    private String targetDestination;
    private Image titleImage;
    private Text txtPath;

    public InstallTargetDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(112);
        this.setHelpAvailable(false);
    }

    public boolean shouldSwitchTarget() {
        return this.shouldSwitchTarget;
    }

    public String getTargetDestination() {
        return this.targetDestination;
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.configureDialog();
        this.createTargetLocationArea(result);
        this.createSwitchTargetArea(result);
        this.txtPath.setText(TargetProvider.getDefaultTargetDestination());
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void okPressed() {
        this.targetDestination = this.txtPath.getText();
        super.okPressed();
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        return super.close();
    }

    private void configureDialog() {
        this.getShell().setText(IntroMessages.InstallDialog_ShellTitle);
        this.setTitle(IntroMessages.InstallDialog_DialogTitle);
        if (this.titleImage == null) {
            this.titleImage = Images.EXTRACT_TARGET.createImage(false);
        }
        this.setTitleImage(this.titleImage);
        this.setMessage(IntroMessages.InstallDialog_Message_selectLocation);
    }

    private void createTargetLocationArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblPath = new Label(container, 0);
        lblPath.setText(IntroMessages.InstallDialog_Location);
        this.txtPath = new Text(container, 2048);
        this.txtPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstallTargetDialog.this.validateLocation();
            }
        });
        Button browse = new Button(container, 8);
        browse.setText(IntroMessages.InstallDialog_Browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String location;
                DirectoryDialog dialog = new DirectoryDialog(InstallTargetDialog.this.getShell());
                dialog.setText(IntroMessages.InstallDialog_Message_selectDirText);
                dialog.setMessage(IntroMessages.InstallDialog_Message_selectDirMsg);
                if (InstallTargetDialog.this.txtPath.getText().length() > 0) {
                    dialog.setFilterPath(InstallTargetDialog.this.txtPath.getText());
                }
                if ((location = dialog.open()) != null) {
                    InstallTargetDialog.this.txtPath.setText(location);
                }
            }
        });
    }

    private void createSwitchTargetArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        FillLayout layout = new FillLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        container.setLayout((Layout)layout);
        Group grgTarget = new Group(container, 0);
        grgTarget.setLayout((Layout)new GridLayout());
        grgTarget.setText(IntroMessages.InstallDialog_TargetGroup);
        final Button switchTarget = new Button((Composite)grgTarget, 32);
        switchTarget.setText(IntroMessages.InstallDialog_switchTarget);
        switchTarget.setSelection(true);
        switchTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallTargetDialog.this.shouldSwitchTarget = switchTarget.getSelection();
            }
        });
        Label lblDescription = new Label((Composite)grgTarget, 64);
        GridData gridData = new GridData(768);
        gridData.widthHint = 120;
        lblDescription.setLayoutData((Object)gridData);
        lblDescription.setText(IntroMessages.InstallDialog_TargetDescription);
    }

    private void validateLocation() {
        boolean isValid;
        boolean bl = isValid = this.txtPath.getText().length() > 0;
        if (isValid) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(IntroMessages.InstallDialog_validPath);
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(isValid);
        }
    }
}

