/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.map.MapProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;

public class BeanMapPropertyDecorator
extends MapProperty
implements IBeanMapProperty {
    private final IMapProperty delegate;
    private final PropertyDescriptor propertyDescriptor;

    public BeanMapPropertyDecorator(IMapProperty delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Object getKeyType() {
        return this.delegate.getKeyType();
    }

    public Object getValueType() {
        return this.delegate.getValueType();
    }

    public IBeanMapProperty values(String propertyName) {
        return this.values(propertyName, null);
    }

    public IBeanMapProperty values(String propertyName, Class valueType) {
        Class beanClass = (Class)this.delegate.getValueType();
        return this.values(BeanProperties.value(beanClass, propertyName, valueType));
    }

    public IBeanMapProperty values(IBeanValueProperty property) {
        return new BeanMapPropertyDecorator(super.values((IValueProperty)property), property.getPropertyDescriptor());
    }

    public IObservableMap observe(Object source) {
        return new BeanObservableMapDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableMap observe(Realm realm, Object source) {
        return new BeanObservableMapDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public IObservableFactory mapFactory() {
        return this.delegate.mapFactory();
    }

    public IObservableFactory mapFactory(Realm realm) {
        return this.delegate.mapFactory(realm);
    }

    public IObservableMap observeDetail(IObservableValue master) {
        return new BeanObservableMapDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

